/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.security.pki;

import com.github.toolarium.security.certificate.impl.CertificateConverter;
import com.github.toolarium.security.pki.IKeyConverter;
import com.github.toolarium.security.pki.impl.DSAKeyConverter;
import com.github.toolarium.security.pki.impl.ECKeyConverter;
import com.github.toolarium.security.pki.impl.RSAKeyConverter;
import java.security.PrivateKey;
import java.security.PublicKey;

public final class KeyConverterFactory {
    private KeyConverterFactory() {
    }

    public static KeyConverterFactory getInstance() {
        return HOLDER.INSTANCE;
    }

    public IKeyConverter getConverter(PrivateKey privateKey) {
        if (privateKey == null) {
            return null;
        }
        return this.getConverter(privateKey.getAlgorithm());
    }

    public IKeyConverter getConverter(PublicKey publicKey) {
        if (publicKey == null) {
            return null;
        }
        return this.getConverter(publicKey.getAlgorithm());
    }

    public CertificateConverter getConverter() {
        return new CertificateConverter();
    }

    public IKeyConverter getConverter(Types type) {
        return this.getConverter(type.name());
    }

    public IKeyConverter getConverter(String type) {
        if ("DSA".equals(type)) {
            return new DSAKeyConverter();
        }
        if ("EC".equals(type)) {
            return new ECKeyConverter();
        }
        if ("RSA".equals(type)) {
            return new RSAKeyConverter();
        }
        return new RSAKeyConverter();
    }

    private static class HOLDER {
        static final KeyConverterFactory INSTANCE = new KeyConverterFactory();

        private HOLDER() {
        }
    }

    public static enum Types {
        RSA,
        DSA,
        EC;

    }
}

