/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.security.pki.impl;

import com.github.toolarium.common.util.FileUtil;
import com.github.toolarium.security.pki.IKeyConverter;
import com.github.toolarium.security.pki.util.PKIUtil;
import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKeyConverter
implements IKeyConverter {
    protected static final String NL = "\n";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractKeyConverter.class);
    private String provider;
    private String type;
    private int defaultSize;

    protected AbstractKeyConverter(String provider, String type, int defaultSize) {
        this.provider = provider;
        this.type = type;
        this.defaultSize = defaultSize;
    }

    @Override
    public String getProvider() {
        return this.provider;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public KeyPair generateKeyPair() throws GeneralSecurityException {
        return PKIUtil.getInstance().generateKeyPair(this.getProvider(), this.getType(), this.defaultSize);
    }

    @Override
    public KeyPair generateKeyPair(String algorithm, int keySize) throws GeneralSecurityException {
        return PKIUtil.getInstance().generateKeyPair(this.getProvider(), algorithm, keySize);
    }

    @Override
    public PublicKey getPublicKey(String content) throws IOException, GeneralSecurityException {
        if (content == null || content.length() == 0) {
            return null;
        }
        return this.getPublicKey(content.getBytes());
    }

    @Override
    public PublicKey getPublicKey(File file) throws IOException, GeneralSecurityException {
        if (file == null) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loading " + this.getType() + " public key form file '" + file + "'...");
        }
        return this.getPublicKey(FileUtil.getInstance().readFileContent(file));
    }

    @Override
    public PrivateKey getPrivateKey(byte[] content) throws IOException, GeneralSecurityException {
        return this.getPrivateKey(new String(content));
    }

    @Override
    public PrivateKey getPrivateKey(String content) throws GeneralSecurityException {
        if (content == null || content.length() == 0) {
            return null;
        }
        String normalizedData = this.normalizePKCS8(content);
        PKCS8EncodedKeySpec privKeySpec = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(normalizedData.getBytes()));
        if (LOG.isDebugEnabled()) {
            LOG.debug("File format of " + this.getType() + " private key is: " + privKeySpec.getFormat());
        }
        PrivateKey privateKey = KeyFactory.getInstance(this.getType()).generatePrivate(privKeySpec);
        if (LOG.isDebugEnabled()) {
            LOG.debug("File format of " + this.getType() + " private key is: " + privateKey.getFormat());
        }
        return privateKey;
    }

    @Override
    public PrivateKey getPrivateKey(File file) throws IOException, GeneralSecurityException {
        if (file == null) {
            return null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loading " + this.getType() + " private key form file '" + file + "'...");
        }
        return this.getPrivateKey(FileUtil.getInstance().readFileContent(file));
    }

    @Override
    public String formatPrivateKey(PrivateKey privateKey) {
        if (privateKey == null) {
            return null;
        }
        return this.formatPKCS8(new String(Base64.getEncoder().encode(privateKey.getEncoded())));
    }
}

