/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.security.pki.impl;

import com.github.toolarium.common.ByteArray;
import com.github.toolarium.security.pki.impl.AbstractKeyConverter;
import com.github.toolarium.security.pki.util.PKIUtil;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;

public class DSAKeyConverter
extends AbstractKeyConverter {
    public static final String PUBLIC_DSA_KEY_START = "-----BEGIN DSA PUBLIC KEY-----";
    public static final String PUBLIC_DSA_KEY_END = "-----END DSA PUBLIC KEY-----";
    public static final String PRIVATE_DSA_KEY_START = "-----BEGIN DSA PRIVATE KEY-----";
    public static final String PRIVATE_DSA_KEY_END = "-----END DSA PRIVATE KEY-----";

    public DSAKeyConverter() {
        this(null);
    }

    public DSAKeyConverter(String provider) {
        super(provider, "DSA", 2048);
    }

    @Override
    public PublicKey getPublicKey(byte[] content) throws IOException, GeneralSecurityException {
        if (content == null || content.length == 0) {
            return null;
        }
        ByteArray t = new ByteArray(content).replace(new ByteArray(PUBLIC_DSA_KEY_START), new ByteArray());
        t = t.replace(new ByteArray(PUBLIC_DSA_KEY_END), new ByteArray());
        t = t.replace(new ByteArray("\r"), new ByteArray());
        t = t.replace(new ByteArray("\n"), new ByteArray());
        X509EncodedKeySpec spec = new X509EncodedKeySpec(Base64.getDecoder().decode(t.toBytes()));
        KeyFactory kf = KeyFactory.getInstance(this.getType());
        return kf.generatePublic(spec);
    }

    @Override
    public String formatPublicKey(PublicKey publicKey) {
        if (publicKey == null) {
            return null;
        }
        return PKIUtil.getInstance().formatBuffer(new ByteArray(Base64.getEncoder().encode(publicKey.getEncoded())), 64, PUBLIC_DSA_KEY_START, PUBLIC_DSA_KEY_END).toString();
    }

    @Override
    public String formatPKCS8(String content) {
        return PKIUtil.getInstance().formatBuffer(content, 64, PRIVATE_DSA_KEY_START, PRIVATE_DSA_KEY_END);
    }

    @Override
    public String normalizePKCS8(String content) {
        return PKIUtil.getInstance().normalizeBuffer(content, PRIVATE_DSA_KEY_START, PRIVATE_DSA_KEY_END);
    }
}

