/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.security.pki.impl;

import com.github.toolarium.common.ByteArray;
import com.github.toolarium.security.pki.impl.AbstractKeyConverter;
import com.github.toolarium.security.pki.impl.rsa.RSAPrivateKeyPKCS8;
import com.github.toolarium.security.pki.util.PKIUtil;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSAKeyConverter
extends AbstractKeyConverter {
    public static final String PUBLIC_RSA_KEY_START = "-----BEGIN RSA PUBLIC KEY-----";
    public static final String PUBLIC_RSA_KEY_END = "-----END RSA PUBLIC KEY-----";
    public static final String PUBLIC_DSA_KEY_END = "-----END DSA PUBLIC KEY-----";
    public static final String PRIVATE_RSA_KEY_START = "-----BEGIN RSA PRIVATE KEY-----";
    public static final String PRIVATE_RSA_KEY_END = "-----END RSA PRIVATE KEY-----";
    private static final Logger LOG = LoggerFactory.getLogger(RSAKeyConverter.class);

    public RSAKeyConverter() {
        this(null);
    }

    public RSAKeyConverter(String provider) {
        super(provider, "RSA", 2048);
    }

    @Override
    public PublicKey getPublicKey(byte[] content) throws IOException, GeneralSecurityException {
        if (content == null || content.length == 0) {
            return null;
        }
        ByteArray t = new ByteArray(content).replace(new ByteArray(PUBLIC_RSA_KEY_START), new ByteArray());
        t = t.replace(new ByteArray(PUBLIC_RSA_KEY_END), new ByteArray());
        t = t.replace(new ByteArray("\r"), new ByteArray());
        t = t.replace(new ByteArray("\n"), new ByteArray());
        X509EncodedKeySpec spec = new X509EncodedKeySpec(Base64.getDecoder().decode(t.toBytes()));
        KeyFactory kf = KeyFactory.getInstance(this.getType());
        return kf.generatePublic(spec);
    }

    @Override
    public PrivateKey getPrivateKey(String content) throws GeneralSecurityException {
        if (content == null || content.length() == 0) {
            return null;
        }
        String normalizedData = this.normalizePKCS8(content);
        RSAPrivateKeyPKCS8 privateKey = null;
        try {
            return super.getPrivateKey(normalizedData);
        }
        catch (InvalidKeySpecException e) {
            RSAPrivateKeyPKCS8 privKeySpec = new RSAPrivateKeyPKCS8(Base64.getDecoder().decode(normalizedData.getBytes()));
            privKeySpec.checkEncoding();
            privateKey = privKeySpec;
            if (LOG.isDebugEnabled()) {
                LOG.debug("File format of " + this.getType() + " private key is: " + privateKey.getFormat());
            }
            return privateKey;
        }
    }

    @Override
    public String formatPublicKey(PublicKey publicKey) {
        return PKIUtil.getInstance().formatBuffer(new ByteArray(Base64.getEncoder().encode(publicKey.getEncoded())), 64, PUBLIC_RSA_KEY_START, PUBLIC_RSA_KEY_END).toString();
    }

    @Override
    public String formatPKCS8(String content) {
        return PKIUtil.getInstance().formatBuffer(content, 64, PRIVATE_RSA_KEY_START, PRIVATE_RSA_KEY_END);
    }

    @Override
    public String normalizePKCS8(String content) {
        return PKIUtil.getInstance().normalizeBuffer(content, PRIVATE_RSA_KEY_START, PRIVATE_RSA_KEY_END);
    }
}

