/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.security.pki.impl.rsa;

import com.github.toolarium.security.pki.impl.rsa.der.DERInputStream;
import com.github.toolarium.security.pki.impl.rsa.der.DEROutputStream;
import com.github.toolarium.security.pki.impl.rsa.der.DERValue;
import com.github.toolarium.security.pki.impl.rsa.der.ObjectIdentifier;
import java.io.IOException;
import java.math.BigInteger;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSAPrivateKeyPKCS8
implements RSAPrivateKey {
    private static final long serialVersionUID = 3617009758595528501L;
    private static final Logger LOG = LoggerFactory.getLogger(RSAPrivateKeyPKCS8.class);
    private RSAPrivateCrtKeySpec keyspec;
    private byte[] encoded;

    public RSAPrivateKeyPKCS8(byte[] encoded) {
        this.encoded = encoded;
        this.keyspec = null;
    }

    public RSAPrivateKeyPKCS8(RSAPrivateCrtKeySpec keyspec) {
        this.keyspec = keyspec;
        this.encoded = null;
    }

    @Override
    public String getAlgorithm() {
        return "RSA";
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    public void checkEncoding() throws InvalidKeySpecException {
        this.getEncoded();
        try {
            DERInputStream dis = new DERInputStream(this.encoded);
            DERValue[] derseq = dis.getSequence(3);
            if (!BigInteger.ZERO.equals(derseq[0].getInteger().toBigInteger())) {
                throw new InvalidKeySpecException("Bad DER sequence");
            }
        }
        catch (IOException e) {
            throw new InvalidKeySpecException(e.getMessage());
        }
    }

    @Override
    public byte[] getEncoded() {
        if (this.encoded != null) {
            return this.encoded;
        }
        try {
            DERValue[] pkcs8 = new DERValue[]{RSAPrivateKeyPKCS8.getTwoByteDerValue(new BigInteger("0")), RSAPrivateKeyPKCS8.init(), RSAPrivateKeyPKCS8.convert(this.keyspec)};
            DEROutputStream dos = new DEROutputStream();
            dos.putSequence(pkcs8);
            this.encoded = dos.toByteArray();
            dos.close();
        }
        catch (Exception ex) {
            LOG.warn("Could not encode RSA private key!", ex);
        }
        return this.encoded;
    }

    public RSAPrivateKeySpec getKeySpec() {
        if (this.keyspec == null) {
            this.getEncoded();
        }
        return this.keyspec;
    }

    @Override
    public BigInteger getPrivateExponent() {
        if (this.keyspec == null) {
            return null;
        }
        return this.getKeySpec().getPrivateExponent();
    }

    @Override
    public BigInteger getModulus() {
        if (this.keyspec == null) {
            return null;
        }
        return this.getKeySpec().getModulus();
    }

    private static DERValue getDERValue(byte[] a) {
        return new DERValue(4, a);
    }

    private static DERValue convert(RSAPrivateCrtKeySpec keyspec) throws IOException {
        keyspec.getModulus();
        keyspec.getPublicExponent();
        keyspec.getPrivateExponent();
        keyspec.getPrimeP();
        keyspec.getPrimeQ();
        keyspec.getPrimeExponentP();
        keyspec.getPrimeExponentQ();
        keyspec.getCrtCoefficient();
        DERValue[] rsastuff = new DERValue[]{RSAPrivateKeyPKCS8.getTwoByteDerValue(new BigInteger("0")), RSAPrivateKeyPKCS8.getTwoByteDerValue(keyspec.getModulus()), RSAPrivateKeyPKCS8.getTwoByteDerValue(keyspec.getPublicExponent()), RSAPrivateKeyPKCS8.getTwoByteDerValue(keyspec.getPrivateExponent()), RSAPrivateKeyPKCS8.getTwoByteDerValue(keyspec.getPrimeP()), RSAPrivateKeyPKCS8.getTwoByteDerValue(keyspec.getPrimeQ()), RSAPrivateKeyPKCS8.getTwoByteDerValue(keyspec.getPrimeExponentP()), RSAPrivateKeyPKCS8.getTwoByteDerValue(keyspec.getPrimeExponentQ()), RSAPrivateKeyPKCS8.getTwoByteDerValue(keyspec.getCrtCoefficient())};
        DERValue sequence = RSAPrivateKeyPKCS8.parse(rsastuff);
        return RSAPrivateKeyPKCS8.getDERValue(sequence.toByteArray());
    }

    private static DERValue init() throws IOException {
        DERValue[] a = new DERValue[]{RSAPrivateKeyPKCS8.parse("1.2.840.113549.1.1.1"), new DERValue(5, new byte[0])};
        return RSAPrivateKeyPKCS8.parse(a);
    }

    private static DERValue parse(DERValue[] a) throws IOException {
        DEROutputStream dos = new DEROutputStream();
        dos.putSequence(a);
        DERInputStream dis = new DERInputStream(dos.toByteArray());
        dos.close();
        return dis.getDERValue();
    }

    private static DERValue parse(String id) throws IOException {
        ObjectIdentifier oid = new ObjectIdentifier(id);
        DEROutputStream dos = new DEROutputStream();
        dos.putOID(oid);
        DERInputStream dis = new DERInputStream(dos.toByteArray());
        dos.close();
        return dis.getDERValue();
    }

    private static DERValue getTwoByteDerValue(BigInteger bi) {
        return new DERValue(2, bi.toByteArray());
    }
}

