/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.security.pki.impl.rsa.data;

import java.math.BigInteger;

public class BigInt {
    private static final String digits = "0123456789abcdef";
    private byte[] places;

    public BigInt(byte[] data) {
        this.places = (byte[])data.clone();
    }

    public BigInt(BigInteger i) throws IllegalArgumentException {
        byte[] temp = i.toByteArray();
        if ((temp[0] & 0x80) != 0) {
            throw new IllegalArgumentException("negative BigInteger");
        }
        if (temp[0] != 0) {
            this.places = temp;
        } else {
            this.places = new byte[temp.length - 1];
            for (int j = 1; j < temp.length; ++j) {
                this.places[j - 1] = temp[j];
            }
        }
    }

    public BigInt(int i) {
        if (i < 256) {
            this.places = new byte[1];
            this.places[0] = (byte)i;
        } else if (i < 65536) {
            this.places = new byte[2];
            this.places[0] = (byte)(i >> 8);
            this.places[1] = (byte)i;
        } else if (i < 0x1000000) {
            this.places = new byte[3];
            this.places[0] = (byte)(i >> 16);
            this.places[1] = (byte)(i >> 8);
            this.places[2] = (byte)i;
        } else {
            this.places = new byte[4];
            this.places[0] = (byte)(i >> 24);
            this.places[1] = (byte)(i >> 16);
            this.places[2] = (byte)(i >> 8);
            this.places[3] = (byte)i;
        }
    }

    public int toInt() {
        if (this.places.length > 4) {
            throw new NumberFormatException("BigInt.toLong, too big");
        }
        int retval = 0;
        for (int i = 0; i < this.places.length; ++i) {
            retval = (retval << 8) + (this.places[i] & 0xFF);
        }
        return retval;
    }

    public String toString() {
        return this.hexify();
    }

    public BigInteger toBigInteger() {
        return new BigInteger(1, this.places);
    }

    public byte[] toByteArray() {
        return (byte[])this.places.clone();
    }

    public boolean equals(Object other) {
        if (other instanceof BigInt) {
            return this.equals((BigInt)other);
        }
        return false;
    }

    public boolean equals(BigInt other) {
        if (this == other) {
            return true;
        }
        byte[] otherPlaces = other.toByteArray();
        if (this.places.length != otherPlaces.length) {
            return false;
        }
        for (int i = 0; i < this.places.length; ++i) {
            if (this.places[i] == otherPlaces[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.hexify().hashCode();
    }

    private String hexify() {
        if (this.places.length == 0) {
            return "  0  ";
        }
        StringBuilder buf = new StringBuilder(this.places.length * 2);
        buf.append("    ");
        for (int i = 0; i < this.places.length; ++i) {
            buf.append(digits.charAt(this.places[i] >> 4 & 0xF));
            buf.append(digits.charAt(this.places[i] & 0xF));
            if ((i + 1) % 32 == 0) {
                if (i + 1 == this.places.length) continue;
                buf.append("\n    ");
                continue;
            }
            if ((i + 1) % 4 != 0) continue;
            buf.append(' ');
        }
        return buf.toString();
    }
}

