/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.security.pki.impl.rsa.der;

import com.github.toolarium.security.pki.impl.rsa.data.BigInt;
import com.github.toolarium.security.pki.impl.rsa.data.BitArray;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class DERInputBuffer
extends ByteArrayInputStream
implements Cloneable {
    public DERInputBuffer(byte[] buf) {
        super(buf);
    }

    DERInputBuffer(byte[] buf, int offset, int len) {
        super(buf, offset, len);
    }

    public DERInputBuffer dup() throws IllegalArgumentException {
        try {
            DERInputBuffer retval = (DERInputBuffer)this.clone();
            retval.mark(Integer.MAX_VALUE);
            return retval;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    byte[] toByteArray() {
        int len = this.available();
        if (len <= 0) {
            return null;
        }
        byte[] retval = new byte[len];
        System.arraycopy(this.buf, this.pos, retval, 0, len);
        return retval;
    }

    int peek() throws IOException {
        if (this.pos >= this.count) {
            throw new IOException("out of data");
        }
        return this.buf[this.pos];
    }

    public boolean equals(Object other) {
        if (other instanceof DERInputBuffer) {
            return this.equals((DERInputBuffer)other);
        }
        return false;
    }

    boolean equals(DERInputBuffer other) {
        if (this == other) {
            return true;
        }
        int max = this.available();
        if (other.available() != max) {
            return false;
        }
        for (int i = 0; i < max; ++i) {
            if (this.buf[this.pos + i] == other.buf[other.pos + i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int retval = 0;
        int len = this.available();
        int p = this.pos;
        for (int i = 0; i < len; ++i) {
            retval += this.buf[p + i] * i;
        }
        return retval;
    }

    public void truncate(int len) throws IOException {
        if (len > this.available()) {
            throw new IOException("insufficient data");
        }
        this.count = this.pos + len;
    }

    public BigInt getUnsigned(int l) throws IOException {
        int len = l;
        if (len > this.available()) {
            throw new IOException("short read of integer/enumerated");
        }
        if (this.buf[this.pos] == 0) {
            --len;
            this.skip(1L);
        }
        byte[] bytes = new byte[len];
        System.arraycopy(this.buf, this.pos, bytes, 0, len);
        this.skip(len);
        return new BigInt(bytes);
    }

    public byte[] getBitString() {
        if (this.pos >= this.count || this.buf[this.pos] != 0) {
            return null;
        }
        int len = this.available();
        byte[] retval = new byte[len - 1];
        System.arraycopy(this.buf, this.pos + 1, retval, 0, len - 1);
        this.pos = this.count;
        return retval;
    }

    public BitArray getUnalignedBitString() {
        if (this.pos >= this.count) {
            return null;
        }
        int len = this.available();
        byte[] bits = new byte[len - 1];
        int length = bits.length * 8 - this.buf[this.pos];
        System.arraycopy(this.buf, this.pos + 1, bits, 0, len - 1);
        BitArray bitArray = new BitArray(length, bits);
        this.pos = this.count;
        return bitArray;
    }
}

