/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.security.pki.impl.rsa.der;

import com.github.toolarium.security.pki.impl.rsa.data.BigInt;
import com.github.toolarium.security.pki.impl.rsa.data.BitArray;
import com.github.toolarium.security.pki.impl.rsa.der.DERIndefLenConverter;
import com.github.toolarium.security.pki.impl.rsa.der.DERInputBuffer;
import com.github.toolarium.security.pki.impl.rsa.der.DERValue;
import com.github.toolarium.security.pki.impl.rsa.der.ObjectIdentifier;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;

public class DERInputStream {
    private DERInputBuffer buffer;

    public DERInputStream(byte[] data) {
        this.init(data, 0, data.length);
    }

    public DERInputStream(byte[] data, int offset, int len) {
        this.init(data, offset, len);
    }

    public DERInputStream(DERInputBuffer buf) {
        this.buffer = buf;
        this.buffer.mark(Integer.MAX_VALUE);
    }

    public DERInputStream subStream(int len, boolean doSkip) throws IOException {
        DERInputBuffer newbuf = this.buffer.dup();
        newbuf.truncate(len);
        if (doSkip) {
            this.buffer.skip(len);
        }
        return new DERInputStream(newbuf);
    }

    public byte[] toByteArray() {
        return this.buffer.toByteArray();
    }

    public BigInt getInteger() throws IOException {
        if (this.buffer.read() != 2) {
            throw new IOException("DER input, Integer tag error");
        }
        return this.buffer.getUnsigned(DERInputStream.getLength(this.buffer));
    }

    public BigInt getEnumerated() throws IOException {
        if (this.buffer.read() != 10) {
            throw new IOException("DER input, Enumerated tag error");
        }
        return this.buffer.getUnsigned(DERInputStream.getLength(this.buffer));
    }

    public byte[] getBitString() throws IOException {
        byte[] retval;
        if (this.buffer.read() != 3) {
            throw new IOException("DER input not an bit string");
        }
        int length = DERInputStream.getLength(this.buffer);
        if (this.buffer.read() != 0) {
            throw new IOException("unaligned bit string");
        }
        if (this.buffer.read(retval = new byte[--length]) != length) {
            throw new IOException("short read of DER bit string");
        }
        return retval;
    }

    public BitArray getUnalignedBitString() throws IOException {
        if (this.buffer.read() != 3) {
            throw new IOException("DER input not a bit string");
        }
        int length = DERInputStream.getLength(this.buffer) - 1;
        int validBits = length * 8 - this.buffer.read();
        byte[] repn = new byte[length];
        if (this.buffer.read(repn) != length) {
            throw new IOException("short read of DER bit string");
        }
        return new BitArray(validBits, repn);
    }

    public byte[] getOctetString() throws IOException {
        if (this.buffer.read() != 4) {
            throw new IOException("DER input not an octet string");
        }
        int length = DERInputStream.getLength(this.buffer);
        byte[] retval = new byte[length];
        if (this.buffer.read(retval) != length) {
            throw new IOException("short read of DER octet string");
        }
        return retval;
    }

    public void getBytes(byte[] val) throws IOException {
        if (this.buffer.read(val) != val.length) {
            throw new IOException("short read of DER octet string");
        }
    }

    public void getNull() throws IOException {
        if (this.buffer.read() != 5 || this.buffer.read() != 0) {
            throw new IOException("getNull, bad data");
        }
    }

    public ObjectIdentifier getOID() throws IOException {
        return new ObjectIdentifier(this);
    }

    public DERValue[] getSequence(int startLen) throws IOException {
        if (this.buffer.read() != 48) {
            throw new IOException("Sequence tag error");
        }
        return this.readVector(startLen);
    }

    public DERValue[] getSet(int startLen) throws IOException {
        if (this.buffer.read() != 49) {
            throw new IOException("Set tag error");
        }
        return this.readVector(startLen);
    }

    public DERValue[] getSet(int startLen, boolean implicit) throws IOException {
        int tag = this.buffer.read();
        if (!implicit && tag != 49) {
            throw new IOException("Set tag error");
        }
        return this.readVector(startLen);
    }

    protected DERValue[] readVector(int startLen) throws IOException {
        int len = DERInputStream.getLength(this.buffer);
        if (len == 0) {
            return new DERValue[0];
        }
        DERInputStream newstr = this.buffer.available() == len ? this : this.subStream(len, true);
        Vector<DERValue> vec = new Vector<DERValue>(startLen, 5);
        do {
            DERValue value = new DERValue(newstr.buffer);
            vec.addElement(value);
        } while (newstr.available() > 0);
        if (newstr.available() != 0) {
            throw new IOException("extra data at end of vector");
        }
        int max = vec.size();
        DERValue[] retval = new DERValue[max];
        for (int i = 0; i < max; ++i) {
            retval[i] = (DERValue)vec.elementAt(i);
        }
        return retval;
    }

    public DERValue getDERValue() throws IOException {
        return new DERValue(this.buffer);
    }

    public String getUTF8String() throws IOException {
        return this.readString((byte)18, "UTF-8", "UTF8");
    }

    public String getPrintableString() throws IOException {
        return this.readString((byte)19, "Printable", "ASCII");
    }

    public String getT61String() throws IOException {
        return this.readString((byte)20, "T61", "ASCII");
    }

    public String getIA5String() throws IOException {
        return this.readString((byte)22, "IA5", "ASCII");
    }

    public String getBMPString() throws IOException {
        return this.readString((byte)30, "BMP", "UnicodeBigUnmarked");
    }

    public Date getUTCTime() throws IOException {
        int second;
        if (this.buffer.read() != 23) {
            throw new IOException("DER input, UTCtime tag invalid ");
        }
        if (this.buffer.available() < 11) {
            throw new IOException("DER input, UTCtime short input");
        }
        int len = DERInputStream.getLength(this.buffer);
        if (len < 11 || len > 17) {
            throw new IOException("DER getUTCTime length error");
        }
        int year = 10 * Character.digit((char)this.buffer.read(), 10);
        year = (year += Character.digit((char)this.buffer.read(), 10)) <= 50 ? (year += 2000) : (year += 1900);
        int month = 10 * Character.digit((char)this.buffer.read(), 10);
        month += Character.digit((char)this.buffer.read(), 10);
        --month;
        int day = 10 * Character.digit((char)this.buffer.read(), 10);
        day += Character.digit((char)this.buffer.read(), 10);
        int hour = 10 * Character.digit((char)this.buffer.read(), 10);
        hour += Character.digit((char)this.buffer.read(), 10);
        int minute = 10 * Character.digit((char)this.buffer.read(), 10);
        minute += Character.digit((char)this.buffer.read(), 10);
        if ((len -= 10) == 3 || len == 7) {
            second = 10 * Character.digit((char)this.buffer.read(), 10);
            second += Character.digit((char)this.buffer.read(), 10);
            len -= 2;
        } else {
            second = 0;
        }
        if (month < 0 || day <= 0 || month > 11 || day > 31 || hour >= 24 || minute >= 60 || second >= 60) {
            throw new IOException("Parse UTC time, invalid format");
        }
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.set(year, month, day, hour, minute, second);
        cal.set(0, 1);
        Date readDate = cal.getTime();
        long utcTime = readDate.getTime() / 1000L * 1000L;
        if (len != 1 && len != 5) {
            throw new IOException("Parse UTC time, invalid offset");
        }
        switch (this.buffer.read()) {
            case 43: {
                int htmp = 10 * Character.digit((char)this.buffer.read(), 10);
                int mtmp = 10 * Character.digit((char)this.buffer.read(), 10);
                if ((htmp += Character.digit((char)this.buffer.read(), 10)) >= 24 || (mtmp += Character.digit((char)this.buffer.read(), 10)) >= 60) {
                    throw new IOException("Parse UTCtime, +hhmm");
                }
                utcTime += (long)((htmp * 60 + mtmp) * 60 * 1000);
                break;
            }
            case 45: {
                int htmp = 10 * Character.digit((char)this.buffer.read(), 10);
                int mtmp = 10 * Character.digit((char)this.buffer.read(), 10);
                if ((htmp += Character.digit((char)this.buffer.read(), 10)) >= 24 || (mtmp += Character.digit((char)this.buffer.read(), 10)) >= 60) {
                    throw new IOException("Parse UTCtime, -hhmm");
                }
                utcTime -= (long)((htmp * 60 + mtmp) * 60 * 1000);
                break;
            }
            case 90: {
                break;
            }
            default: {
                throw new IOException("Parse UTCtime, garbage offset");
            }
        }
        readDate.setTime(utcTime);
        return readDate;
    }

    public Date getGeneralizedTime() throws IOException {
        int second;
        if (this.buffer.read() != 24) {
            throw new IOException("DER input, GeneralizedTime tag invalid ");
        }
        if (this.buffer.available() < 13) {
            throw new IOException("DER input, GeneralizedTime short input");
        }
        int len = DERInputStream.getLength(this.buffer);
        int year = 1000 * Character.digit((char)this.buffer.read(), 10);
        year += 100 * Character.digit((char)this.buffer.read(), 10);
        year += 10 * Character.digit((char)this.buffer.read(), 10);
        year += Character.digit((char)this.buffer.read(), 10);
        int month = 10 * Character.digit((char)this.buffer.read(), 10);
        month += Character.digit((char)this.buffer.read(), 10);
        --month;
        int day = 10 * Character.digit((char)this.buffer.read(), 10);
        day += Character.digit((char)this.buffer.read(), 10);
        int hour = 10 * Character.digit((char)this.buffer.read(), 10);
        hour += Character.digit((char)this.buffer.read(), 10);
        int minute = 10 * Character.digit((char)this.buffer.read(), 10);
        minute += Character.digit((char)this.buffer.read(), 10);
        if ((len -= 12) == 3 || len == 7) {
            second = 10 * Character.digit((char)this.buffer.read(), 10);
            second += Character.digit((char)this.buffer.read(), 10);
            len -= 2;
        } else {
            second = 0;
        }
        if (month < 0 || day <= 0 || month > 11 || day > 31 || hour >= 24 || minute >= 60 || second >= 60) {
            throw new IOException("Parse Generalized time, invalid format");
        }
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.set(year, month, day, hour, minute, second);
        cal.set(0, 1);
        Date readDate = cal.getTime();
        long utcTime = readDate.getTime();
        if (len != 1 && len != 5) {
            throw new IOException("Parse Generalized time, invalid offset");
        }
        switch (this.buffer.read()) {
            case 43: {
                int htmp = 10 * Character.digit((char)this.buffer.read(), 10);
                int mtmp = 10 * Character.digit((char)this.buffer.read(), 10);
                if ((htmp += Character.digit((char)this.buffer.read(), 10)) >= 24 || (mtmp += Character.digit((char)this.buffer.read(), 10)) >= 60) {
                    throw new IOException("Parse GeneralizedTime, +hhmm");
                }
                utcTime += (long)((htmp * 60 + mtmp) * 60 * 1000);
                break;
            }
            case 45: {
                int htmp = 10 * Character.digit((char)this.buffer.read(), 10);
                int mtmp = 10 * Character.digit((char)this.buffer.read(), 10);
                if ((htmp += Character.digit((char)this.buffer.read(), 10)) >= 24 || (mtmp += Character.digit((char)this.buffer.read(), 10)) >= 60) {
                    throw new IOException("Parse GeneralizedTime, -hhmm");
                }
                utcTime -= (long)((htmp * 60 + mtmp) * 60 * 1000);
                break;
            }
            case 90: {
                break;
            }
            default: {
                throw new IOException("Parse GeneralizedTime, garbage offset");
            }
        }
        readDate.setTime(utcTime);
        return readDate;
    }

    public void mark(int value) {
        this.buffer.mark(value);
    }

    public void reset() {
        this.buffer.reset();
    }

    public int available() {
        return this.buffer.available();
    }

    public int peekByte() throws IOException {
        return this.buffer.peek();
    }

    private void init(byte[] data, int offset, int len) {
        if (DERIndefLenConverter.isIndefinite(data[offset + 1])) {
            try {
                byte[] inData = new byte[len];
                System.arraycopy(data, offset, inData, 0, len);
                DERIndefLenConverter derIn = new DERIndefLenConverter();
                this.buffer = new DERInputBuffer(derIn.convert(inData));
            }
            catch (IOException iOException) {}
        } else {
            this.buffer = new DERInputBuffer(data, offset, len);
        }
        this.buffer.mark(Integer.MAX_VALUE);
    }

    private String readString(byte stringTag, String stringName, String enc) throws IOException {
        if (this.buffer.read() != stringTag) {
            throw new IOException("DER input not a " + stringName + " string");
        }
        int length = DERInputStream.getLength(this.buffer);
        byte[] retval = new byte[length];
        if (this.buffer.read(retval) != length) {
            throw new IOException("short read of DER " + stringName + " string");
        }
        return new String(retval, enc);
    }

    public int getByte() {
        return 0xFF & this.buffer.read();
    }

    public int getLength() throws IOException {
        return DERInputStream.getLength(this.buffer);
    }

    public static int getLength(InputStream in) throws IOException {
        return DERInputStream.getLength(in.read(), in);
    }

    public static int getLength(int lenByte, InputStream in) throws IOException {
        int value;
        int tmp = lenByte;
        if ((tmp & 0x80) == 0) {
            value = tmp;
        } else {
            if ((tmp &= 0x7F) == 0) {
                return -1;
            }
            if (tmp < 0 || tmp > 4) {
                String detail = "too big.";
                if (tmp < 0) {
                    detail = "incorrect DER encoding.";
                }
                throw new IOException("DERInputStream.getLength(): lengthTag=" + tmp + ", " + detail);
            }
            value = 0;
            while (tmp > 0) {
                value <<= 8;
                value += 0xFF & in.read();
                --tmp;
            }
        }
        return value;
    }
}

