/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.security.pki.impl.rsa.der;

import com.github.toolarium.security.pki.impl.rsa.comporator.ByteArrayLexOrder;
import com.github.toolarium.security.pki.impl.rsa.comporator.ByteArrayTagOrder;
import com.github.toolarium.security.pki.impl.rsa.data.BigInt;
import com.github.toolarium.security.pki.impl.rsa.data.BitArray;
import com.github.toolarium.security.pki.impl.rsa.der.DEREncoder;
import com.github.toolarium.security.pki.impl.rsa.der.DERValue;
import com.github.toolarium.security.pki.impl.rsa.der.ObjectIdentifier;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.TimeZone;

public class DEROutputStream
extends ByteArrayOutputStream
implements DEREncoder {
    private static ByteArrayLexOrder lexOrder = new ByteArrayLexOrder();
    private static ByteArrayTagOrder tagOrder = new ByteArrayTagOrder();

    public DEROutputStream(int size) {
        super(size);
    }

    public DEROutputStream() {
    }

    public void write(byte tag, byte[] b) {
        this.write(tag);
        this.putLength(b.length);
        this.write(b, 0, b.length);
    }

    public void write(byte tag, DEROutputStream out) {
        this.write(tag);
        this.putLength(out.count);
        this.write(out.buf, 0, out.count);
    }

    public void writeImplicit(byte tag, DEROutputStream value) {
        this.write(tag);
        this.write(value.buf, 1, value.count - 1);
    }

    public void putDERValue(DERValue val) throws IOException {
        val.encode(this);
    }

    public void putBoolean(boolean val) {
        this.write(1);
        this.putLength(1);
        if (val) {
            this.write(255);
        } else {
            this.write(0);
        }
    }

    public void putInteger(BigInt i) {
        this.write(2);
        this.putBigInt(i);
    }

    public void putEnumerated(BigInt i) {
        this.write(10);
        this.putBigInt(i);
    }

    private void putBigInt(BigInt i) {
        byte[] b = i.toByteArray();
        if ((b[0] & 0x80) != 0) {
            this.putLength(b.length + 1);
            this.write(0);
        } else {
            this.putLength(b.length);
        }
        this.write(b, 0, b.length);
    }

    public void putBitString(byte[] bits) throws IOException {
        this.write(3);
        this.putLength(bits.length + 1);
        this.write(0);
        this.write(bits);
    }

    public void putUnalignedBitString(BitArray b) throws IOException {
        byte[] bits = b.toByteArray();
        this.write(3);
        this.putLength(bits.length + 1);
        this.write(bits.length * 8 - b.length());
        this.write(bits);
    }

    public void putOctetString(byte[] octets) {
        this.write((byte)4, octets);
    }

    public void putNull() {
        this.write(5);
        this.putLength(0);
    }

    public void putOID(ObjectIdentifier oid) {
        oid.encode(this);
    }

    public void putSequence(DERValue[] seq) throws IOException {
        DEROutputStream bytes = new DEROutputStream();
        for (int i = 0; i < seq.length; ++i) {
            seq[i].encode(bytes);
        }
        this.write((byte)48, bytes);
    }

    public void putSet(DERValue[] set) throws IOException {
        DEROutputStream bytes = new DEROutputStream();
        for (int i = 0; i < set.length; ++i) {
            set[i].encode(bytes);
        }
        this.write((byte)49, bytes);
    }

    public void putOrderedSetOf(byte tag, DEREncoder[] set) throws IOException {
        this.putOrderedSet(tag, set, lexOrder);
    }

    public void putOrderedSet(byte tag, DEREncoder[] set) throws IOException {
        this.putOrderedSet(tag, set, tagOrder);
    }

    private void putOrderedSet(byte tag, DEREncoder[] set, Comparator<byte[]> order) throws IOException {
        DEROutputStream[] streams = new DEROutputStream[set.length];
        for (int i = 0; i < set.length; ++i) {
            streams[i] = new DEROutputStream();
            set[i].derEncode(streams[i]);
        }
        byte[][] bufs = new byte[streams.length][];
        for (int i = 0; i < streams.length; ++i) {
            bufs[i] = streams[i].toByteArray();
        }
        Arrays.sort(bufs, order);
        DEROutputStream bytes = new DEROutputStream();
        for (int i = 0; i < streams.length; ++i) {
            bytes.write(bufs[i]);
        }
        this.write(tag, bytes);
    }

    public void putUTF8String(String s) throws IOException {
        this.writeString(s, (byte)18, "UTF8");
    }

    public void putPrintableString(String s) throws IOException {
        this.writeString(s, (byte)19, "ASCII");
    }

    public void putT61String(String s) throws IOException {
        this.writeString(s, (byte)20, "ASCII");
    }

    public void putIA5String(String s) throws IOException {
        this.writeString(s, (byte)22, "ASCII");
    }

    public void putBMPString(String s) throws IOException {
        this.writeString(s, (byte)30, "UnicodeBigUnmarked");
    }

    private void writeString(String s, byte stringTag, String enc) throws IOException {
        byte[] data = s.getBytes(enc);
        this.write(stringTag);
        this.putLength(data.length);
        this.write(data);
    }

    public void putUTCTime(Date d) throws IOException {
        TimeZone tz = TimeZone.getTimeZone("GMT");
        String pattern = "yyMMddHHmmss'Z'";
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        sdf.setTimeZone(tz);
        byte[] utc = sdf.format(d).getBytes();
        this.write(23);
        this.putLength(utc.length);
        this.write(utc);
    }

    public void putGeneralizedTime(Date d) throws IOException {
        TimeZone tz = TimeZone.getTimeZone("GMT");
        String pattern = "yyyyMMddHHmmss'Z'";
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        sdf.setTimeZone(tz);
        byte[] gt = sdf.format(d).getBytes();
        this.write(24);
        this.putLength(gt.length);
        this.write(gt);
    }

    public void putLength(int len) {
        if (len < 128) {
            this.write((byte)len);
        } else if (len < 256) {
            this.write(-127);
            this.write((byte)len);
        } else if (len < 65536) {
            this.write(-126);
            this.write((byte)(len >> 8));
            this.write((byte)len);
        } else if (len < 0x1000000) {
            this.write(-125);
            this.write((byte)(len >> 16));
            this.write((byte)(len >> 8));
            this.write((byte)len);
        } else {
            this.write(-124);
            this.write((byte)(len >> 24));
            this.write((byte)(len >> 16));
            this.write((byte)(len >> 8));
            this.write((byte)len);
        }
    }

    public void putTag(byte tagClass, boolean form, byte val) {
        byte tag = (byte)(tagClass | val);
        if (form) {
            tag = (byte)(tag | 0x20);
        }
        this.write(tag);
    }

    @Override
    public void derEncode(OutputStream out) throws IOException {
        out.write(this.toByteArray());
    }
}

