/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.security.pki.impl.rsa.der;

import com.github.toolarium.security.pki.impl.rsa.data.BigInt;
import com.github.toolarium.security.pki.impl.rsa.data.BitArray;
import com.github.toolarium.security.pki.impl.rsa.der.DERIndefLenConverter;
import com.github.toolarium.security.pki.impl.rsa.der.DERInputBuffer;
import com.github.toolarium.security.pki.impl.rsa.der.DERInputStream;
import com.github.toolarium.security.pki.impl.rsa.der.DEROutputStream;
import com.github.toolarium.security.pki.impl.rsa.der.ObjectIdentifier;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class DERValue {
    public static final byte tag_Boolean = 1;
    public static final byte tag_Integer = 2;
    public static final byte tag_BitString = 3;
    public static final byte tag_OctetString = 4;
    public static final byte tag_Null = 5;
    public static final byte tag_ObjectId = 6;
    public static final byte tag_Enumerated = 10;
    public static final byte tag_UTF8String = 18;
    public static final byte tag_PrintableString = 19;
    public static final byte tag_T61String = 20;
    public static final byte tag_IA5String = 22;
    public static final byte tag_UtcTime = 23;
    public static final byte tag_GeneralizedTime = 24;
    public static final byte tag_UniversalString = 28;
    public static final byte tag_BMPString = 30;
    public static final byte tag_Sequence = 48;
    public static final byte tag_SequenceOf = 48;
    public static final byte tag_Set = 49;
    public static final byte tag_SetOf = 49;
    public static final byte TAG_UNIVERSAL = 0;
    public static final byte TAG_APPLICATION = 64;
    public static final byte TAG_CONTEXT = -128;
    public static final byte TAG_PRIVATE = -64;
    private static final String QUOTATION_MARKS = "\"";
    private byte tag;
    private DERInputStream data;
    private DERInputBuffer buffer;
    private int length;

    public DERValue(String value) {
        this.tag = (byte)19;
        this.length = value.length();
        byte[] buf = new byte[this.length];
        for (int i = 0; i < this.length; ++i) {
            buf[i] = (byte)value.charAt(i);
        }
        this.buffer = new DERInputBuffer(buf);
        this.data = new DERInputStream(this.buffer);
        this.data.mark(Integer.MAX_VALUE);
    }

    public DERValue(byte tag, byte[] data) {
        this.tag = tag;
        this.buffer = new DERInputBuffer((byte[])data.clone());
        this.length = data.length;
        this.data = new DERInputStream(this.buffer);
        this.data.mark(Integer.MAX_VALUE);
    }

    DERValue(DERInputBuffer i) throws IOException {
        DERInputBuffer in = i;
        this.tag = (byte)in.read();
        this.length = DERInputStream.getLength(in);
        if (this.length == -1) {
            in.reset();
            byte[] indefData = new byte[in.available()];
            DataInputStream dis = new DataInputStream(in);
            dis.readFully(indefData);
            dis.close();
            DERIndefLenConverter derIn = new DERIndefLenConverter();
            in = new DERInputBuffer(derIn.convert(indefData));
            if (this.tag != in.read()) {
                throw new IOException("Indefinite length encoding not supported");
            }
            this.length = DERInputStream.getLength(in);
        }
        this.buffer = in.dup();
        this.buffer.truncate(this.length);
        this.data = new DERInputStream(this.buffer);
        in.skip(this.length);
    }

    public DERValue(InputStream in) throws IOException {
        this.init(false, in);
    }

    boolean isUniversal() {
        return (this.tag & 0xC0) == 0;
    }

    boolean isApplication() {
        return (this.tag & 0xC0) == 64;
    }

    public boolean isContextSpecific() {
        return (this.tag & 0xC0) == 128;
    }

    public boolean isContextSpecific(byte cntxtTag) {
        if (!this.isContextSpecific()) {
            return false;
        }
        return (this.tag & 0x1F) == cntxtTag;
    }

    boolean isPrivate() {
        return (this.tag & 0xC0) == 192;
    }

    public boolean isConstructed() {
        return (this.tag & 0x20) == 32;
    }

    private void init(boolean fullyBuffered, InputStream i) throws IOException {
        InputStream in = i;
        this.tag = (byte)in.read();
        byte lenByte = (byte)in.read();
        this.length = DERInputStream.getLength(lenByte & 0xFF, in);
        if (this.length == -1) {
            int readLen = in.available();
            int offset = 2;
            byte[] indefData = new byte[readLen + offset];
            indefData[0] = this.tag;
            indefData[1] = lenByte;
            DataInputStream dis = new DataInputStream(in);
            dis.readFully(indefData, offset, readLen);
            dis.close();
            DERIndefLenConverter derIn = new DERIndefLenConverter();
            in = new ByteArrayInputStream(derIn.convert(indefData));
            if (this.tag != in.read()) {
                throw new IOException("Indefinite length encoding not supported");
            }
            this.length = DERInputStream.getLength(in);
        }
        if (this.length == 0) {
            return;
        }
        if (fullyBuffered && in.available() != this.length) {
            throw new IOException("Extra data given to DERValue constructor");
        }
        byte[] bytes = new byte[this.length];
        DataInputStream dis = new DataInputStream(in);
        dis.readFully(bytes);
        this.buffer = new DERInputBuffer(bytes);
        this.data = new DERInputStream(this.buffer);
    }

    public void encode(DEROutputStream out) throws IOException {
        out.write(this.tag);
        out.putLength(this.length);
        if (this.length > 0) {
            byte[] value = new byte[this.length];
            this.buffer.reset();
            if (this.buffer.read(value) != this.length) {
                throw new IOException("short DER value read (encode)");
            }
            out.write(value);
        }
    }

    public boolean getBoolean() throws IOException {
        if (this.tag != 1) {
            throw new IOException("DerValue.getBoolean, not a BOOLEAN " + this.tag);
        }
        if (this.length != 1) {
            throw new IOException("DERValue.getBoolean, invalid length " + this.length);
        }
        return this.buffer.read() != 0;
    }

    public ObjectIdentifier getOID() throws IOException {
        if (this.tag != 6) {
            throw new IOException("DERValue.getOID, not an OID " + this.tag);
        }
        return new ObjectIdentifier(this.buffer);
    }

    public byte[] getOctetString() throws IOException {
        if (this.tag != 4) {
            throw new IOException("DERValue.getOctetString, not an Octet String: " + this.tag);
        }
        byte[] bytes = new byte[this.length];
        if (this.buffer.read(bytes) != this.length) {
            throw new IOException("short read on DERValue buffer");
        }
        return bytes;
    }

    public BigInt getInteger() throws IOException {
        if (this.tag != 2) {
            throw new IOException("DERValue.getInteger, not an int " + this.tag);
        }
        return this.buffer.getUnsigned(this.data.available());
    }

    public BigInt getInteger(boolean tagImplicit) throws IOException {
        if (!tagImplicit && this.tag != 2) {
            throw new IOException("DERValue.getInteger, not an int " + this.tag);
        }
        return this.buffer.getUnsigned(this.data.available());
    }

    public BigInt getEnumerated() throws IOException {
        if (this.tag != 10) {
            throw new IOException("DERValue.getEnumerated, incorrect tag: " + this.tag);
        }
        return this.buffer.getUnsigned(this.data.available());
    }

    public byte[] getBitString() throws IOException {
        if (this.tag != 3) {
            throw new IOException("DERValue.getBitString, not a bit string " + this.tag);
        }
        return this.buffer.getBitString();
    }

    public byte[] getBitString(boolean tagImplicit) throws IOException {
        if (!tagImplicit && this.tag != 3) {
            throw new IOException("DERValue.getBitString, not a bit string " + this.tag);
        }
        return this.buffer.getBitString();
    }

    public BitArray getUnalignedBitString() throws IOException {
        if (this.tag != 3) {
            throw new IOException("DERValue.getBitString, not a bit string " + this.tag);
        }
        return this.buffer.getUnalignedBitString();
    }

    public BitArray getUnalignedBitString(boolean tagImplicit) throws IOException {
        if (!tagImplicit && this.tag != 3) {
            throw new IOException("DERValue.getBitString, not a bit string " + this.tag);
        }
        return this.buffer.getUnalignedBitString();
    }

    public String getAsString() throws IOException {
        if (this.tag == 18) {
            return this.getUTF8String();
        }
        if (this.tag == 19) {
            return this.getPrintableString();
        }
        if (this.tag == 20) {
            return this.getT61String();
        }
        if (this.tag == 22) {
            return this.getIA5String();
        }
        if (this.tag == 30) {
            return this.getBMPString();
        }
        return null;
    }

    private byte[] getDataBytes() throws IOException {
        byte[] retVal = new byte[this.length];
        this.data.reset();
        this.data.getBytes(retVal);
        return retVal;
    }

    public String getPrintableString() throws IOException {
        if (this.tag != 19) {
            throw new IOException("DERValue.getPrintableString, not a string " + this.tag);
        }
        return new String(this.getDataBytes(), "ASCII");
    }

    public String getT61String() throws IOException {
        if (this.tag != 20) {
            throw new IOException("DERValue.getT61String, not T61 " + this.tag);
        }
        return new String(this.getDataBytes(), "ASCII");
    }

    public String getIA5String() throws IOException {
        if (this.tag != 22) {
            throw new IOException("DERValue.getIA5String, not IA5 " + this.tag);
        }
        return new String(this.getDataBytes(), "ASCII");
    }

    public String getBMPString() throws IOException {
        if (this.tag != 30) {
            throw new IOException("DERValue.getBMPString, not BMP " + this.tag);
        }
        return new String(this.getDataBytes(), "UnicodeBigUnmarked");
    }

    public String getUTF8String() throws IOException {
        if (this.tag != 18) {
            throw new IOException("DERValue.getUTF8String, not UTF-8 " + this.tag);
        }
        return new String(this.getDataBytes(), "UTF8");
    }

    public boolean equals(Object other) {
        if (other instanceof DERValue) {
            return this.equals((DERValue)other);
        }
        return false;
    }

    public boolean equals(DERValue other) {
        this.data.reset();
        other.data.reset();
        if (this == other) {
            return true;
        }
        if (this.tag != other.tag) {
            return false;
        }
        return this.buffer.equals(other.buffer);
    }

    public String toString() {
        try {
            if (this.tag == 18) {
                return QUOTATION_MARKS + this.getUTF8String() + QUOTATION_MARKS;
            }
            if (this.tag == 19) {
                return QUOTATION_MARKS + this.getPrintableString() + QUOTATION_MARKS;
            }
            if (this.tag == 20) {
                return QUOTATION_MARKS + this.getT61String() + QUOTATION_MARKS;
            }
            if (this.tag == 22) {
                return QUOTATION_MARKS + this.getIA5String() + QUOTATION_MARKS;
            }
            if (this.tag == 30) {
                return QUOTATION_MARKS + this.getBMPString() + QUOTATION_MARKS;
            }
            if (this.tag == 5) {
                return "[DERValue, null]";
            }
            if (this.tag == 6) {
                return "OID." + this.getOID();
            }
            return "[DERValue, tag = " + this.tag + ", length = " + this.length + "]";
        }
        catch (IOException e) {
            throw new IllegalArgumentException("misformatted DER value");
        }
    }

    public byte[] toByteArray() throws IOException {
        DEROutputStream out = new DEROutputStream();
        this.encode(out);
        this.data.reset();
        return out.toByteArray();
    }

    public DERInputStream toDERInputStream() throws IOException {
        if (this.tag == 48 || this.tag == 49) {
            return new DERInputStream(this.buffer);
        }
        throw new IOException("toDerInputStream rejects tag type " + this.tag);
    }

    public int length() {
        return this.length;
    }

    public static byte createTag(byte tagClass, boolean form, byte val) {
        byte t = (byte)(tagClass | val);
        if (form) {
            t = (byte)(t | 0x20);
        }
        return t;
    }

    public void resetTag(byte t) {
        this.tag = t;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

