/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.security.pki.impl.rsa.der;

import com.github.toolarium.security.pki.impl.rsa.der.DERInputBuffer;
import com.github.toolarium.security.pki.impl.rsa.der.DERInputStream;
import com.github.toolarium.security.pki.impl.rsa.der.DEROutputStream;
import java.io.IOException;
import java.io.Serializable;

public class ObjectIdentifier
implements Serializable {
    private static final long serialVersionUID = 8697030238860181294L;
    private static final int allocationQuantum = 5;
    private int[] components;
    private int componentLen;

    public ObjectIdentifier(String oid) {
        int ch = 46;
        int start = 0;
        int end = 0;
        this.componentLen = 0;
        while ((end = oid.indexOf(ch, start)) != -1) {
            start = end + 1;
            ++this.componentLen;
        }
        ++this.componentLen;
        this.components = new int[this.componentLen];
        start = 0;
        int i = 0;
        String comp = null;
        while ((end = oid.indexOf(ch, start)) != -1) {
            comp = oid.substring(start, end);
            this.components[i++] = Integer.valueOf(comp);
            start = end + 1;
        }
        comp = oid.substring(start);
        this.components[i] = Integer.valueOf(comp);
    }

    public ObjectIdentifier(int[] values) {
        try {
            this.components = (int[])values.clone();
            this.componentLen = values.length;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ObjectIdentifier(DERInputStream in) throws IOException {
        byte typeId = (byte)in.getByte();
        if (typeId != 6) {
            throw new IOException("X509.ObjectIdentifier() -- data isn't an object ID (tag = " + typeId + ")");
        }
        int bufferEnd = in.available() - in.getLength() - 1;
        if (bufferEnd < 0) {
            throw new IOException("X509.ObjectIdentifier() -- not enough data");
        }
        this.initFromEncoding(in, bufferEnd);
    }

    public ObjectIdentifier(DERInputBuffer buf) throws IOException {
        this.initFromEncoding(new DERInputStream(buf), 0);
    }

    private void initFromEncoding(DERInputStream in, int bufferEnd) throws IOException {
        boolean firstSubid = true;
        this.components = new int[5];
        this.componentLen = 0;
        while (in.available() > bufferEnd) {
            int component = ObjectIdentifier.getComponent(in);
            if (firstSubid) {
                int x = component < 40 ? 0 : (component < 80 ? 1 : 2);
                int y = component - x * 40;
                this.components[0] = x;
                this.components[1] = y;
                this.componentLen = 2;
                firstSubid = false;
                continue;
            }
            if (this.componentLen >= this.components.length) {
                int[] tmpComponents = new int[this.components.length + 5];
                System.arraycopy(this.components, 0, tmpComponents, 0, this.components.length);
                this.components = tmpComponents;
            }
            this.components[this.componentLen++] = component;
        }
        if (in.available() != bufferEnd) {
            throw new IOException("X509.ObjectIdentifier() -- malformed input data");
        }
    }

    void encode(DEROutputStream out) {
        DEROutputStream bytes = new DEROutputStream();
        bytes.write(this.components[0] * 40 + this.components[1]);
        for (int i = 2; i < this.componentLen; ++i) {
            ObjectIdentifier.putComponent(bytes, this.components[i]);
        }
        out.write((byte)6, bytes);
    }

    private static int getComponent(DERInputStream in) throws IOException {
        int retval = 0;
        for (int i = 0; i < 4; ++i) {
            retval <<= 7;
            int tmp = in.getByte();
            retval |= tmp & 0x7F;
            if ((tmp & 0x80) != 0) continue;
            return retval;
        }
        throw new IOException("X509.OID, component value too big");
    }

    private static void putComponent(DEROutputStream out, int v) {
        int i;
        int val = v;
        byte[] buf = new byte[4];
        for (i = 0; i < 4; ++i) {
            buf[i] = (byte)(val & 0x7F);
            if ((val >>>= 7) == 0) break;
        }
        while (i > 0) {
            out.write(buf[i] | 0x80);
            --i;
        }
        out.write(buf[0]);
    }

    public boolean precedes(ObjectIdentifier other) {
        if (other == this || this.componentLen < other.componentLen) {
            return false;
        }
        if (other.componentLen < this.componentLen) {
            return true;
        }
        for (int i = 0; i < this.componentLen; ++i) {
            if (other.components[i] >= this.components[i]) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object other) {
        if (other instanceof ObjectIdentifier) {
            return this.equals((ObjectIdentifier)other);
        }
        return false;
    }

    public boolean equals(ObjectIdentifier other) {
        if (other == this) {
            return true;
        }
        if (this.componentLen != other.componentLen) {
            return false;
        }
        for (int i = 0; i < this.componentLen; ++i) {
            if (this.components[i] == other.components[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        String retval = "";
        for (int i = 0; i < this.componentLen; ++i) {
            if (i != 0) {
                retval = retval + ".";
            }
            retval = retval + this.components[i];
        }
        return retval;
    }
}

