/*
 * Decompiled with CFR 0.152.
 */
package com.github.toolarium.security.pki.util;

import com.github.toolarium.common.ByteArray;
import com.github.toolarium.common.util.RandomGenerator;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PKIUtil {
    private static final Logger LOG = LoggerFactory.getLogger(PKIUtil.class);
    private static final String NL = "\n";

    private PKIUtil() {
    }

    public static PKIUtil getInstance() {
        return HOLDER.INSTANCE;
    }

    public KeyPair generateKeyPair(String algorithm, int k) throws GeneralSecurityException {
        return this.generateKeyPair(null, algorithm, k);
    }

    public KeyPair generateKeyPair(String provider, String algorithm, int k) throws GeneralSecurityException {
        String msg = algorithm;
        if (provider != null && provider.trim().length() > 0) {
            msg = provider + "/" + algorithm;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Generating new KeyPair (" + msg + ")...");
        }
        KeyPairGenerator keyPairGenerator = null;
        keyPairGenerator = provider != null && provider.trim().length() > 0 ? KeyPairGenerator.getInstance(algorithm, provider) : KeyPairGenerator.getInstance(algorithm);
        int keySize = k;
        if (keySize <= 0) {
            keySize = 2048;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initializing the key generator (" + keySize + " bits).");
        }
        keyPairGenerator.initialize(keySize, RandomGenerator.getInstance().getSecureRandom());
        KeyPair pair = keyPairGenerator.genKeyPair();
        return pair;
    }

    public void processCertificate(Consumer<String> consumer, String msg, X509Certificate ... cert) {
        StringBuilder message = new StringBuilder();
        if (msg != null) {
            message.append(msg);
            message.append(NL);
        }
        if (cert != null && cert.length > 0) {
            for (int i = 0; i < cert.length; ++i) {
                if (cert[i] == null) {
                    message.append("X.509 Certificate is null");
                    if (cert.length > 1) {
                        message.append(" #").append(i + 1);
                    }
                    message.append("!\n");
                    continue;
                }
                message.append("X.509 Certificate information");
                if (cert.length > 1) {
                    message.append(" #").append(i + 1);
                }
                message.append(":\n");
                message.append("  signature algorithm name: " + cert[i].getSigAlgName() + NL + "  signature algorithm OID : " + cert[i].getSigAlgOID() + NL + "  certificate type        : " + cert[i].getType() + NL + "  certificate version     : " + cert[i].getVersion() + NL + "  certificate subject     : " + cert[i].getSubjectX500Principal() + NL + "  certificate issuer      : " + cert[i].getIssuerX500Principal() + NL + "  certificate valid from  : " + cert[i].getNotBefore() + NL + "  certificate valid till  : " + cert[i].getNotAfter());
                PublicKey publicKey = cert[i].getPublicKey();
                if (publicKey == null) continue;
                message.append("\n\n  PublicKey information:\n    algorithm  : " + publicKey.getAlgorithm() + NL + "    format     : " + publicKey.getFormat() + NL);
            }
            consumer.accept(message.toString());
        }
    }

    public void processPrivateKeyInfo(Consumer<String> consumer, String msg, PrivateKey privateKey) {
        StringBuilder message = new StringBuilder();
        if (msg != null) {
            message.append(msg + NL);
        }
        if (privateKey == null) {
            message.append("PrivateKey is null!");
        } else {
            message.append("PrivateKey information:\n  algorithm: " + privateKey.getAlgorithm() + NL + "  format   : " + privateKey.getFormat());
        }
        consumer.accept(message.toString());
    }

    public void processPublicKeyInfo(Consumer<String> consumer, String msg, PublicKey publicKey) {
        StringBuilder message = new StringBuilder();
        if (msg != null) {
            message.append(msg + NL);
        }
        if (publicKey == null) {
            message.append("PublicKey is null!");
        } else {
            message.append("PublicKey information:\n  algorithm: " + publicKey.getAlgorithm() + NL + "  format   : " + publicKey.getFormat());
        }
        consumer.accept(message.toString());
    }

    public String formatBuffer(String rawCertificate, int rowWith, String startTag, String endTag) {
        return this.formatBuffer(new ByteArray(rawCertificate.getBytes()), rowWith, startTag, endTag).toString();
    }

    public ByteArray formatBuffer(ByteArray rawCertificate, int rowWith, String startTag, String endTag) {
        if (rawCertificate == null) {
            return rawCertificate;
        }
        if (rawCertificate.toString().startsWith(startTag)) {
            return rawCertificate;
        }
        ByteArray formatedData = new ByteArray();
        formatedData.append(startTag);
        int pos = 0;
        boolean allreadyAdded = false;
        for (int i = 0; i < rawCertificate.length(); ++i) {
            byte b;
            if (!allreadyAdded && pos % rowWith == 0) {
                formatedData.append((byte)10);
                allreadyAdded = true;
            }
            if ((b = rawCertificate.get(i)) == 10 || b == 13) continue;
            allreadyAdded = false;
            formatedData.append(b);
            ++pos;
        }
        formatedData.append((byte)10);
        formatedData.append(endTag);
        return formatedData;
    }

    public String normalizeBuffer(String rawCertificate, String startTag, String endTag) {
        return this.normalizeBuffer(new ByteArray(rawCertificate), startTag, endTag).toString();
    }

    public ByteArray normalizeBuffer(ByteArray rawCertificate, String startTag, String endTag) {
        int index;
        if (rawCertificate == null) {
            return rawCertificate;
        }
        String data = rawCertificate.toString();
        if (startTag != null && (index = data.indexOf(startTag)) >= 0) {
            data = data.substring(index + startTag.length());
        }
        if (endTag != null && (index = data.indexOf(endTag)) >= 0) {
            data = data.substring(0, index);
        }
        ByteArray newData = new ByteArray();
        char ch = '\u0000';
        for (int i = 0; i < data.length(); ++i) {
            ch = data.charAt(i);
            if (ch == '\n' || ch == '\r') continue;
            newData.append((byte)ch);
        }
        return newData;
    }

    private static class HOLDER {
        static final PKIUtil INSTANCE = new PKIUtil();

        private HOLDER() {
        }
    }
}

