/*
 * Decompiled with CFR 0.152.
 */
package pl.zientarski;

import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.List;
import pl.zientarski.ReferenceNameProvider;
import pl.zientarski.Utils;

public class DefaultReferenceNameProvider
implements ReferenceNameProvider {
    protected String getPrefix() {
        return "";
    }

    @Override
    public String typeReferenceName(Class<?> clazz, List<Type> genericTypeArguments) {
        StringBuilder ref = new StringBuilder();
        if (Utils.isPrimitiveTypeWrapper(clazz)) {
            ref.append(Utils.unwrap(clazz).getSimpleName());
        } else {
            ref.append(clazz.getSimpleName());
        }
        this.appendGenericType(ref, genericTypeArguments);
        return this.getPrefix() + ref.toString();
    }

    protected void appendGenericType(StringBuilder ref, List<Type> genericTypeArguments) {
        if (genericTypeArguments == null || genericTypeArguments.size() == 0) {
            return;
        }
        Type removed = genericTypeArguments.remove(0);
        ref.append("<");
        if (removed instanceof TypeVariable) {
            ref.append(((TypeVariable)removed).getName());
        } else {
            ref.append(((Class)removed).getSimpleName());
            this.appendGenericType(ref, genericTypeArguments);
        }
        ref.append(">");
    }
}

