/*
 * Decompiled with CFR 0.152.
 */
package pl.zientarski;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;
import pl.zientarski.DefaultReferenceNameProvider;
import pl.zientarski.DescriptionProvider;
import pl.zientarski.MappingException;
import pl.zientarski.PropertyDiscoveryMode;
import pl.zientarski.ReferenceNameProvider;

public class MapperContext {
    private Map<String, Type> genericTypeNamesToTypesMapping;
    private ReferenceNameProvider referenceNameProvider = new DefaultReferenceNameProvider();
    private final List<Type> dependencies = new LinkedList<Type>();
    private String dateTimeFormat = "date-time";
    private boolean strict = true;
    private PropertyDiscoveryMode propertyDiscoveryMode = PropertyDiscoveryMode.GETTER_WITH_FIELD;
    private final Set<Class<? extends Annotation>> requiredFieldAnnotations = new HashSet<Class<? extends Annotation>>();
    private DescriptionProvider descriptionProvider;

    public Type getGenericTypeByName(String name) {
        if (this.genericTypeNamesToTypesMapping == null || !this.genericTypeNamesToTypesMapping.containsKey(name)) {
            throw new MappingException("Cannot perform mapping of generic type without type parameter specified.");
        }
        return this.genericTypeNamesToTypesMapping.get(name);
    }

    public String getTypeReference(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return this.referenceNameProvider.typeReferenceName((Class)parameterizedType.getRawType(), this.getGenericReferenceArgumentList(parameterizedType));
        }
        return this.referenceNameProvider.typeReferenceName((Class)type, null);
    }

    public void setGenericTypeNamesToTypesMapping(Map<String, Type> genericTypeNamesToTypesMapping) {
        this.genericTypeNamesToTypesMapping = genericTypeNamesToTypesMapping;
    }

    public void setReferenceNameProvider(ReferenceNameProvider referenceNameProvider) {
        this.referenceNameProvider = referenceNameProvider;
    }

    public void setRequiredFieldAnnotation(List<Class<? extends Annotation>> annotations) {
        this.requiredFieldAnnotations.clear();
        this.requiredFieldAnnotations.addAll(annotations);
    }

    public void setDescriptionProvider(DescriptionProvider descriptionProvider) {
        this.descriptionProvider = descriptionProvider;
    }

    public void addDescription(Type type, JSONObject object) {
        if (this.descriptionProvider == null) {
            return;
        }
        object.put("description", (Object)this.descriptionProvider.process(type));
    }

    public void addDependency(Type type) {
        if (!this.dependencies.contains(type)) {
            this.dependencies.add(type);
        }
    }

    public Iterator<Type> getDependencies() {
        return new Iterator<Type>(){
            int pointer = 0;

            @Override
            public boolean hasNext() {
                return this.pointer != MapperContext.this.dependencies.size();
            }

            @Override
            public Type next() {
                return (Type)MapperContext.this.dependencies.get(this.pointer++);
            }
        };
    }

    public void setDateTimeFormat(String format) {
        this.dateTimeFormat = format;
    }

    public String getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public void setPropertyDiscoveryMode(PropertyDiscoveryMode propertyDiscoveryMode) {
        this.propertyDiscoveryMode = propertyDiscoveryMode;
    }

    public PropertyDiscoveryMode getPropertyDiscoveryMode() {
        return this.propertyDiscoveryMode;
    }

    public Set<Class<? extends Annotation>> getRequiredFieldAnnotations() {
        return this.requiredFieldAnnotations;
    }

    private List<Type> getGenericReferenceArgumentList(ParameterizedType type) {
        LinkedList<Type> result = new LinkedList<Type>();
        Type argument = type.getActualTypeArguments()[0];
        while (argument instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)argument;
            Type rawType = parameterizedType.getRawType();
            result.add(rawType);
            argument = parameterizedType.getActualTypeArguments()[0];
        }
        if (argument instanceof TypeVariable) {
            String name = ((TypeVariable)argument).getName();
            result.add(this.getGenericTypeByName(name));
        }
        if (argument instanceof Class) {
            result.add(argument);
        }
        return result;
    }
}

