/*
 * Decompiled with CFR 0.152.
 */
package pl.zientarski;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import pl.zientarski.MapperContext;
import pl.zientarski.MappingException;

public class PropertyDescription {
    private final boolean hasField;
    private final boolean hasSetter;
    private final boolean hasGetter;
    private final Type type;
    private final Set<Annotation> getterAnnotations = new HashSet<Annotation>();
    private final Set<Annotation> setterAnnotations = new HashSet<Annotation>();
    private final Set<Annotation> fieldAnnotations = new HashSet<Annotation>();
    private final Set<Annotation> allAnnotations = new HashSet<Annotation>();
    private final String name;
    private final MapperContext mapperContext;

    public PropertyDescription(String name, Field field, Method setter, Method getter, MapperContext mapperContext) {
        this.mapperContext = mapperContext;
        PropertyDescription.assertName(name);
        PropertyDescription.assertTypesMatch(field, getter, setter);
        this.type = this.readType(field, getter, setter);
        this.name = name;
        if (field != null) {
            this.fieldAnnotations.addAll(Arrays.asList(field.getAnnotations()));
        }
        if (setter != null) {
            this.setterAnnotations.addAll(Arrays.asList(setter.getAnnotations()));
        }
        if (getter != null) {
            this.getterAnnotations.addAll(Arrays.asList(getter.getAnnotations()));
        }
        this.hasField = field != null;
        this.hasSetter = setter != null;
        this.hasGetter = getter != null;
        this.allAnnotations.addAll(this.getterAnnotations);
        this.allAnnotations.addAll(this.setterAnnotations);
        this.allAnnotations.addAll(this.fieldAnnotations);
    }

    private Type readType(Field field, Method getter, Method setter) {
        Type type = null;
        if (field != null) {
            type = field.getGenericType();
        }
        if (setter != null) {
            type = setter.getGenericParameterTypes()[0];
        }
        if (getter != null) {
            type = getter.getGenericReturnType();
        }
        return this.replaceGenericVariables(type);
    }

    private Type replaceGenericVariables(Type type) {
        if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            return this.mapperContext.getGenericTypeByName(typeVariable.getTypeName());
        }
        return type;
    }

    private static void assertName(String name) {
        if (name == null || name.length() == 0) {
            throw new MappingException("Parameter name cannot be empty");
        }
    }

    private static void assertTypesMatch(Field field, Method getter, Method setter) {
        if (setter == null && getter == null && field == null) {
            throw new MappingException("All parameters null");
        }
        if (setter != null && setter.getParameterCount() != 1) {
            throw new MappingException("Setter " + setter + " should have single parameter");
        }
        if (field != null && getter != null && !field.getGenericType().equals(getter.getGenericReturnType())) {
            throw new MappingException("Field and getter " + getter + " types did not match");
        }
        if (field != null && setter != null && !field.getGenericType().equals(setter.getGenericParameterTypes()[0])) {
            throw new MappingException("Field and setter " + setter + " types did not match");
        }
        if (getter != null && setter != null && !getter.getGenericReturnType().equals(setter.getGenericParameterTypes()[0])) {
            throw new MappingException("Getter and setter " + setter + " types did not match");
        }
    }

    public boolean hasGetter() {
        return this.hasGetter;
    }

    public boolean hasSetter() {
        return this.hasSetter;
    }

    public boolean hasField() {
        return this.hasField;
    }

    public boolean hasAnnotation(Class<? extends Annotation> annotation) {
        return this.allAnnotations.stream().filter(a -> a.annotationType().equals(annotation)).findAny().isPresent();
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }
}

