/*
 * Decompiled with CFR 0.152.
 */
package pl.zientarski;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.json.JSONObject;
import pl.zientarski.DefaultReferenceNameProvider;
import pl.zientarski.DefinitionsReferenceNameProvider;
import pl.zientarski.DescriptionProvider;
import pl.zientarski.MapperContext;
import pl.zientarski.MappingException;
import pl.zientarski.PropertyDiscoveryMode;
import pl.zientarski.ReferenceNameProvider;
import pl.zientarski.TypeDescription;
import pl.zientarski.Utils;
import pl.zientarski.typehandler.AnyTypeHandler;
import pl.zientarski.typehandler.ArrayTypeHandler;
import pl.zientarski.typehandler.DateTimeTypeHandler;
import pl.zientarski.typehandler.DefaultTypeHandler;
import pl.zientarski.typehandler.EnumTypeHandler;
import pl.zientarski.typehandler.PrimitiveTypeHandler;
import pl.zientarski.typehandler.PrimitiveTypeWrapperHandler;
import pl.zientarski.typehandler.TypeHandler;

public class SchemaMapper {
    private final MapperContext mapperContext = new MapperContext();
    private final List<TypeHandler> typeHandlers = new LinkedList<TypeHandler>();

    public SchemaMapper() {
        this.typeHandlers.add(new EnumTypeHandler());
        this.typeHandlers.add(new ArrayTypeHandler());
        this.typeHandlers.add(new PrimitiveTypeHandler());
        this.typeHandlers.add(new PrimitiveTypeWrapperHandler());
        this.typeHandlers.add(new DateTimeTypeHandler());
        this.typeHandlers.add(new DefaultTypeHandler());
        this.typeHandlers.add(new AnyTypeHandler());
    }

    public void setReferenceNameProvider(ReferenceNameProvider referenceNameProvider) {
        this.mapperContext.setReferenceNameProvider(referenceNameProvider);
    }

    public void setPropertyDiscoveryMode(PropertyDiscoveryMode propertyDiscoveryMode) {
        this.mapperContext.setPropertyDiscoveryMode(propertyDiscoveryMode);
    }

    public void setDateTimeFormat(String format) {
        this.mapperContext.setDateTimeFormat(format);
    }

    public void setRelaxedMode(boolean isRelaxed) {
        this.mapperContext.setStrict(!isRelaxed);
    }

    public void setRequiredFieldAnnotations(List<Class<? extends Annotation>> annotations) {
        this.mapperContext.setRequiredFieldAnnotation(annotations);
    }

    public void addTypeHandler(TypeHandler typeHandler) {
        this.typeHandlers.add(0, typeHandler);
    }

    public void setDescriptionProvider(DescriptionProvider descriptionProvider) {
        this.mapperContext.setDescriptionProvider(descriptionProvider);
    }

    public Iterator<Type> getDependencies() {
        return this.mapperContext.getDependencies();
    }

    public JSONObject toJsonSchema4(Type type) {
        if (Utils.isParameterizedType(type)) {
            ParameterizedType genericType = (ParameterizedType)type;
            Type rawType = genericType.getRawType();
            Map<String, Type> genericTypeNamesToTypes = SchemaMapper.discoverGenericTypeNameToActualTypeMapping(genericType);
            this.mapperContext.setGenericTypeNamesToTypesMapping(genericTypeNamesToTypes);
            return this.toJsonSchema4(rawType);
        }
        return this.toJsonSchema4((Class)type);
    }

    public JSONObject toJsonSchema4(Class<?> clazz) {
        Optional<TypeHandler> typeHandler = this.typeHandlers.stream().filter(th -> th.accepts(clazz)).findFirst();
        if (typeHandler.isPresent()) {
            return typeHandler.get().process(new TypeDescription(clazz, this.mapperContext), this.mapperContext);
        }
        throw new MappingException("No type handler for type: " + clazz.toString());
    }

    public JSONObject toJsonSchema4(Class<?> clazz, boolean includeDependencies) {
        if (includeDependencies) {
            this.setReferenceNameProvider(new DefinitionsReferenceNameProvider());
            JSONObject schema = this.toJsonSchema4(clazz);
            this.setReferenceNameProvider(new DefaultReferenceNameProvider());
            JSONObject definitions = new JSONObject();
            this.getDependencies().forEachRemaining(type -> {
                JSONObject dependencySchema = this.toJsonSchema4((Type)type);
                dependencySchema.remove("$schema");
                definitions.put(this.mapperContext.getTypeReference((Type)type), (Object)dependencySchema);
            });
            schema.put("definitions", (Object)definitions);
            return schema;
        }
        return this.toJsonSchema4(clazz);
    }

    private static Map<String, Type> discoverGenericTypeNameToActualTypeMapping(ParameterizedType genericType) {
        HashMap<String, Type> result = new HashMap<String, Type>();
        Class rawType = (Class)genericType.getRawType();
        TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
        Type[] actualTypeArguments = genericType.getActualTypeArguments();
        for (int i = 0; i < typeParameters.length; ++i) {
            result.put(typeParameters[i].getName(), actualTypeArguments[i]);
        }
        return result;
    }
}

