/*
 * Decompiled with CFR 0.152.
 */
package pl.zientarski;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import pl.zientarski.MapperContext;
import pl.zientarski.PropertyDescription;

public class TypeDescription {
    private static final Predicate<Method> hasGetterName = method -> method.getName().length() > 3 && method.getName().startsWith("get") || method.getName().length() > 2 && method.getName().startsWith("is");
    private static final Predicate<Method> hasSetterName = method -> method.getName().length() > 3 && method.getName().startsWith("set");
    private static final Predicate<Method> hasZeroParameters = method -> method.getParameterCount() == 0;
    private static final Predicate<Method> hasOneParameter = method -> method.getParameterCount() == 1;
    private static final Predicate<Method> fromObject = method -> method.getDeclaringClass().equals(Object.class);
    private static final Predicate<Method> isSetter = method -> hasSetterName.and(hasOneParameter).and(fromObject.negate()).test((Method)method);
    private static final Predicate<Method> isGetter = method -> hasGetterName.and(hasZeroParameters).and(fromObject.negate()).test((Method)method);
    private static final Predicate<Field> isThisReference = field -> field.getName().equals("this$0");
    private final Type type;
    private final MapperContext mapperContext;

    public TypeDescription(Type type, MapperContext mapperContext) {
        this.type = type;
        this.mapperContext = mapperContext;
    }

    public Type getType() {
        return this.type;
    }

    public Set<PropertyDescription> getProperties() {
        return this.getProperties((Class)this.type);
    }

    public Set<PropertyDescription> getProperties(Class<?> clazz) {
        DefaultHashMap fours = new DefaultHashMap();
        TypeDescription.getAllFields(clazz).stream().filter(isThisReference.negate()).forEach(field -> {
            Four four = (Four)fours.get(TypeDescription.hash(field));
            four.field = field;
            four.name = field.getName();
        });
        Arrays.asList(clazz.getMethods()).stream().filter(isSetter).forEach(setter -> {
            Four four = (Four)fours.get(TypeDescription.hashSetter(setter));
            four.setter = setter;
            four.name = TypeDescription.toFieldName(setter.getName());
        });
        Arrays.asList(clazz.getMethods()).stream().filter(isGetter).forEach(getter -> {
            Four four = (Four)fours.get(TypeDescription.hashGetter(getter));
            four.getter = getter;
            four.name = TypeDescription.toFieldName(getter.getName());
        });
        return fours.values().stream().map(four -> new PropertyDescription(four.name, four.field, four.setter, four.getter, this.mapperContext)).collect(Collectors.toSet());
    }

    private static Object hashGetter(Method getter) {
        return String.format("%s %s", TypeDescription.toFieldName(getter.getName()), getter.getGenericReturnType().getTypeName());
    }

    private static Object hashSetter(Method setter) {
        return String.format("%s %s", TypeDescription.toFieldName(setter.getName()), setter.getGenericParameterTypes()[0].getTypeName());
    }

    private static String hash(Field field) {
        return String.format("%s %s", field.getName(), field.getGenericType().getTypeName());
    }

    private static String toFieldName(String methodName) {
        if (methodName.startsWith("is")) {
            return methodName.substring(2, 3).toLowerCase() + methodName.substring(3);
        }
        return methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
    }

    private static Set<Field> getAllFields(Class<?> clazz) {
        if (clazz.equals(Object.class)) {
            return new HashSet<Field>();
        }
        HashSet<Field> fields = new HashSet<Field>(Arrays.asList(clazz.getDeclaredFields()));
        if (clazz.isInterface()) {
            for (Class<?> superInterface : clazz.getInterfaces()) {
                fields.addAll(TypeDescription.getAllFields(superInterface));
            }
        } else {
            fields.addAll(TypeDescription.getAllFields(clazz.getSuperclass()));
        }
        return fields;
    }

    private static class DefaultHashMap
    extends HashMap<String, Four> {
        private static final long serialVersionUID = 3379715062215139110L;

        private DefaultHashMap() {
        }

        @Override
        public Four get(Object key) {
            if (this.containsKey(key)) {
                return (Four)super.get(key);
            }
            Four triple = new Four();
            this.put((String)key, triple);
            return triple;
        }
    }

    private static class Four {
        String name;
        Field field;
        Method getter;
        Method setter;

        private Four() {
        }
    }
}

