/*
 * Decompiled with CFR 0.152.
 */
package pl.zientarski;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public final class Utils {
    private static final Map<Class<?>, Class<?>> primitivesToWrappers = new HashMap();

    public static boolean isPrimitiveTypeWrapper(Class<?> clazz) {
        return primitivesToWrappers.containsKey(clazz);
    }

    public static Class<?> unwrap(Class<?> clazz) {
        if (Utils.isPrimitiveTypeWrapper(clazz)) {
            return primitivesToWrappers.get(clazz);
        }
        return clazz;
    }

    public static boolean isPrimitiveType(Class<?> clazz) {
        return clazz.isPrimitive();
    }

    public static boolean isDirectlyMappedToJsonSchemaType(Class<?> clazz) {
        return clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE) || clazz.equals(String.class);
    }

    public static boolean isArrayType(Class<?> clazz) {
        return clazz.isArray();
    }

    public static boolean isEnumType(Class<?> clazz) {
        return clazz.isEnum();
    }

    public static boolean isParameterizedType(Type type) {
        return type instanceof ParameterizedType;
    }

    public static boolean isWildcardType(Type type) {
        return type instanceof WildcardType;
    }

    public static boolean isTypeVariable(Type type) {
        return type instanceof TypeVariable;
    }

    public static boolean isDateTime(Class<?> clazz) {
        return Calendar.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz);
    }

    public static Type getTypeArgument(Class<?> clazz) {
        return clazz.getComponentType();
    }

    public static Type getTypeArgument(ParameterizedType genericType) {
        return genericType.getActualTypeArguments()[0];
    }

    public static Type getTypeArgument(WildcardType genericType) {
        return genericType.getUpperBounds()[0];
    }

    static {
        primitivesToWrappers.put(Boolean.class, Boolean.TYPE);
        primitivesToWrappers.put(Byte.class, Byte.TYPE);
        primitivesToWrappers.put(Character.class, Character.TYPE);
        primitivesToWrappers.put(Double.class, Double.TYPE);
        primitivesToWrappers.put(Float.class, Float.TYPE);
        primitivesToWrappers.put(Integer.class, Integer.TYPE);
        primitivesToWrappers.put(Long.class, Long.TYPE);
        primitivesToWrappers.put(Short.class, Short.TYPE);
        primitivesToWrappers.put(Void.class, Void.TYPE);
    }
}

