/*
 * Decompiled with CFR 0.152.
 */
package pl.zientarski.serialization;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import org.json.JSONObject;
import pl.zientarski.MapperContext;
import pl.zientarski.PropertyDescription;
import pl.zientarski.Utils;
import pl.zientarski.serialization.PropertySerializer;

public class CollectionSerializer
extends PropertySerializer {
    private final Type collectedType;

    public CollectionSerializer(PropertyDescription propertyDescription, Type collectedType, MapperContext mapperContext) {
        super(propertyDescription, mapperContext);
        this.collectedType = collectedType;
    }

    @Override
    public JSONObject toJsonObject() {
        return this.arrayTypeSchema(this.collectedType);
    }

    protected JSONObject arrayTypeSchema(Type typeArgument) {
        JSONObject items = new JSONObject();
        Type itemType = this.getItemType(typeArgument);
        if (Utils.isParameterizedType(itemType)) {
            items = this.arrayTypeSchema(Utils.getTypeArgument((ParameterizedType)itemType));
        } else if (Utils.isTypeVariable(itemType)) {
            Type genericTypeByName = this.mapperContext.getGenericTypeByName(itemType.getTypeName());
            items.put("$ref", (Object)this.mapperContext.getTypeReference(genericTypeByName));
        } else {
            Class itemClass = (Class)itemType;
            if (itemClass.equals(Boolean.TYPE) || itemClass.equals(Boolean.class)) {
                items.put("type", (Object)"boolean");
            } else if (itemClass.equals(Object.class)) {
                items.put("type", (Object)"any");
            } else if (itemClass.equals(String.class)) {
                items.put("type", (Object)"string");
            } else if (itemClass.isArray()) {
                items = this.arrayTypeSchema(Utils.getTypeArgument(itemClass));
            } else {
                items.put("$ref", (Object)this.mapperContext.getTypeReference(itemClass));
                this.mapperContext.addDependency(itemType);
            }
        }
        JSONObject result = new JSONObject();
        result.put("type", (Object)"array");
        result.put("items", (Object)items);
        return result;
    }

    private Type getItemType(Type typeArgument) {
        if (Utils.isWildcardType(typeArgument)) {
            return Utils.getTypeArgument((WildcardType)typeArgument);
        }
        return typeArgument;
    }
}

