/*
 * Decompiled with CFR 0.152.
 */
package pl.zientarski.serialization;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.json.JSONObject;
import pl.zientarski.MapperContext;
import pl.zientarski.PropertyDescription;
import pl.zientarski.serialization.PropertySerializer;

public class DirectTypeSerializer
extends PropertySerializer {
    public DirectTypeSerializer(PropertyDescription propertyDescription, MapperContext mapperContext) {
        super(propertyDescription, mapperContext);
    }

    @Override
    public boolean isPropertyRequired() {
        if (this.propertyDescription.getType().equals(Boolean.TYPE)) {
            return true;
        }
        for (Class<? extends Annotation> annotation : this.mapperContext.getRequiredFieldAnnotations()) {
            if (!this.propertyDescription.hasAnnotation(annotation)) continue;
            return true;
        }
        return false;
    }

    @Override
    public JSONObject toJsonObject() {
        Type type = this.propertyDescription.getType();
        JSONObject result = new JSONObject();
        if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            result.put("type", (Object)"boolean");
        }
        if (type.equals(String.class)) {
            result.put("type", (Object)"string");
        }
        return result;
    }
}

