/*
 * Decompiled with CFR 0.152.
 */
package pl.zientarski.serialization;

import java.lang.reflect.ParameterizedType;
import org.json.JSONObject;
import pl.zientarski.MapperContext;
import pl.zientarski.MappingException;
import pl.zientarski.PropertyDescription;
import pl.zientarski.serialization.ObjectSerializer;

public class GenericObjectSerializer
extends ObjectSerializer {
    private final ParameterizedType type;

    public GenericObjectSerializer(PropertyDescription propertyDescription, MapperContext mapperContext) {
        super(propertyDescription, mapperContext);
        this.type = (ParameterizedType)propertyDescription.getType();
    }

    @Override
    public JSONObject toJsonObject() {
        JSONObject result = new JSONObject();
        if (this.type.getActualTypeArguments().length != 1) {
            if (this.mapperContext.isStrict()) {
                throw new MappingException("Could not serialize type:" + this.type);
            }
            result.put("type", (Object)"any");
        } else {
            result.put("$ref", (Object)this.getReference());
        }
        return result;
    }

    @Override
    protected String getReference() {
        this.mapperContext.addDependency(this.type);
        return this.mapperContext.getTypeReference(this.type);
    }
}

