/*
 * Decompiled with CFR 0.152.
 */
package pl.zientarski.serialization;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import pl.zientarski.MapperContext;
import pl.zientarski.PropertyDescription;
import pl.zientarski.Utils;
import pl.zientarski.serialization.CollectionSerializer;
import pl.zientarski.serialization.DirectTypeSerializer;
import pl.zientarski.serialization.GenericObjectSerializer;
import pl.zientarski.serialization.ObjectSerializer;
import pl.zientarski.serialization.PrimitiveSerializer;
import pl.zientarski.serialization.PropertySerializer;

public interface PropertySerializerFactory {
    public static PropertySerializer get(PropertyDescription description, MapperContext mapperContext) {
        Type type = description.getType();
        return PropertySerializerFactory.getForType(type, description, mapperContext);
    }

    public static PropertySerializer getForType(Type type, PropertyDescription description, MapperContext mapperContext) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            if (Collection.class.isAssignableFrom((Class)parameterizedType.getRawType())) {
                return new CollectionSerializer(description, parameterizedType.getActualTypeArguments()[0], mapperContext);
            }
            return new GenericObjectSerializer(description, mapperContext);
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            Type genericType = mapperContext.getGenericTypeByName(typeVariable.getTypeName());
            return PropertySerializerFactory.getForType(genericType, description, mapperContext);
        }
        Class clazz = (Class)type;
        if (Utils.isArrayType(clazz)) {
            return new CollectionSerializer(description, clazz.getComponentType(), mapperContext);
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return new CollectionSerializer(description, (Type)((Object)Object.class), mapperContext);
        }
        if (Utils.isDirectlyMappedToJsonSchemaType(clazz)) {
            return new DirectTypeSerializer(description, mapperContext);
        }
        if (Utils.isPrimitiveType(clazz)) {
            return new PrimitiveSerializer(description, mapperContext);
        }
        if (Utils.isEnumType(clazz)) {
            return new ObjectSerializer(description, mapperContext);
        }
        return new ObjectSerializer(description, mapperContext);
    }
}

