/*
 * Decompiled with CFR 0.152.
 */
package pl.zientarski.typehandler;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.json.JSONObject;
import pl.zientarski.MapperContext;
import pl.zientarski.TypeDescription;
import pl.zientarski.Utils;
import pl.zientarski.typehandler.TypeHandler;

public class ArrayTypeHandler
implements TypeHandler {
    @Override
    public boolean accepts(Type type) {
        return !(type instanceof ParameterizedType) && Utils.isArrayType((Class)type);
    }

    @Override
    public JSONObject process(TypeDescription typeDescription, MapperContext mapperContext) {
        Class clazz = (Class)typeDescription.getType();
        return ArrayTypeHandler.arrayTypeSchema(Utils.getTypeArgument(clazz), mapperContext);
    }

    public static JSONObject arrayTypeSchema(Type typeArgument, MapperContext mapperContext) {
        JSONObject items = new JSONObject();
        if (Utils.isParameterizedType(typeArgument)) {
            items = ArrayTypeHandler.arrayTypeSchema(Utils.getTypeArgument((ParameterizedType)typeArgument), mapperContext);
        } else {
            Class itemClass = (Class)typeArgument;
            if (itemClass.equals(Boolean.TYPE) || itemClass.equals(Boolean.class)) {
                items.put("type", (Object)"boolean");
            } else if (itemClass.equals(String.class)) {
                items.put("type", (Object)"string");
            } else if (itemClass.isArray()) {
                items = ArrayTypeHandler.arrayTypeSchema(Utils.getTypeArgument(itemClass), mapperContext);
            } else {
                items.put("$ref", (Object)mapperContext.getTypeReference(itemClass));
                mapperContext.addDependency(typeArgument);
            }
        }
        JSONObject result = new JSONObject();
        result.put("type", (Object)"array");
        result.put("items", (Object)items);
        result.put("$schema", (Object)"http://json-schema.org/draft-04/schema#");
        return result;
    }
}

