/*
 * Decompiled with CFR 0.152.
 */
package pl.zientarski.typehandler;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;
import pl.zientarski.MapperContext;
import pl.zientarski.MappingException;
import pl.zientarski.PropertyDescription;
import pl.zientarski.PropertyDiscoveryMode;
import pl.zientarski.TypeDescription;
import pl.zientarski.serialization.PropertySerializer;
import pl.zientarski.serialization.PropertySerializerFactory;
import pl.zientarski.typehandler.TypeHandler;

public class DefaultTypeHandler
implements TypeHandler {
    private static final Predicate<PropertyDescription> hasGetter = PropertyDescription::hasGetter;
    private static final Predicate<PropertyDescription> hasField = PropertyDescription::hasField;

    @Override
    public boolean accepts(Type type) {
        return !(type instanceof ParameterizedType);
    }

    @Override
    public JSONObject process(TypeDescription typeDescription, MapperContext mapperContext) {
        Set<PropertyDescription> properties = typeDescription.getProperties();
        JSONObject result = new JSONObject();
        result.put("type", (Object)"object");
        result.put("additionalProperties", false);
        result.put("$schema", (Object)"http://json-schema.org/draft-04/schema#");
        mapperContext.addDescription(typeDescription.getType(), result);
        Predicate<PropertyDescription> byGetterSetterAndFieldPresence = this.getByGetterSetterAndFieldPresencePredicate(mapperContext.getPropertyDiscoveryMode());
        Set<PropertyDescription> filteredProperties = properties.stream().filter(byGetterSetterAndFieldPresence).collect(Collectors.toSet());
        this.addProperties(result, filteredProperties, mapperContext);
        return result;
    }

    private Predicate<PropertyDescription> getByGetterSetterAndFieldPresencePredicate(PropertyDiscoveryMode propertyDiscoveryMode) {
        switch (propertyDiscoveryMode) {
            case GETTER: {
                return hasGetter;
            }
            case GETTER_WITH_FIELD: {
                return hasGetter.and(hasField);
            }
        }
        throw new MappingException("Not supported propertyDiscoveryMode: " + (Object)((Object)propertyDiscoveryMode));
    }

    private void addProperties(JSONObject result, Set<PropertyDescription> properties, MapperContext mapperContext) {
        Set<PropertySerializer> serializers = properties.stream().map(p -> PropertySerializerFactory.get(p, mapperContext)).collect(Collectors.toSet());
        if (properties.size() != 0) {
            JSONObject objectProperties = new JSONObject();
            serializers.stream().forEach(serializer -> objectProperties.put(serializer.getPropertyName(), (Object)serializer.toJsonObject()));
            result.put("properties", (Object)objectProperties);
        }
        this.addRequiredPropertiesList(result, serializers);
    }

    private void addRequiredPropertiesList(JSONObject result, Set<PropertySerializer> serializers) {
        Set required = serializers.stream().filter(PropertySerializer::isPropertyRequired).collect(Collectors.toSet());
        if (required.size() != 0) {
            JSONArray requiredNames = new JSONArray();
            required.stream().map(PropertySerializer::getPropertyName).forEach(arg_0 -> ((JSONArray)requiredNames).put(arg_0));
            result.put("required", (Object)requiredNames);
        }
    }
}

