/*
 * Decompiled with CFR 0.152.
 */
package pl.zientarski.typehandler;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.json.JSONArray;
import org.json.JSONObject;
import pl.zientarski.MapperContext;
import pl.zientarski.TypeDescription;
import pl.zientarski.Utils;
import pl.zientarski.typehandler.TypeHandler;

public class EnumTypeHandler
implements TypeHandler {
    @Override
    public boolean accepts(Type type) {
        return !(type instanceof ParameterizedType) && Utils.isEnumType((Class)type);
    }

    @Override
    public JSONObject process(TypeDescription typeDescription, MapperContext mapperContext) {
        Class clazz = (Class)typeDescription.getType();
        JSONArray values = new JSONArray();
        Arrays.asList(clazz.getEnumConstants()).stream().forEach(value -> values.put((Object)value.toString()));
        JSONObject result = new JSONObject();
        result.put("enum", (Object)values);
        result.put("$schema", (Object)"http://json-schema.org/draft-04/schema#");
        return result;
    }
}

