/*
 * Decompiled with CFR 0.152.
 */
package pl.zientarski.typehandler;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.json.JSONObject;
import pl.zientarski.MapperContext;
import pl.zientarski.TypeDescription;
import pl.zientarski.Utils;
import pl.zientarski.typehandler.TypeHandler;

public class PrimitiveTypeHandler
implements TypeHandler {
    @Override
    public boolean accepts(Type type) {
        return !(type instanceof ParameterizedType) && Utils.isPrimitiveType((Class)type);
    }

    @Override
    public JSONObject process(TypeDescription typeDescription, MapperContext mapperContext) {
        Class clazz = (Class)typeDescription.getType();
        return this.primitiveTypeSchema(clazz);
    }

    protected JSONObject primitiveTypeSchema(Class<?> clazz) {
        JSONObject result = new JSONObject();
        result.put("$schema", (Object)"http://json-schema.org/draft-04/schema#");
        if (clazz.equals(Boolean.TYPE)) {
            result.put("type", (Object)"boolean");
        }
        if (clazz.equals(Character.TYPE)) {
            result.put("type", (Object)"string");
            result.put("minLength", 1);
            result.put("maxLength", 1);
        }
        if (clazz.equals(Byte.TYPE)) {
            result.put("type", (Object)"integer");
            result.put("minimum", -128);
            result.put("maximum", 127);
        }
        if (clazz.equals(Short.TYPE)) {
            result.put("type", (Object)"integer");
            result.put("minimum", Short.MIN_VALUE);
            result.put("maximum", Short.MAX_VALUE);
        }
        if (clazz.equals(Integer.TYPE)) {
            result.put("type", (Object)"integer");
            result.put("minimum", Integer.MIN_VALUE);
            result.put("maximum", Integer.MAX_VALUE);
        }
        if (clazz.equals(Long.TYPE)) {
            result.put("type", (Object)"integer");
            result.put("minimum", Long.MIN_VALUE);
            result.put("maximum", Long.MAX_VALUE);
        }
        if (clazz.equals(Float.TYPE)) {
            result.put("type", (Object)"number");
            result.put("minimum", (double)1.4E-45f);
            result.put("maximum", 3.4028234663852886E38);
        }
        if (clazz.equals(Double.TYPE)) {
            result.put("type", (Object)"number");
            result.put("minimum", Double.MIN_VALUE);
            result.put("maximum", Double.MAX_VALUE);
        }
        return result;
    }
}

