/*
 * Decompiled with CFR 0.152.
 */
package pl.zientarski.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class ParameterizedTypeReference<T> {
    private final ParameterizedType type;

    protected ParameterizedTypeReference() {
        Class<?> parameterizedTypeReferenceSubClass = ParameterizedTypeReference.findParameterizedTypeReferenceSubClass(this.getClass());
        Type type = parameterizedTypeReferenceSubClass.getGenericSuperclass();
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type parameterType = parameterizedType.getActualTypeArguments()[0];
        if (!(parameterType instanceof ParameterizedType)) {
            throw new IllegalArgumentException("Given type is not generic");
        }
        this.type = (ParameterizedType)parameterType;
    }

    private static Class<?> findParameterizedTypeReferenceSubClass(Class<?> child) {
        Class<?> parent = child.getSuperclass();
        if (Object.class.equals(parent)) {
            throw new IllegalStateException("Expected ParameterizedTypeReference superclass");
        }
        if (ParameterizedTypeReference.class.equals(parent)) {
            return child;
        }
        return ParameterizedTypeReference.findParameterizedTypeReferenceSubClass(parent);
    }

    public ParameterizedType getType() {
        return this.type;
    }
}

