/*
 * Decompiled with CFR 0.152.
 */
package com.github.tototoshi.csv;

import com.github.tototoshi.csv.CSVFormat;
import com.github.tototoshi.csv.CSVWriter$;
import com.github.tototoshi.csv.QUOTE_ALL$;
import com.github.tototoshi.csv.QUOTE_MINIMAL$;
import com.github.tototoshi.csv.QUOTE_NONE$;
import com.github.tototoshi.csv.QUOTE_NONNUMERIC$;
import com.github.tototoshi.csv.Quoting;
import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005]e\u0001B\u0001\u0003\u0001-\u0011\u0011bQ*W/JLG/\u001a:\u000b\u0005\r!\u0011aA2tm*\u0011QAB\u0001\ni>$x\u000e^8tQ&T!a\u0002\u0005\u0002\r\u001dLG\u000f[;c\u0015\u0005I\u0011aA2p[\u000e\u00011\u0003\u0002\u0001\r)i\u0001\"!\u0004\n\u000e\u00039Q!a\u0004\t\u0002\t1\fgn\u001a\u0006\u0002#\u0005!!.\u0019<b\u0013\t\u0019bB\u0001\u0004PE*,7\r\u001e\t\u0003+ai\u0011A\u0006\u0006\u0003/A\t!![8\n\u0005e1\"!C\"m_N,\u0017M\u00197f!\t)2$\u0003\u0002\u001d-\tIa\t\\;tQ\u0006\u0014G.\u001a\u0005\t=\u0001\u0011)\u0019!C\t?\u00051qO]5uKJ,\u0012\u0001\t\t\u0003+\u0005J!A\t\f\u0003\r]\u0013\u0018\u000e^3s\u0011!!\u0003A!A!\u0002\u0013\u0001\u0013aB<sSR,'\u000f\t\u0005\tM\u0001\u0011)\u0019!C\u0002O\u00051am\u001c:nCR,\u0012\u0001\u000b\t\u0003S)j\u0011AA\u0005\u0003W\t\u0011\u0011bQ*W\r>\u0014X.\u0019;\t\u00115\u0002!\u0011!Q\u0001\n!\nqAZ8s[\u0006$\b\u0005C\u00030\u0001\u0011\u0005\u0001'\u0001\u0004=S:LGO\u0010\u000b\u0003cQ\"\"AM\u001a\u0011\u0005%\u0002\u0001\"\u0002\u0014/\u0001\bA\u0003\"\u0002\u0010/\u0001\u0004\u0001\u0003B\u0002\u001c\u0001A\u0003%q'A\u0006qe&tGo\u0016:ji\u0016\u0014\bCA\u000b9\u0013\tIdCA\u0006Qe&tGo\u0016:ji\u0016\u0014\bBB\u001e\u0001A\u0003%A(A\trk>$X-T5oS6\fGn\u00159fGN\u00042!\u0010!C\u001b\u0005q$\"A \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005s$!B!se\u0006L\bCA\u001fD\u0013\t!eH\u0001\u0003DQ\u0006\u0014\b\"\u0002$\u0001\t\u00039\u0015!B2m_N,G#\u0001%\u0011\u0005uJ\u0015B\u0001&?\u0005\u0011)f.\u001b;\t\u000b1\u0003A\u0011A$\u0002\u000b\u0019dWo\u001d5\t\u000b9\u0003A\u0011A(\u0002\u0011]\u0014\u0018\u000e^3BY2$\"\u0001\u0013)\t\u000bEk\u0005\u0019\u0001*\u0002\u0011\u0005dG\u000eT5oKN\u00042aU._\u001d\t!\u0016L\u0004\u0002V16\taK\u0003\u0002X\u0015\u00051AH]8pizJ\u0011aP\u0005\u00035z\nq\u0001]1dW\u0006<W-\u0003\u0002];\n\u00191+Z9\u000b\u0005is\u0004cA*\\?B\u0011Q\bY\u0005\u0003Cz\u00121!\u00118z\u0011\u0015\u0019\u0007\u0001\"\u0003e\u0003%9(/\u001b;f\u001d\u0016DH\u000f\u0006\u0002IK\")aM\u0019a\u0001=\u00061a-[3mINDQ\u0001\u001b\u0001\u0005\u0002%\f\u0001b\u001e:ji\u0016\u0014vn\u001e\u000b\u0003\u0011*DQAZ4A\u0002y;Q\u0001\u001c\u0002\t\u00025\f\u0011bQ*W/JLG/\u001a:\u0011\u0005%rg!B\u0001\u0003\u0011\u0003y7C\u00018q!\ti\u0014/\u0003\u0002s}\t1\u0011I\\=SK\u001aDQa\f8\u0005\u0002Q$\u0012!\u001c\u0005\u0006m:$\ta^\u0001\u0005_B,g\u000e\u0006\u0002yuR\u0011!'\u001f\u0005\u0006MU\u0004\u001d\u0001\u000b\u0005\u0006wV\u0004\r\u0001`\u0001\u0005M&dW\r\u0005\u0002\u0016{&\u0011aP\u0006\u0002\u0005\r&dW\r\u0003\u0004w]\u0012\u0005\u0011\u0011\u0001\u000b\u0007\u0003\u0007\t9!!\u0003\u0015\u0007I\n)\u0001C\u0003'\u007f\u0002\u000f\u0001\u0006C\u0003|\u007f\u0002\u0007A\u0010C\u0004\u0002\f}\u0004\r!!\u0004\u0002\u0011\u0015t7m\u001c3j]\u001e\u0004B!a\u0004\u0002\u00189!\u0011\u0011CA\n!\t)f(C\u0002\u0002\u0016y\na\u0001\u0015:fI\u00164\u0017\u0002BA\r\u00037\u0011aa\u0015;sS:<'bAA\u000b}!1aO\u001cC\u0001\u0003?!b!!\t\u0002&\u0005\u001dBc\u0001\u001a\u0002$!1a%!\bA\u0004!Baa_A\u000f\u0001\u0004a\b\u0002CA\u0015\u0003;\u0001\r!a\u000b\u0002\r\u0005\u0004\b/\u001a8e!\ri\u0014QF\u0005\u0004\u0003_q$a\u0002\"p_2,\u0017M\u001c\u0005\u0007m:$\t!a\r\u0015\t\u0005U\u0012\u0011\b\u000b\u0004e\u0005]\u0002B\u0002\u0014\u00022\u0001\u000f\u0001\u0006\u0003\u0005\u0002<\u0005E\u0002\u0019AA\u001f\u0003\r1wn\u001d\t\u0004+\u0005}\u0012bAA!-\taq*\u001e;qkR\u001cFO]3b[\"1aO\u001cC\u0001\u0003\u000b\"B!a\u0012\u0002LQ\u0019!'!\u0013\t\r\u0019\n\u0019\u0005q\u0001)\u0011\u001dY\u00181\ta\u0001\u0003\u001bAaA\u001e8\u0005\u0002\u0005=CCBA)\u0003+\n9\u0006F\u00023\u0003'BaAJA'\u0001\bA\u0003bB>\u0002N\u0001\u0007\u0011Q\u0002\u0005\t\u0003\u0017\ti\u00051\u0001\u0002\u000e!1aO\u001cC\u0001\u00037\"b!!\u0018\u0002b\u0005\rDc\u0001\u001a\u0002`!1a%!\u0017A\u0004!Bqa_A-\u0001\u0004\ti\u0001\u0003\u0005\u0002*\u0005e\u0003\u0019AA\u0016\u0011\u00191h\u000e\"\u0001\u0002hQA\u0011\u0011NA7\u0003_\n\t\bF\u00023\u0003WBaAJA3\u0001\bA\u0003bB>\u0002f\u0001\u0007\u0011Q\u0002\u0005\t\u0003S\t)\u00071\u0001\u0002,!A\u00111BA3\u0001\u0004\ti\u0001\u0003\u0004w]\u0012\u0005\u0011Q\u000f\u000b\t\u0003o\nY(! \u0002\u0000Q\u0019!'!\u001f\t\r\u0019\n\u0019\bq\u0001)\u0011\u0019Y\u00181\u000fa\u0001y\"A\u0011\u0011FA:\u0001\u0004\tY\u0003\u0003\u0005\u0002\f\u0005M\u0004\u0019AA\u0007\u0011\u00191h\u000e\"\u0001\u0002\u0004R1\u0011QQAE\u0003\u0017#2AMAD\u0011\u00191\u0013\u0011\u0011a\u0002Q!A\u00111HAA\u0001\u0004\ti\u0004\u0003\u0005\u0002\f\u0005\u0005\u0005\u0019AA\u0007\u0011\u00191h\u000e\"\u0001\u0002\u0010R!\u0011\u0011SAK)\r\u0011\u00141\u0013\u0005\u0007M\u00055\u00059\u0001\u0015\t\ry\ti\t1\u0001!\u0001")
public class CSVWriter
implements Closeable,
Flushable {
    private final Writer writer;
    private final CSVFormat format;
    private final PrintWriter printWriter;
    private final char[] quoteMinimalSpecs;

    public static CSVWriter open(Writer writer, CSVFormat cSVFormat) {
        return CSVWriter$.MODULE$.open(writer, cSVFormat);
    }

    public static CSVWriter open(OutputStream outputStream, String string, CSVFormat cSVFormat) {
        return CSVWriter$.MODULE$.open(outputStream, string, cSVFormat);
    }

    public static CSVWriter open(File file, boolean bl, String string, CSVFormat cSVFormat) {
        return CSVWriter$.MODULE$.open(file, bl, string, cSVFormat);
    }

    public static CSVWriter open(String string, boolean bl, String string2, CSVFormat cSVFormat) {
        return CSVWriter$.MODULE$.open(string, bl, string2, cSVFormat);
    }

    public static CSVWriter open(String string, boolean bl, CSVFormat cSVFormat) {
        return CSVWriter$.MODULE$.open(string, bl, cSVFormat);
    }

    public static CSVWriter open(String string, String string2, CSVFormat cSVFormat) {
        return CSVWriter$.MODULE$.open(string, string2, cSVFormat);
    }

    public static CSVWriter open(String string, CSVFormat cSVFormat) {
        return CSVWriter$.MODULE$.open(string, cSVFormat);
    }

    public static CSVWriter open(OutputStream outputStream, CSVFormat cSVFormat) {
        return CSVWriter$.MODULE$.open(outputStream, cSVFormat);
    }

    public static CSVWriter open(File file, boolean bl, CSVFormat cSVFormat) {
        return CSVWriter$.MODULE$.open(file, bl, cSVFormat);
    }

    public static CSVWriter open(File file, String string, CSVFormat cSVFormat) {
        return CSVWriter$.MODULE$.open(file, string, cSVFormat);
    }

    public static CSVWriter open(File file, CSVFormat cSVFormat) {
        return CSVWriter$.MODULE$.open(file, cSVFormat);
    }

    public Writer writer() {
        return this.writer;
    }

    public CSVFormat format() {
        return this.format;
    }

    @Override
    public void close() {
        this.printWriter.close();
    }

    @Override
    public void flush() {
        this.printWriter.flush();
    }

    public void writeAll(Seq<Seq<Object>> allLines) {
        allLines.foreach((Function1 & Serializable & scala.Serializable)line -> {
            this.writeNext((Seq<Object>)line);
            return BoxedUnit.UNIT;
        });
        if (this.printWriter.checkError()) {
            throw new IOException("Failed to write");
        }
    }

    private void writeNext(Seq<Object> fields) {
        Iterator iterator = fields.iterator();
        boolean hasNext = iterator.hasNext();
        while (hasNext) {
            Object next = iterator.next();
            if (next != null) {
                this.printField$1(next.toString());
            }
            if (!(hasNext = iterator.hasNext())) continue;
            this.printWriter.print(this.format().delimiter());
        }
        this.printWriter.print(this.format().lineTerminator());
    }

    public void writeRow(Seq<Object> fields) {
        this.writeNext(fields);
        if (this.printWriter.checkError()) {
            throw new IOException("Failed to write");
        }
    }

    private final boolean shouldQuote$1(String field, Quoting quoting) {
        boolean bl;
        Quoting quoting2 = quoting;
        if (QUOTE_ALL$.MODULE$.equals(quoting2)) {
            bl = true;
        } else if (QUOTE_MINIMAL$.MODULE$.equals(quoting2)) {
            for (int i = 0; i < field.length(); ++i) {
                char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(field), i);
                for (int j = 0; j < this.quoteMinimalSpecs.length; ++j) {
                    char quoteSpec = this.quoteMinimalSpecs[j];
                    if (quoteSpec != c) continue;
                    return true;
                }
            }
            bl = false;
        } else if (QUOTE_NONE$.MODULE$.equals(quoting2)) {
            bl = false;
        } else if (QUOTE_NONNUMERIC$.MODULE$.equals(quoting2)) {
            boolean foundDot = false;
            for (int i = 0; i < field.length(); ++i) {
                char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(field), i);
                if (c == '.') {
                    if (foundDot) {
                        return true;
                    }
                    foundDot = true;
                    continue;
                }
                if (c >= '0' && c <= '9') continue;
                return true;
            }
            bl = false;
        } else {
            throw new MatchError((Object)quoting2);
        }
        return bl;
    }

    private final void printField$1(String field) {
        block6: {
            block3: {
                if (!this.shouldQuote$1(field, this.format().quoting())) break block3;
                this.printWriter.print(this.format().quoteChar());
                for (int i = 0; i < field.length(); ++i) {
                    char c;
                    block5: {
                        block4: {
                            c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(field), i);
                            if (c == this.format().quoteChar()) break block4;
                            Quoting quoting = this.format().quoting();
                            QUOTE_NONE$ qUOTE_NONE$ = QUOTE_NONE$.MODULE$;
                            if ((quoting != null ? !quoting.equals(qUOTE_NONE$) : qUOTE_NONE$ != null) || c != this.format().delimiter()) break block5;
                        }
                        this.printWriter.print(this.format().quoteChar());
                    }
                    this.printWriter.print(c);
                }
                this.printWriter.print(this.format().quoteChar());
                break block6;
            }
            this.printWriter.print(field);
        }
    }

    public CSVWriter(Writer writer, CSVFormat format) {
        this.writer = writer;
        this.format = format;
        this.printWriter = new PrintWriter(writer);
        this.quoteMinimalSpecs = new char[]{'\r', '\n', format.quoteChar(), format.delimiter()};
    }
}

