/*
 * Decompiled with CFR 0.152.
 */
package com.github.tototoshi.csv;

import com.github.tototoshi.csv.MalformedCSVException;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

public final class CSVParser$
implements Serializable {
    public static CSVParser$ MODULE$;

    static {
        new CSVParser$();
    }

    private final int Start() {
        return 0;
    }

    private final int Field() {
        return 1;
    }

    private final int Delimiter() {
        return 2;
    }

    private final int End() {
        return 3;
    }

    private final int QuoteStart() {
        return 4;
    }

    private final int QuoteEnd() {
        return 5;
    }

    private final int QuotedField() {
        return 6;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<List<String>> parse(String input, char escapeChar, char delimiter, char quoteChar) {
        char[] buf = input.toCharArray();
        Vector fields = (Vector)scala.package$.MODULE$.Vector().apply((Seq)Nil$.MODULE$);
        StringBuilder field = new StringBuilder();
        int state = 0;
        int pos = 0;
        int buflen = buf.length;
        if (buf.length > 0 && buf[0] == '\ufeff') {
            ++pos;
        }
        while (state != 3 && pos < buflen) {
            char c = buf[pos];
            int n = state;
            switch (n) {
                case 0: {
                    BoxedUnit boxedUnit;
                    char c2 = c;
                    if (quoteChar == c2) {
                        state = 4;
                        ++pos;
                        boxedUnit = BoxedUnit.UNIT;
                        break;
                    }
                    if (delimiter == c2) {
                        fields = (Vector)fields.$colon$plus((Object)field.toString(), Vector$.MODULE$.canBuildFrom());
                        field = new StringBuilder();
                        state = 2;
                        ++pos;
                        boxedUnit = BoxedUnit.UNIT;
                        break;
                    }
                    boolean bl = '\n' == c2 ? true : ('\u2028' == c2 ? true : ('\u2029' == c2 ? true : '\u0085' == c2));
                    if (bl) {
                        fields = (Vector)fields.$colon$plus((Object)field.toString(), Vector$.MODULE$.canBuildFrom());
                        field = new StringBuilder();
                        state = 3;
                        ++pos;
                        boxedUnit = BoxedUnit.UNIT;
                        break;
                    }
                    if ('\r' == c2) {
                        if (pos + 1 < buflen && buf[1] == '\n') {
                            ++pos;
                        }
                        fields = (Vector)fields.$colon$plus((Object)field.toString(), Vector$.MODULE$.canBuildFrom());
                        field = new StringBuilder();
                        state = 3;
                        ++pos;
                        boxedUnit = BoxedUnit.UNIT;
                        break;
                    }
                    field.$plus$eq(c2);
                    state = 1;
                    ++pos;
                    boxedUnit = BoxedUnit.UNIT;
                    break;
                }
                case 2: {
                    BoxedUnit boxedUnit;
                    char c3 = c;
                    if (quoteChar == c3) {
                        state = 4;
                        ++pos;
                        boxedUnit = BoxedUnit.UNIT;
                        break;
                    }
                    if (escapeChar == c3) {
                        if (pos + 1 >= buflen || buf[pos + 1] != escapeChar && buf[pos + 1] != delimiter) throw new MalformedCSVException(new ArrayOps.ofChar(Predef$.MODULE$.charArrayOps(buf)).mkString());
                        field.$plus$eq(buf[pos + 1]);
                        state = 1;
                        pos += 2;
                        boxedUnit = BoxedUnit.UNIT;
                        break;
                    }
                    if (delimiter == c3) {
                        fields = (Vector)fields.$colon$plus((Object)field.toString(), Vector$.MODULE$.canBuildFrom());
                        field = new StringBuilder();
                        state = 2;
                        ++pos;
                        boxedUnit = BoxedUnit.UNIT;
                        break;
                    }
                    boolean bl = '\n' == c3 ? true : ('\u2028' == c3 ? true : ('\u2029' == c3 ? true : '\u0085' == c3));
                    if (bl) {
                        fields = (Vector)fields.$colon$plus((Object)field.toString(), Vector$.MODULE$.canBuildFrom());
                        field = new StringBuilder();
                        state = 3;
                        ++pos;
                        boxedUnit = BoxedUnit.UNIT;
                        break;
                    }
                    if ('\r' == c3) {
                        if (pos + 1 < buflen && buf[1] == '\n') {
                            ++pos;
                        }
                        fields = (Vector)fields.$colon$plus((Object)field.toString(), Vector$.MODULE$.canBuildFrom());
                        field = new StringBuilder();
                        state = 3;
                        ++pos;
                        boxedUnit = BoxedUnit.UNIT;
                        break;
                    }
                    field.$plus$eq(c3);
                    state = 1;
                    ++pos;
                    boxedUnit = BoxedUnit.UNIT;
                    break;
                }
                case 1: {
                    BoxedUnit boxedUnit;
                    char c4 = c;
                    if (escapeChar == c4) {
                        BoxedUnit boxedUnit2;
                        if (pos + 1 < buflen) {
                            if (buf[pos + 1] != escapeChar && buf[pos + 1] != delimiter) throw new MalformedCSVException(new ArrayOps.ofChar(Predef$.MODULE$.charArrayOps(buf)).mkString());
                            field.$plus$eq(buf[pos + 1]);
                            state = 1;
                            pos += 2;
                            boxedUnit2 = BoxedUnit.UNIT;
                        } else {
                            state = 5;
                            ++pos;
                            boxedUnit2 = BoxedUnit.UNIT;
                        }
                        boxedUnit = boxedUnit2;
                        break;
                    }
                    if (delimiter == c4) {
                        fields = (Vector)fields.$colon$plus((Object)field.toString(), Vector$.MODULE$.canBuildFrom());
                        field = new StringBuilder();
                        state = 2;
                        ++pos;
                        boxedUnit = BoxedUnit.UNIT;
                        break;
                    }
                    boolean bl = '\n' == c4 ? true : ('\u2028' == c4 ? true : ('\u2029' == c4 ? true : '\u0085' == c4));
                    if (bl) {
                        fields = (Vector)fields.$colon$plus((Object)field.toString(), Vector$.MODULE$.canBuildFrom());
                        field = new StringBuilder();
                        state = 3;
                        ++pos;
                        boxedUnit = BoxedUnit.UNIT;
                        break;
                    }
                    if ('\r' == c4) {
                        if (pos + 1 < buflen && buf[1] == '\n') {
                            ++pos;
                        }
                        fields = (Vector)fields.$colon$plus((Object)field.toString(), Vector$.MODULE$.canBuildFrom());
                        field = new StringBuilder();
                        state = 3;
                        ++pos;
                        boxedUnit = BoxedUnit.UNIT;
                        break;
                    }
                    field.$plus$eq(c4);
                    state = 1;
                    ++pos;
                    boxedUnit = BoxedUnit.UNIT;
                    break;
                }
                case 4: {
                    BoxedUnit boxedUnit;
                    char c5 = c;
                    if (escapeChar == c5 && escapeChar != quoteChar) {
                        if (pos + 1 >= buflen) throw new MalformedCSVException(new ArrayOps.ofChar(Predef$.MODULE$.charArrayOps(buf)).mkString());
                        if (buf[pos + 1] != escapeChar && buf[pos + 1] != quoteChar) throw new MalformedCSVException(new ArrayOps.ofChar(Predef$.MODULE$.charArrayOps(buf)).mkString());
                        field.$plus$eq(buf[pos + 1]);
                        state = 6;
                        pos += 2;
                        boxedUnit = BoxedUnit.UNIT;
                        break;
                    }
                    if (quoteChar == c5) {
                        BoxedUnit boxedUnit3;
                        if (pos + 1 < buflen && buf[pos + 1] == quoteChar) {
                            field.$plus$eq(quoteChar);
                            state = 6;
                            pos += 2;
                            boxedUnit3 = BoxedUnit.UNIT;
                        } else {
                            state = 5;
                            ++pos;
                            boxedUnit3 = BoxedUnit.UNIT;
                        }
                        boxedUnit = boxedUnit3;
                        break;
                    }
                    field.$plus$eq(c5);
                    state = 6;
                    ++pos;
                    boxedUnit = BoxedUnit.UNIT;
                    break;
                }
                case 5: {
                    BoxedUnit boxedUnit;
                    char c6 = c;
                    if (delimiter == c6) {
                        fields = (Vector)fields.$colon$plus((Object)field.toString(), Vector$.MODULE$.canBuildFrom());
                        field = new StringBuilder();
                        state = 2;
                        ++pos;
                        boxedUnit = BoxedUnit.UNIT;
                        break;
                    }
                    boolean bl = '\n' == c6 ? true : ('\u2028' == c6 ? true : ('\u2029' == c6 ? true : '\u0085' == c6));
                    if (bl) {
                        fields = (Vector)fields.$colon$plus((Object)field.toString(), Vector$.MODULE$.canBuildFrom());
                        field = new StringBuilder();
                        state = 3;
                        ++pos;
                        boxedUnit = BoxedUnit.UNIT;
                        break;
                    }
                    if ('\r' != c6) throw new MalformedCSVException(new ArrayOps.ofChar(Predef$.MODULE$.charArrayOps(buf)).mkString());
                    if (pos + 1 < buflen && buf[1] == '\n') {
                        ++pos;
                    }
                    fields = (Vector)fields.$colon$plus((Object)field.toString(), Vector$.MODULE$.canBuildFrom());
                    field = new StringBuilder();
                    state = 3;
                    ++pos;
                    boxedUnit = BoxedUnit.UNIT;
                    break;
                }
                case 6: {
                    BoxedUnit boxedUnit;
                    char c7 = c;
                    if (escapeChar == c7 && escapeChar != quoteChar) {
                        BoxedUnit boxedUnit4;
                        if (pos + 1 >= buflen) throw new MalformedCSVException(new ArrayOps.ofChar(Predef$.MODULE$.charArrayOps(buf)).mkString());
                        if (buf[pos + 1] == escapeChar || buf[pos + 1] == quoteChar) {
                            field.$plus$eq(buf[pos + 1]);
                            state = 6;
                            pos += 2;
                            boxedUnit4 = BoxedUnit.UNIT;
                        } else {
                            field.$plus$eq(buf[pos]);
                            field.$plus$eq(buf[pos + 1]);
                            state = 6;
                            pos += 2;
                            boxedUnit4 = BoxedUnit.UNIT;
                        }
                        boxedUnit = boxedUnit4;
                        break;
                    }
                    if (quoteChar == c7) {
                        BoxedUnit boxedUnit5;
                        if (pos + 1 < buflen && buf[pos + 1] == quoteChar) {
                            field.$plus$eq(quoteChar);
                            state = 6;
                            pos += 2;
                            boxedUnit5 = BoxedUnit.UNIT;
                        } else {
                            state = 5;
                            ++pos;
                            boxedUnit5 = BoxedUnit.UNIT;
                        }
                        boxedUnit = boxedUnit5;
                        break;
                    }
                    field.$plus$eq(c7);
                    state = 6;
                    ++pos;
                    boxedUnit = BoxedUnit.UNIT;
                    break;
                }
                case 3: {
                    throw package$.MODULE$.error("unexpected error");
                }
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                }
            }
        }
        int n = state;
        switch (n) {
            case 2: {
                fields = (Vector)fields.$colon$plus((Object)"", Vector$.MODULE$.canBuildFrom());
                None$ none$ = new Some((Object)fields.toList());
                return none$;
            }
            case 6: {
                None$ none$ = None$.MODULE$;
                return none$;
            }
            default: {
                int n2 = state;
                switch (n2) {
                    case 1: 
                    case 5: {
                        fields = (Vector)fields.$colon$plus((Object)field.toString(), Vector$.MODULE$.canBuildFrom());
                        break;
                    }
                }
                None$ none$ = new Some((Object)fields.toList());
                return none$;
            }
        }
    }

    private Object readResolve() {
        return MODULE$;
    }

    private CSVParser$() {
        MODULE$ = this;
    }
}

