/*
 * Decompiled with CFR 0.152.
 */
package com.github.tototoshi.csv;

import com.github.tototoshi.csv.CSVFormat;
import com.github.tototoshi.csv.CSVReader;
import com.github.tototoshi.csv.ReaderLineReader;
import com.github.tototoshi.csv.SourceLineReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import scala.io.Source;
import scala.runtime.ModuleSerializationProxy;

public final class CSVReader$
implements Serializable {
    private static final String DEFAULT_ENCODING;
    public static final CSVReader$ MODULE$;

    private CSVReader$() {
    }

    static {
        MODULE$ = new CSVReader$();
        DEFAULT_ENCODING = "UTF-8";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CSVReader$.class);
    }

    public String DEFAULT_ENCODING() {
        return DEFAULT_ENCODING;
    }

    public CSVReader open(Source source, CSVFormat format) {
        return new CSVReader(new SourceLineReader(source), format);
    }

    public CSVReader open(Reader reader, CSVFormat format) {
        return new CSVReader(new ReaderLineReader(reader), format);
    }

    public CSVReader open(File file, CSVFormat format) {
        return this.open(file, this.DEFAULT_ENCODING(), format);
    }

    public CSVReader open(File file, String encoding, CSVFormat format) {
        CSVReader cSVReader;
        FileInputStream fin = new FileInputStream(file);
        try {
            cSVReader = this.open(new InputStreamReader((InputStream)fin, encoding), format);
        }
        catch (UnsupportedEncodingException e) {
            fin.close();
            throw e;
        }
        return cSVReader;
    }

    public CSVReader open(String filename, CSVFormat format) {
        return this.open(new File(filename), this.DEFAULT_ENCODING(), format);
    }

    public CSVReader open(String filename, String encoding, CSVFormat format) {
        return this.open(new File(filename), encoding, format);
    }
}

