/*
 * Decompiled with CFR 0.152.
 */
package com.github.tototoshi.csv;

import com.github.tototoshi.csv.CSVFormat;
import com.github.tototoshi.csv.CSVParser;
import com.github.tototoshi.csv.CSVReader$;
import com.github.tototoshi.csv.CSVReaderCompat;
import com.github.tototoshi.csv.LineReader;
import com.github.tototoshi.csv.MalformedCSVException;
import java.io.Closeable;
import java.io.File;
import java.io.Reader;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.NoSuchElementException;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Stream;
import scala.io.Source;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public class CSVReader
implements Closeable,
CSVReaderCompat {
    private final LineReader lineReader;
    private final CSVParser parser;

    public static String DEFAULT_ENCODING() {
        return CSVReader$.MODULE$.DEFAULT_ENCODING();
    }

    public static CSVReader open(File file, CSVFormat cSVFormat) {
        return CSVReader$.MODULE$.open(file, cSVFormat);
    }

    public static CSVReader open(File file, String string, CSVFormat cSVFormat) {
        return CSVReader$.MODULE$.open(file, string, cSVFormat);
    }

    public static CSVReader open(Reader reader, CSVFormat cSVFormat) {
        return CSVReader$.MODULE$.open(reader, cSVFormat);
    }

    public static CSVReader open(Source source, CSVFormat cSVFormat) {
        return CSVReader$.MODULE$.open(source, cSVFormat);
    }

    public static CSVReader open(String string, CSVFormat cSVFormat) {
        return CSVReader$.MODULE$.open(string, cSVFormat);
    }

    public static CSVReader open(String string, String string2, CSVFormat cSVFormat) {
        return CSVReader$.MODULE$.open(string, string2, cSVFormat);
    }

    public CSVReader(LineReader lineReader, CSVFormat format) {
        this.lineReader = lineReader;
        this.parser = new CSVParser(format);
    }

    private LineReader lineReader() {
        return this.lineReader;
    }

    public Option<List<String>> readNext() {
        return this.parseNext$1(this.lineReader(), CSVReader.parseNext$default$2$1());
    }

    public void foreach(Function1<Seq<String>, BoxedUnit> f) {
        this.iterator().foreach(f);
    }

    public Iterator<Seq<String>> iterator() {
        return new Iterator<Seq<String>>(this){
            private Option _next;
            private final /* synthetic */ CSVReader $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                Iterator.$init$((Iterator)this);
                this._next = None$.MODULE$;
            }

            public boolean hasNext() {
                Option option = this._next;
                if (option instanceof Some) {
                    return true;
                }
                if (None$.MODULE$.equals(option)) {
                    this._next = this.$outer.readNext();
                    return this._next.isDefined();
                }
                throw new MatchError((Object)option);
            }

            public Seq next() {
                Option option = this._next;
                if (option instanceof Some) {
                    Seq row;
                    Seq _row = row = (Seq)((Some)option).value();
                    this._next = None$.MODULE$;
                    return _row;
                }
                if (None$.MODULE$.equals(option)) {
                    return (Seq)this.$outer.readNext().getOrElse(CSVReader::com$github$tototoshi$csv$CSVReader$$anon$1$$_$next$$anonfun$1);
                }
                throw new MatchError((Object)option);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{com$github$tototoshi$csv$CSVReader$$anon$1$$_$next$$anonfun$1()}, serializedLambda);
            }
        };
    }

    public Iterator<Map<String, String>> iteratorWithHeaders() {
        Option<List<String>> headers2 = this.readNext();
        return (Iterator)headers2.map((Function1 & Serializable)headers -> this.iterator().map((Function1 & Serializable)line -> ((IterableOnceOps)headers.zip((IterableOnce)line)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()))).getOrElse(CSVReader::iteratorWithHeaders$$anonfun$2);
    }

    public Stream<Map<String, String>> toStreamWithHeaders() {
        return this.iteratorWithHeaders().toStream();
    }

    public Stream<List<String>> toStream() {
        return ((Stream)package$.MODULE$.Stream().continually(this::toStream$$anonfun$1).takeWhile((Function1 & Serializable)_$1 -> _$1.isDefined())).map((Function1 & Serializable)_$2 -> (List)_$2.get());
    }

    public List<List<String>> all() {
        return this.toStream().toList();
    }

    public List<Map<String, String>> allWithHeaders() {
        return (List)this.allWithOrderedHeaders()._2();
    }

    public Tuple2<List<String>, List<Map<String, String>>> allWithOrderedHeaders() {
        Option<List<String>> headers2 = this.readNext();
        Option data = headers2.map((Function1 & Serializable)headers -> {
            List<List<String>> lines = this.all();
            return lines.map((Function1 & Serializable)l -> ((IterableOnceOps)headers.zip((IterableOnce)l)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        });
        return Tuple2$.MODULE$.apply(headers2.getOrElse(CSVReader::allWithOrderedHeaders$$anonfun$1), data.getOrElse(CSVReader::allWithOrderedHeaders$$anonfun$2));
    }

    @Override
    public void close() {
        this.lineReader().close();
    }

    private static final String $anonfun$1() {
        return "";
    }

    private final Option parseNext$1(LineReader lineReader, Option leftOver) {
        Option<List<String>> option;
        while (true) {
            String nextLine;
            if ((nextLine = lineReader.readLineWithTerminator()) == null) {
                if (leftOver.isDefined()) {
                    throw new MalformedCSVException(new StringBuilder(18).append("Malformed Input!: ").append(leftOver).toString());
                }
                return None$.MODULE$;
            }
            String line = new StringBuilder(0).append((String)leftOver.getOrElse(CSVReader::$anonfun$1)).append(nextLine).toString();
            option = this.parser.parseLine(line);
            if (!None$.MODULE$.equals(option)) break;
            leftOver = Some$.MODULE$.apply((Object)line);
        }
        Option<List<String>> result = option;
        return result;
    }

    private static final Option parseNext$default$2$1() {
        return None$.MODULE$;
    }

    public static final List com$github$tototoshi$csv$CSVReader$$anon$1$$_$next$$anonfun$1() {
        throw new NoSuchElementException("next on empty iterator");
    }

    private static final Iterator iteratorWithHeaders$$anonfun$2() {
        return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
    }

    private final Option toStream$$anonfun$1() {
        return this.readNext();
    }

    private static final List allWithOrderedHeaders$$anonfun$1() {
        return package$.MODULE$.Nil();
    }

    private static final List allWithOrderedHeaders$$anonfun$2() {
        return package$.MODULE$.Nil();
    }
}

