/*
 * Decompiled with CFR 0.152.
 */
package com.github.tototoshi.csv;

import com.github.tototoshi.csv.CSVFormat;
import com.github.tototoshi.csv.CSVWriter$;
import com.github.tototoshi.csv.QUOTE_ALL$;
import com.github.tototoshi.csv.QUOTE_MINIMAL$;
import com.github.tototoshi.csv.QUOTE_NONE$;
import com.github.tototoshi.csv.QUOTE_NONNUMERIC$;
import com.github.tototoshi.csv.Quoting;
import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.function.JProcedure1;

public class CSVWriter
implements Closeable,
Flushable {
    private final Writer writer;
    private final CSVFormat format;
    private final PrintWriter printWriter;
    private final char[] quoteMinimalSpecs;

    public static CSVWriter open(File file, boolean bl, CSVFormat cSVFormat) {
        return CSVWriter$.MODULE$.open(file, bl, cSVFormat);
    }

    public static CSVWriter open(File file, boolean bl, String string, CSVFormat cSVFormat) {
        return CSVWriter$.MODULE$.open(file, bl, string, cSVFormat);
    }

    public static CSVWriter open(File file, CSVFormat cSVFormat) {
        return CSVWriter$.MODULE$.open(file, cSVFormat);
    }

    public static CSVWriter open(File file, String string, CSVFormat cSVFormat) {
        return CSVWriter$.MODULE$.open(file, string, cSVFormat);
    }

    public static CSVWriter open(OutputStream outputStream, CSVFormat cSVFormat) {
        return CSVWriter$.MODULE$.open(outputStream, cSVFormat);
    }

    public static CSVWriter open(OutputStream outputStream, String string, CSVFormat cSVFormat) {
        return CSVWriter$.MODULE$.open(outputStream, string, cSVFormat);
    }

    public static CSVWriter open(String string, boolean bl, CSVFormat cSVFormat) {
        return CSVWriter$.MODULE$.open(string, bl, cSVFormat);
    }

    public static CSVWriter open(String string, boolean bl, String string2, CSVFormat cSVFormat) {
        return CSVWriter$.MODULE$.open(string, bl, string2, cSVFormat);
    }

    public static CSVWriter open(String string, CSVFormat cSVFormat) {
        return CSVWriter$.MODULE$.open(string, cSVFormat);
    }

    public static CSVWriter open(String string, String string2, CSVFormat cSVFormat) {
        return CSVWriter$.MODULE$.open(string, string2, cSVFormat);
    }

    public static CSVWriter open(Writer writer, CSVFormat cSVFormat) {
        return CSVWriter$.MODULE$.open(writer, cSVFormat);
    }

    public CSVWriter(Writer writer, CSVFormat format) {
        this.writer = writer;
        this.format = format;
        this.printWriter = new PrintWriter(writer);
        this.quoteMinimalSpecs = new char[]{'\r', '\n', format.quoteChar(), format.delimiter()};
    }

    public Writer writer() {
        return this.writer;
    }

    public CSVFormat format() {
        return this.format;
    }

    @Override
    public void close() {
        this.printWriter.close();
    }

    @Override
    public void flush() {
        this.printWriter.flush();
    }

    public void writeAll(Seq<Seq<Object>> allLines) {
        allLines.foreach((Function1)(JProcedure1 & Serializable)line -> this.writeNext((Seq<Object>)line));
        if (this.printWriter.checkError()) {
            throw new IOException("Failed to write");
        }
    }

    private void writeNext(Seq<Object> fields) {
        Iterator iterator = fields.iterator();
        boolean hasNext = iterator.hasNext();
        while (hasNext) {
            Object next = iterator.next();
            if (next != null) {
                this.printField$1(next.toString());
            }
            if (!(hasNext = iterator.hasNext())) continue;
            this.printWriter.print(this.format().delimiter());
        }
        this.printWriter.print(this.format().lineTerminator());
    }

    public void writeRow(Seq<Object> fields) {
        this.writeNext(fields);
        if (this.printWriter.checkError()) {
            throw new IOException("Failed to write");
        }
    }

    private final boolean shouldQuote$1(String field, Quoting quoting) {
        Quoting quoting2 = quoting;
        if (QUOTE_ALL$.MODULE$.equals(quoting2)) {
            return true;
        }
        if (QUOTE_MINIMAL$.MODULE$.equals(quoting2)) {
            for (int i = 0; i < field.length(); ++i) {
                char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(field), i);
                for (int j = 0; j < this.quoteMinimalSpecs.length; ++j) {
                    char quoteSpec = this.quoteMinimalSpecs[j];
                    if (quoteSpec != c) continue;
                    return true;
                }
            }
            return false;
        }
        if (QUOTE_NONE$.MODULE$.equals(quoting2)) {
            return false;
        }
        if (QUOTE_NONNUMERIC$.MODULE$.equals(quoting2)) {
            boolean foundDot = false;
            for (int i = 0; i < field.length(); ++i) {
                char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(field), i);
                if (c == '.') {
                    if (foundDot) {
                        return true;
                    }
                    foundDot = true;
                    continue;
                }
                if (c >= '0' && c <= '9') continue;
                return true;
            }
            return false;
        }
        throw new MatchError((Object)quoting2);
    }

    private final void printField$1(String field) {
        block3: {
            if (!this.shouldQuote$1(field, this.format().quoting())) break block3;
            this.printWriter.print(this.format().quoteChar());
            for (int i = 0; i < field.length(); ++i) {
                char c;
                block5: {
                    block4: {
                        c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(field), i);
                        if (c == this.format().quoteChar()) break block4;
                        Quoting quoting = this.format().quoting();
                        QUOTE_NONE$ qUOTE_NONE$ = QUOTE_NONE$.MODULE$;
                        if ((quoting != null ? !quoting.equals(qUOTE_NONE$) : qUOTE_NONE$ != null) || c != this.format().delimiter()) break block5;
                    }
                    this.printWriter.print(this.format().escapeChar());
                }
                this.printWriter.print(c);
            }
            this.printWriter.print(this.format().quoteChar());
            return;
        }
        this.printWriter.print(field);
    }
}

