/*
 * Decompiled with CFR 0.152.
 */
package cl.transbank.webpay.transaccioncompleta.model;

import cl.transbank.webpay.transaccioncompleta.requests.TransactionCommitRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MallTransactionCommitDetails {
    private List<Detail> detailList = new ArrayList<Detail>();

    private MallTransactionCommitDetails() {
    }

    public static MallTransactionCommitDetails build() {
        return new MallTransactionCommitDetails();
    }

    public static MallTransactionCommitDetails build(String commerceCode, String buyOrder, long idQueryInstallments, byte deferredPeriodIndex, boolean gracePeriod) {
        return MallTransactionCommitDetails.build().add(commerceCode, buyOrder, idQueryInstallments, deferredPeriodIndex, gracePeriod);
    }

    public MallTransactionCommitDetails add(String commerceCode, String buyOrder, long idQueryInstallments, byte deferredPeriodIndex, boolean gracePeriod) {
        this.detailList.add(new Detail(commerceCode, buyOrder, idQueryInstallments, deferredPeriodIndex, gracePeriod));
        return this;
    }

    public boolean remove(String commerceCode, String buyOrder, long idQueryInstallments, byte deferredPeriodIndex, boolean gracePeriod) {
        return this.getDetails().remove(new Detail(commerceCode, buyOrder, idQueryInstallments, deferredPeriodIndex, gracePeriod));
    }

    public List<Detail> getDetails() {
        return Collections.unmodifiableList(this.detailList);
    }

    public class Detail
    extends TransactionCommitRequest {
        private String commerceCode;
        private String buyOrder;

        Detail(String commerceCode, String buyOrder, long idQueryInstallments, byte deferredPeriodIndex, boolean gracePeriod) {
            super(idQueryInstallments, deferredPeriodIndex, gracePeriod);
            this.commerceCode = commerceCode;
            this.buyOrder = buyOrder;
        }

        public String getCommerceCode() {
            return this.commerceCode;
        }

        public String getBuyOrder() {
            return this.buyOrder;
        }

        public void setCommerceCode(String commerceCode) {
            this.commerceCode = commerceCode;
        }

        public void setBuyOrder(String buyOrder) {
            this.buyOrder = buyOrder;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Detail)) {
                return false;
            }
            Detail other = (Detail)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$commerceCode = this.getCommerceCode();
            String other$commerceCode = other.getCommerceCode();
            if (this$commerceCode == null ? other$commerceCode != null : !this$commerceCode.equals(other$commerceCode)) {
                return false;
            }
            String this$buyOrder = this.getBuyOrder();
            String other$buyOrder = other.getBuyOrder();
            return !(this$buyOrder == null ? other$buyOrder != null : !this$buyOrder.equals(other$buyOrder));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof Detail;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $commerceCode = this.getCommerceCode();
            result = result * 59 + ($commerceCode == null ? 43 : $commerceCode.hashCode());
            String $buyOrder = this.getBuyOrder();
            result = result * 59 + ($buyOrder == null ? 43 : $buyOrder.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "MallTransactionCommitDetails.Detail(super=" + super.toString() + ", commerceCode=" + this.getCommerceCode() + ", buyOrder=" + this.getBuyOrder() + ")";
        }

        public Detail(String commerceCode, String buyOrder) {
            this.commerceCode = commerceCode;
            this.buyOrder = buyOrder;
        }
    }
}

