/*
 * Decompiled with CFR 0.152.
 */
package com.github.traviscrawford.spark.dynamodb;

import com.amazonaws.services.dynamodbv2.document.Item;
import com.amazonaws.services.dynamodbv2.document.ItemCollection;
import com.amazonaws.services.dynamodbv2.document.Page;
import com.amazonaws.services.dynamodbv2.document.ScanOutcome;
import com.amazonaws.services.dynamodbv2.document.Table;
import com.amazonaws.services.dynamodbv2.document.spec.ScanSpec;
import com.amazonaws.services.dynamodbv2.model.ConsumedCapacity;
import com.github.traviscrawford.spark.dynamodb.BaseScanner;
import com.github.traviscrawford.spark.dynamodb.BaseScanner$class;
import com.github.traviscrawford.spark.dynamodb.ScanConfig;
import com.github.traviscrawford.spark.dynamodb.ScanConfig$;
import com.google.common.util.concurrent.RateLimiter;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Range;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class DynamoScanner$
implements BaseScanner {
    public static final DynamoScanner$ MODULE$;
    private final Logger com$github$traviscrawford$spark$dynamodb$DynamoScanner$$log;
    private final Logger com$github$traviscrawford$spark$dynamodb$BaseScanner$$log;

    static {
        new DynamoScanner$();
    }

    @Override
    public Logger com$github$traviscrawford$spark$dynamodb$BaseScanner$$log() {
        return this.com$github$traviscrawford$spark$dynamodb$BaseScanner$$log;
    }

    @Override
    public void com$github$traviscrawford$spark$dynamodb$BaseScanner$_setter_$com$github$traviscrawford$spark$dynamodb$BaseScanner$$log_$eq(Logger x$1) {
        this.com$github$traviscrawford$spark$dynamodb$BaseScanner$$log = x$1;
    }

    @Override
    public Table getTable(String tableName, Option<String> maybeCredentials, Option<String> maybeRegion, Option<String> maybeEndpoint) {
        return BaseScanner$class.getTable(this, tableName, maybeCredentials, maybeRegion, maybeEndpoint);
    }

    @Override
    public Table getTable(ScanConfig config) {
        return BaseScanner$class.getTable(this, config);
    }

    @Override
    public ScanSpec getScanSpec(ScanConfig config) {
        return BaseScanner$class.getScanSpec(this, config);
    }

    public Logger com$github$traviscrawford$spark$dynamodb$DynamoScanner$$log() {
        return this.com$github$traviscrawford$spark$dynamodb$DynamoScanner$$log;
    }

    public RDD<String> apply(SparkContext sc, String table, int totalSegments, int pageSize, Option<String> maybeCredentials, Option<Object> maybeRateLimit, Option<String> maybeRegion, Option<String> maybeEndpoint) {
        Range segments = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), totalSegments);
        IndexedSeq scanConfigs = (IndexedSeq)segments.map((Function1)new Serializable(table, pageSize, maybeCredentials, maybeRateLimit, maybeRegion, maybeEndpoint, segments){
            public static final long serialVersionUID = 0L;
            private final String table$1;
            private final int pageSize$1;
            private final Option maybeCredentials$1;
            private final Option maybeRateLimit$1;
            private final Option maybeRegion$1;
            private final Option maybeEndpoint$1;
            private final Range segments$1;

            public final ScanConfig apply(int idx) {
                String x$4 = this.table$1;
                int x$5 = idx;
                int x$6 = this.segments$1.length();
                int x$7 = this.pageSize$1;
                Option x$8 = this.maybeRateLimit$1;
                Option x$9 = this.maybeCredentials$1;
                Option x$10 = this.maybeRegion$1;
                Option x$11 = this.maybeEndpoint$1;
                Option<StructType> x$12 = ScanConfig$.MODULE$.apply$default$5();
                Option<String[]> x$13 = ScanConfig$.MODULE$.apply$default$6();
                return new ScanConfig(x$4, x$5, x$6, x$7, x$12, x$13, (Option<Object>)x$8, (Option<String>)x$9, (Option<String>)x$10, (Option<String>)x$11);
            }
            {
                this.table$1 = table$1;
                this.pageSize$1 = pageSize$1;
                this.maybeCredentials$1 = maybeCredentials$1;
                this.maybeRateLimit$1 = maybeRateLimit$1;
                this.maybeRegion$1 = maybeRegion$1;
                this.maybeEndpoint$1 = maybeEndpoint$1;
                this.segments$1 = segments$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        return sc.parallelize((Seq)scanConfigs, scanConfigs.length(), ClassTag$.MODULE$.apply(ScanConfig.class)).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterator<String> apply(ScanConfig config) {
                return DynamoScanner$.MODULE$.com$github$traviscrawford$spark$dynamodb$DynamoScanner$$scan(config);
            }
        }, ClassTag$.MODULE$.apply(String.class));
    }

    public Option<String> apply$default$5() {
        return None$.MODULE$;
    }

    public Option<Object> apply$default$6() {
        return None$.MODULE$;
    }

    public Option<String> apply$default$7() {
        return None$.MODULE$;
    }

    public Option<String> apply$default$8() {
        return None$.MODULE$;
    }

    public Iterator<String> com$github$traviscrawford$spark$dynamodb$DynamoScanner$$scan(ScanConfig config) {
        Option maybeRateLimiter = config.maybeRateLimit().map((Function1)new Serializable(config){
            public static final long serialVersionUID = 0L;
            private final ScanConfig config$1;

            public final RateLimiter apply(int rateLimit) {
                DynamoScanner$.MODULE$.com$github$traviscrawford$spark$dynamodb$DynamoScanner$$log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Segment ", " using rate limit of ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.config$1.segment()), BoxesRunTime.boxToInteger((int)rateLimit)})));
                return RateLimiter.create((double)rateLimit);
            }
            {
                this.config$1 = config$1;
            }
        });
        Table table = this.getTable(config);
        ScanSpec scanSpec = this.getScanSpec(config);
        ItemCollection result = table.scan(scanSpec);
        return JavaConversions$.MODULE$.asScalaIterator((java.util.Iterator)result.pages().iterator()).flatMap((Function1)new Serializable(maybeRateLimiter){
            public static final long serialVersionUID = 0L;
            private final Option maybeRateLimiter$1;

            public final Iterator<String> apply(Page<Item, ScanOutcome> page) {
                this.maybeRateLimiter$1.foreach((Function1)new Serializable(this, page){
                    public static final long serialVersionUID = 0L;
                    private final Page page$1;

                    public final void apply(RateLimiter rateLimiter) {
                        Option maybeConsumedCapacityUnits = Option$.MODULE$.apply((Object)((ScanOutcome)this.page$1.getLowLevelResult()).getScanResult().getConsumedCapacity()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Double apply(ConsumedCapacity x$1) {
                                return x$1.getCapacityUnits();
                            }
                        }).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply(Double x$2) {
                                return (int)package$.MODULE$.ceil(Predef$.MODULE$.Double2double(x$2));
                            }
                        });
                        maybeConsumedCapacityUnits.foreach((Function1)new Serializable(this, rateLimiter){
                            public static final long serialVersionUID = 0L;
                            private final RateLimiter rateLimiter$1;

                            public final void apply(int consumedCapacityUnits) {
                                this.apply$mcVI$sp(consumedCapacityUnits);
                            }

                            public void apply$mcVI$sp(int consumedCapacityUnits) {
                                this.rateLimiter$1.acquire(consumedCapacityUnits);
                            }
                            {
                                this.rateLimiter$1 = rateLimiter$1;
                            }
                        });
                    }
                    {
                        this.page$1 = page$1;
                    }
                });
                return JavaConversions$.MODULE$.asScalaIterator(page.iterator()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Item x$3) {
                        return x$3.toJSON();
                    }
                });
            }
            {
                this.maybeRateLimiter$1 = maybeRateLimiter$1;
            }
        });
    }

    private DynamoScanner$() {
        MODULE$ = this;
        BaseScanner$class.$init$(this);
        this.com$github$traviscrawford$spark$dynamodb$DynamoScanner$$log = LoggerFactory.getLogger(this.getClass());
    }
}

