/*
 * Decompiled with CFR 0.152.
 */
package com.github.trickl.jackson.module.httpquery.ser;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.github.trickl.jackson.module.httpquery.ser.QuotelessStringGenerator;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;

public class HttpQueryCollectionSerializer
extends StdSerializer<Collection<?>> {
    private static final long serialVersionUID = 1L;
    private final BeanPropertyWriter prop;
    private final boolean encodeNames;
    private final boolean encodeValues;

    public HttpQueryCollectionSerializer(BeanPropertyWriter prop, boolean encodeNames, boolean encodeValues) {
        super(prop.getPropertyType());
        this.prop = prop;
        this.encodeNames = encodeNames;
        this.encodeValues = encodeValues;
    }

    public final void serialize(Collection<?> collection, JsonGenerator gen, SerializerProvider provider) throws IOException {
        boolean propertyWritten = false;
        try {
            for (Object value : collection) {
                if (propertyWritten) {
                    gen.writeRaw("&");
                }
                propertyWritten = this.serializeAsNameValue(value, this.prop, gen, provider);
            }
        }
        catch (Exception e) {
            this.wrapAndThrow(provider, e, "Collection", this.prop.getName());
        }
    }

    public boolean serializeAsNameValue(Object propValue, BeanPropertyWriter prop, JsonGenerator gen, SerializerProvider provider) throws Exception {
        JsonFactory jsonFactory = new JsonFactory();
        StringWriter valueWriter = new StringWriter();
        String propName = prop.getName();
        String name = this.encodeNames ? this.encode(propName) : propName;
        try (QuotelessStringGenerator valueGenerator = new QuotelessStringGenerator(jsonFactory.createGenerator((Writer)valueWriter));){
            if (propValue == null) {
                if (prop.willSuppressNulls()) {
                    boolean bl = false;
                    return bl;
                }
                if (!prop.hasNullSerializer()) {
                    gen.writeRaw(name);
                    boolean bl = true;
                    return bl;
                }
                provider.findNullValueSerializer((BeanProperty)prop).serialize(propValue, (JsonGenerator)valueGenerator, provider);
            } else {
                Class<?> cls = propValue.getClass();
                provider.findTypedValueSerializer(cls, true, (BeanProperty)prop).serialize(propValue, (JsonGenerator)valueGenerator, provider);
            }
        }
        String value = valueWriter.getBuffer().toString();
        gen.writeRaw(name);
        gen.writeRaw("=");
        gen.writeRaw(this.encodeValues ? this.encode(value) : value);
        return true;
    }

    private String encode(String value) throws UnsupportedEncodingException {
        return URLEncoder.encode(value, StandardCharsets.UTF_8.toString());
    }
}

