/*
 * Decompiled with CFR 0.152.
 */
package com.github.trickl.jackson.module.httpquery.ser;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.github.trickl.jackson.module.httpquery.ser.QuotelessStringGenerator;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;

public class HttpQueryDelimitedSerializer
extends StdSerializer<Collection<?>> {
    private static final long serialVersionUID = 1L;
    private final JavaType javaType;
    private final String delimiter;
    private final boolean encodeDelimiter;
    private final boolean encodeValues;

    public HttpQueryDelimitedSerializer(JavaType javaType, String delimiter, boolean encodeDelimiter, boolean encodeValues) {
        super(javaType.getRawClass());
        this.javaType = javaType;
        this.delimiter = delimiter;
        this.encodeDelimiter = encodeDelimiter;
        this.encodeValues = encodeValues;
    }

    public final void serialize(Collection<?> collection, JsonGenerator gen, SerializerProvider provider) throws IOException {
        StringBuilder builder = new StringBuilder();
        String encodedDelimiter = this.encodeDelimiter ? this.encode(this.delimiter) : this.delimiter;
        for (Object value : collection) {
            if (builder.length() > 0) {
                builder.append(encodedDelimiter);
            }
            builder.append(this.serialize(value, provider));
        }
        gen.writeRaw(builder.toString());
    }

    private String serialize(Object collectionValue, SerializerProvider provider) throws IOException {
        StringWriter valueWriter = new StringWriter();
        JsonFactory jsonFactory = new JsonFactory();
        try (QuotelessStringGenerator valueGenerator = new QuotelessStringGenerator(jsonFactory.createGenerator((Writer)valueWriter));){
            if (collectionValue == null) {
                provider.defaultSerializeNull((JsonGenerator)valueGenerator);
            } else {
                Class<?> cls = collectionValue.getClass();
                provider.findTypedValueSerializer(cls, true, null).serialize(collectionValue, (JsonGenerator)valueGenerator, provider);
            }
        }
        catch (IOException ex) {
            this.wrapAndThrow(provider, ex, this.javaType.getContentType().getTypeName(), this.javaType.getTypeName());
        }
        String value = valueWriter.getBuffer().toString();
        return this.encodeValues ? this.encode(value) : value;
    }

    private String encode(String value) throws UnsupportedEncodingException {
        return URLEncoder.encode(value, StandardCharsets.UTF_8.toString());
    }
}

