/*
 * Decompiled with CFR 0.152.
 */
package com.github.trickl.jackson.module.httpquery.ser;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializer;
import com.fasterxml.jackson.databind.ser.BeanSerializerFactory;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.github.trickl.jackson.module.httpquery.annotations.HttpQueryDelimited;
import com.github.trickl.jackson.module.httpquery.annotations.HttpQueryNoValue;
import com.github.trickl.jackson.module.httpquery.ser.HttpQueryCollectionSerializer;
import com.github.trickl.jackson.module.httpquery.ser.HttpQueryDelimitedSerializer;
import com.github.trickl.jackson.module.httpquery.ser.QuotelessStringGenerator;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class HttpQuerySerializer
extends StdSerializer<Object> {
    private static final long serialVersionUID = 1L;
    private final JavaType javaType;
    private final boolean includeQuestionMark;
    private final boolean encodeNames;
    private final boolean encodeValues;

    public HttpQuerySerializer(JavaType javaType, boolean includeQuestionMark, boolean encodeNames, boolean encodeValues) {
        super(Object.class);
        this.javaType = javaType;
        this.includeQuestionMark = includeQuestionMark;
        this.encodeNames = encodeNames;
        this.encodeValues = encodeValues;
    }

    public final void serialize(Object bean, JsonGenerator gen, SerializerProvider provider) throws IOException {
        BeanSerializer beanSerializer = this.getBeanSerializer(provider, this.javaType);
        ArrayList propList = new ArrayList();
        beanSerializer.properties().forEachRemaining(prop -> propList.add((BeanPropertyWriter)prop));
        BeanPropertyWriter[] props = propList.toArray(new BeanPropertyWriter[0]);
        ArrayList<String> nameValueParams = new ArrayList<String>();
        try {
            for (BeanPropertyWriter prop2 : props) {
                String nameValueParam;
                if (prop2 == null || (nameValueParam = this.writeNameValueAsString(bean, prop2, provider)) == null || nameValueParam.length() <= 0) continue;
                nameValueParams.add(nameValueParam);
            }
        }
        catch (Exception e) {
            int i;
            String name = i == props.length ? "[anySetter]" : props[i].getName();
            this.wrapAndThrow(provider, e, bean, name);
        }
        String query = nameValueParams.stream().collect(Collectors.joining("&"));
        if (this.includeQuestionMark) {
            query = "?" + query;
        }
        gen.writeString(query);
    }

    public String writeNameValueAsString(Object bean, BeanPropertyWriter prop, SerializerProvider provider) throws Exception {
        StringWriter writer = new StringWriter();
        this.writeNameValue(writer, bean, prop, provider);
        return writer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeNameValue(Writer nameValueWriter, Object bean, BeanPropertyWriter prop, SerializerProvider provider) throws Exception {
        JsonFactory jsonFactory = new JsonFactory();
        Object propValue = prop.get(bean);
        String propName = prop.getName();
        JavaType propType = prop.getType();
        String name = this.encodeNames ? this.encode(propName) : propName;
        StringWriter valueWriter = new StringWriter();
        try (JsonGenerator gen = jsonFactory.createGenerator(nameValueWriter);){
            try (QuotelessStringGenerator valueGenerator = new QuotelessStringGenerator(jsonFactory.createGenerator((Writer)valueWriter));){
                HttpQueryNoValue annotatedNoValue = (HttpQueryNoValue)prop.findAnnotation(HttpQueryNoValue.class);
                if (annotatedNoValue != null) {
                    if (propValue == null) return;
                    if (Boolean.FALSE.equals(propValue)) return;
                    gen.writeRaw(name);
                    return;
                }
                if (propValue == null) {
                    if (prop.willSuppressNulls()) {
                        return;
                    }
                    provider.findNullValueSerializer((BeanProperty)prop).serialize(propValue, (JsonGenerator)valueGenerator, provider);
                } else {
                    if (propType.isTypeOrSubTypeOf(Collection.class) || propType.isArrayType()) {
                        Collection<Object> collection = Collections.emptyList();
                        if (propType.isTypeOrSubTypeOf(Collection.class)) {
                            collection = (Collection)propValue;
                        } else {
                            AtomicInteger index = new AtomicInteger(0);
                            collection = Stream.generate(() -> Array.get(propValue, index.getAndIncrement())).limit(Array.getLength(propValue)).collect(Collectors.toList());
                        }
                        HttpQueryDelimited annotatedList = (HttpQueryDelimited)prop.findAnnotation(HttpQueryDelimited.class);
                        if (annotatedList != null && !collection.isEmpty()) {
                            HttpQueryDelimitedSerializer serializer = new HttpQueryDelimitedSerializer(propType, annotatedList.delimiter(), annotatedList.encodeDelimiter(), this.encodeValues);
                            gen.writeRaw(name);
                            gen.writeRaw("=");
                            serializer.serialize(collection, gen, provider);
                            return;
                        }
                        HttpQueryCollectionSerializer serializer = new HttpQueryCollectionSerializer(prop, this.encodeNames, this.encodeValues);
                        serializer.serialize(collection, gen, provider);
                        return;
                    }
                    Class<?> cls = propValue.getClass();
                    provider.findTypedValueSerializer(cls, true, (BeanProperty)prop).serialize(propValue, (JsonGenerator)valueGenerator, provider);
                }
            }
            String value = valueWriter.toString();
            gen.writeRaw(name);
            gen.writeRaw("=");
            gen.writeRaw(this.encodeValues ? this.encode(value) : value);
            return;
        }
    }

    private String encode(String value) throws UnsupportedEncodingException {
        return URLEncoder.encode(value, StandardCharsets.UTF_8.toString());
    }

    private BeanSerializer getBeanSerializer(SerializerProvider provider, JavaType javaType) throws JsonMappingException {
        SerializationConfig config = provider.getConfig();
        BeanDescription beanDesc = config.introspect(javaType);
        BeanSerializerFactory factory = BeanSerializerFactory.instance;
        BeanSerializer serializer = (BeanSerializer)factory.findBeanSerializer(provider, javaType, beanDesc);
        serializer.resolve(provider);
        return serializer;
    }
}

