/*
 * Decompiled with CFR 0.152.
 */
package com.github.triplet.gradle.androidpublisher.internal;

import com.github.triplet.gradle.androidpublisher.EditManager;
import com.github.triplet.gradle.androidpublisher.GppAppDetails;
import com.github.triplet.gradle.androidpublisher.GppImage;
import com.github.triplet.gradle.androidpublisher.GppListing;
import com.github.triplet.gradle.androidpublisher.PlayPublisher;
import com.github.triplet.gradle.androidpublisher.ReleaseNote;
import com.github.triplet.gradle.androidpublisher.ReleaseStatus;
import com.github.triplet.gradle.androidpublisher.ResolutionStrategy;
import com.github.triplet.gradle.androidpublisher.internal.AndroidPublisherKt;
import com.github.triplet.gradle.androidpublisher.internal.DefaultEditManager$WhenMappings;
import com.github.triplet.gradle.androidpublisher.internal.DefaultTrackManager;
import com.github.triplet.gradle.androidpublisher.internal.InternalPlayPublisher;
import com.github.triplet.gradle.androidpublisher.internal.TrackManager;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.services.androidpublisher.model.Apk;
import com.google.api.services.androidpublisher.model.AppDetails;
import com.google.api.services.androidpublisher.model.Bundle;
import com.google.api.services.androidpublisher.model.Image;
import com.google.api.services.androidpublisher.model.Listing;
import com.google.api.services.androidpublisher.model.LocalizedText;
import com.google.api.services.androidpublisher.model.Track;
import com.google.api.services.androidpublisher.model.TrackRelease;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0019\b\u0000\u0018\u0000 M2\u00020\u0001:\u0002MNB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\n\u0010\t\u001a\u0004\u0018\u00010\u0007H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000fH\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000fH\u0016J\"\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002Jm\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u00072\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010\u00072\u0016\u0010&\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010'2\b\u0010(\u001a\u0004\u0018\u00010)2\b\u0010*\u001a\u0004\u0018\u00010+2\u000e\u0010,\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u000fH\u0016\u00a2\u0006\u0002\u0010-J0\u0010.\u001a\u00020 2\b\u0010/\u001a\u0004\u0018\u00010\u00072\b\u00100\u001a\u0004\u0018\u00010\u00072\b\u00101\u001a\u0004\u0018\u00010\u00072\b\u00102\u001a\u0004\u0018\u00010\u0007H\u0016J{\u00103\u001a\u00020 2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u00072\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010\u00072\u0016\u0010&\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010'2\b\u0010(\u001a\u0004\u0018\u00010)2\b\u0010*\u001a\u0004\u0018\u00010+2\u000e\u0010,\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u000fH\u0016\u00a2\u0006\u0002\u00108J&\u00109\u001a\u00020 2\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00072\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u001e0\u000fH\u0016J8\u0010;\u001a\u00020 2\u0006\u0010\u0011\u001a\u00020\u00072\b\u0010<\u001a\u0004\u0018\u00010\u00072\b\u0010=\u001a\u0004\u0018\u00010\u00072\b\u0010>\u001a\u0004\u0018\u00010\u00072\b\u0010?\u001a\u0004\u0018\u00010\u0007H\u0016JG\u0010@\u001a\u0004\u0018\u00010\u000b2\u0006\u0010A\u001a\u00020\u001e2\b\u0010B\u001a\u0004\u0018\u00010\u001e2\b\u0010C\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010D\u001a\u0004\u0018\u00010+2\b\u0010E\u001a\u0004\u0018\u00010+H\u0016\u00a2\u0006\u0002\u0010FJ\u001f\u0010G\u001a\u0004\u0018\u00010\u000b2\u0006\u0010H\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016\u00a2\u0006\u0002\u0010IJ\u001a\u0010J\u001a\u00020 2\u0006\u0010K\u001a\u00020+2\b\u0010B\u001a\u0004\u0018\u00010\u001eH\u0002J\u001c\u0010L\u001a\u00020 *\u00020+2\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010K\u001a\u00020+H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lcom/github/triplet/gradle/androidpublisher/internal/DefaultEditManager;", "Lcom/github/triplet/gradle/androidpublisher/EditManager;", "publisher", "Lcom/github/triplet/gradle/androidpublisher/internal/InternalPlayPublisher;", "tracks", "Lcom/github/triplet/gradle/androidpublisher/internal/TrackManager;", "editId", "", "(Lcom/github/triplet/gradle/androidpublisher/internal/InternalPlayPublisher;Lcom/github/triplet/gradle/androidpublisher/internal/TrackManager;Ljava/lang/String;)V", "findLeastStableTrackName", "findMaxAppVersionCode", "", "getAppDetails", "Lcom/github/triplet/gradle/androidpublisher/GppAppDetails;", "getImages", "", "Lcom/github/triplet/gradle/androidpublisher/GppImage;", "locale", "type", "getListings", "Lcom/github/triplet/gradle/androidpublisher/GppListing;", "getReleaseNotes", "Lcom/github/triplet/gradle/androidpublisher/ReleaseNote;", "handleUploadFailures", "", "e", "Lcom/google/api/client/googleapis/json/GoogleJsonResponseException;", "strategy", "Lcom/github/triplet/gradle/androidpublisher/ResolutionStrategy;", "artifact", "Ljava/io/File;", "promoteRelease", "", "promoteTrackName", "fromTrackName", "releaseStatus", "Lcom/github/triplet/gradle/androidpublisher/ReleaseStatus;", "releaseName", "releaseNotes", "", "userFraction", "", "updatePriority", "", "retainableArtifacts", "(Ljava/lang/String;Ljava/lang/String;Lcom/github/triplet/gradle/androidpublisher/ReleaseStatus;Ljava/lang/String;Ljava/util/Map;Ljava/lang/Double;Ljava/lang/Integer;Ljava/util/List;)V", "publishAppDetails", "defaultLocale", "contactEmail", "contactPhone", "contactWebsite", "publishArtifacts", "versionCodes", "didPreviousBuildSkipCommit", "", "trackName", "(Ljava/util/List;ZLjava/lang/String;Lcom/github/triplet/gradle/androidpublisher/ReleaseStatus;Ljava/lang/String;Ljava/util/Map;Ljava/lang/Double;Ljava/lang/Integer;Ljava/util/List;)V", "publishImages", "images", "publishListing", "title", "shortDescription", "fullDescription", "video", "uploadApk", "apkFile", "mappingFile", "debugSymbolsFile", "mainObbRetainable", "patchObbRetainable", "(Ljava/io/File;Ljava/io/File;Ljava/io/File;Lcom/github/triplet/gradle/androidpublisher/ResolutionStrategy;Ljava/lang/Integer;Ljava/lang/Integer;)Ljava/lang/Long;", "uploadBundle", "bundleFile", "(Ljava/io/File;Lcom/github/triplet/gradle/androidpublisher/ResolutionStrategy;)Ljava/lang/Long;", "uploadMappingFile", "versionCode", "attachObb", "Companion", "Factory", "android-publisher"})
public final class DefaultEditManager
implements EditManager {
    private final InternalPlayPublisher publisher;
    private final TrackManager tracks;
    private final String editId;
    @NotNull
    public static final String HIGH_RES_IMAGE_REQUEST = "=h16383";
    @NotNull
    private static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public GppAppDetails getAppDetails() {
        AppDetails details = this.publisher.getAppDetails(this.editId);
        return new GppAppDetails(details.getDefaultLanguage(), details.getContactEmail(), details.getContactPhone(), details.getContactWebsite());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<GppListing> getListings() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.publisher.getListings(this.editId);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Listing listing = (Listing)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getLanguage();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.language");
            GppListing gppListing = new GppListing(string, it.getFullDescription(), it.getShortDescription(), it.getTitle(), it.getVideo());
            collection.add(gppListing);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<GppImage> getImages(@NotNull String locale, @NotNull String type) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)locale, (String)"locale");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Iterable $this$map$iv = this.publisher.getImages(this.editId, locale, type);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Image image = (Image)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getUrl() + HIGH_RES_IMAGE_REQUEST;
            String string2 = it.getSha256();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it.sha256");
            GppImage gppImage = new GppImage(string, string2);
            collection.add(gppImage);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long findMaxAppVersionCode() {
        void $this$flatMapTo$iv$iv;
        Track track = this.tracks.findHighestTrack();
        List list = track != null ? track.getReleases() : null;
        boolean bl = false;
        List list2 = list;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        Iterable $this$flatMap$iv = list2;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            TrackRelease it = (TrackRelease)element$iv$iv;
            boolean bl2 = false;
            TrackRelease trackRelease = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)trackRelease, (String)"it");
            List list3 = trackRelease.getVersionCodes();
            boolean bl3 = false;
            List list4 = list3;
            if (list4 == null) {
                list4 = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = list4;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Long l = (Long)CollectionsKt.max((Iterable)((List)destination$iv$iv));
        return l != null ? l : 1L;
    }

    @Override
    @Nullable
    public String findLeastStableTrackName() {
        Track track = this.tracks.findHighestTrack();
        return track != null ? track.getTrack() : null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ReleaseNote> getReleaseNotes() {
        void $this$mapTo$iv$iv;
        Map<String, List<LocalizedText>> $this$map$iv = this.tracks.getReleaseNotes();
        boolean $i$f$map = false;
        Map<String, List<LocalizedText>> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var6_6 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var6_6.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$mapTo$iv$iv2;
            void $dstr$track$notes;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            void var12_12 = $dstr$track$notes;
            boolean bl3 = false;
            String string = (String)var12_12.getKey();
            var12_12 = $dstr$track$notes;
            bl3 = false;
            List notes = (List)var12_12.getValue();
            Iterable $this$map$iv2 = notes;
            boolean $i$f$map2 = false;
            Iterable iterable = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void track;
                void it;
                LocalizedText localizedText = (LocalizedText)item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                boolean bl4 = false;
                String string2 = it.getLanguage();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it.language");
                String string3 = it.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"it.text");
                ReleaseNote releaseNote = new ReleaseNote((String)track, string2, string3);
                collection2.add(releaseNote);
            }
            List list = (List)destination$iv$iv2;
            collection.add(list);
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void publishAppDetails(@Nullable String defaultLocale, @Nullable String contactEmail, @Nullable String contactPhone, @Nullable String contactWebsite) {
        void $this$apply;
        AppDetails appDetails = new AppDetails();
        boolean bl = false;
        boolean bl2 = false;
        AppDetails appDetails2 = appDetails;
        String string = this.editId;
        InternalPlayPublisher internalPlayPublisher = this.publisher;
        boolean bl3 = false;
        $this$apply.setDefaultLanguage(defaultLocale);
        $this$apply.setContactEmail(contactEmail);
        $this$apply.setContactPhone(contactPhone);
        $this$apply.setContactWebsite(contactWebsite);
        Unit unit = Unit.INSTANCE;
        internalPlayPublisher.updateDetails(string, appDetails);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void publishListing(@NotNull String locale, @Nullable String title, @Nullable String shortDescription, @Nullable String fullDescription, @Nullable String video) {
        void $this$apply;
        Intrinsics.checkParameterIsNotNull((Object)locale, (String)"locale");
        Listing listing = new Listing();
        boolean bl = false;
        boolean bl2 = false;
        Listing listing2 = listing;
        String string = locale;
        String string2 = this.editId;
        InternalPlayPublisher internalPlayPublisher = this.publisher;
        boolean bl3 = false;
        $this$apply.setTitle(title);
        $this$apply.setShortDescription(shortDescription);
        $this$apply.setFullDescription(fullDescription);
        $this$apply.setVideo(video);
        Unit unit = Unit.INSTANCE;
        internalPlayPublisher.updateListing(string2, string, listing);
    }

    @Override
    public void publishImages(@NotNull String locale, @NotNull String type, @NotNull List<? extends File> images) {
        Intrinsics.checkParameterIsNotNull((Object)locale, (String)"locale");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull(images, (String)"images");
        this.publisher.deleteImages(this.editId, locale, type);
        for (File file : images) {
            String string = "Uploading " + locale + " listing graphic for type '" + type + "': " + file.getName();
            boolean bl = false;
            System.out.println((Object)string);
            this.publisher.uploadImage(this.editId, locale, type, file);
        }
    }

    @Override
    public void promoteRelease(@NotNull String promoteTrackName, @NotNull String fromTrackName, @Nullable ReleaseStatus releaseStatus, @Nullable String releaseName, @Nullable Map<String, String> releaseNotes, @Nullable Double userFraction, @Nullable Integer updatePriority, @Nullable List<Long> retainableArtifacts) {
        Intrinsics.checkParameterIsNotNull((Object)promoteTrackName, (String)"promoteTrackName");
        Intrinsics.checkParameterIsNotNull((Object)fromTrackName, (String)"fromTrackName");
        this.tracks.promote(new TrackManager.PromoteConfig(promoteTrackName, fromTrackName, new TrackManager.BaseConfig(releaseStatus, userFraction, updatePriority, releaseNotes, retainableArtifacts, releaseName)));
    }

    @Override
    @Nullable
    public Long uploadBundle(@NotNull File bundleFile, @NotNull ResolutionStrategy strategy) {
        Bundle bundle;
        Intrinsics.checkParameterIsNotNull((Object)bundleFile, (String)"bundleFile");
        Intrinsics.checkParameterIsNotNull((Object)((Object)strategy), (String)"strategy");
        try {
            bundle = this.publisher.uploadBundle(this.editId, bundleFile);
        }
        catch (GoogleJsonResponseException e) {
            this.handleUploadFailures(e, strategy, bundleFile);
            return null;
        }
        Bundle bundle2 = bundle;
        return (long)bundle2.getVersionCode();
    }

    @Override
    @Nullable
    public Long uploadApk(@NotNull File apkFile, @Nullable File mappingFile, @Nullable File debugSymbolsFile, @NotNull ResolutionStrategy strategy, @Nullable Integer mainObbRetainable, @Nullable Integer patchObbRetainable) {
        Apk apk;
        Intrinsics.checkParameterIsNotNull((Object)apkFile, (String)"apkFile");
        Intrinsics.checkParameterIsNotNull((Object)((Object)strategy), (String)"strategy");
        try {
            apk = this.publisher.uploadApk(this.editId, apkFile);
        }
        catch (GoogleJsonResponseException e) {
            this.handleUploadFailures(e, strategy, apkFile);
            return null;
        }
        Apk apk2 = apk;
        Integer n = mainObbRetainable;
        if (n != null) {
            int n2 = n;
            Integer n3 = apk2.getVersionCode();
            Intrinsics.checkExpressionValueIsNotNull((Object)n3, (String)"apk.versionCode");
            this.attachObb(n2, "main", n3);
        }
        Integer n4 = patchObbRetainable;
        if (n4 != null) {
            int n5 = n4;
            Integer n6 = apk2.getVersionCode();
            Intrinsics.checkExpressionValueIsNotNull((Object)n6, (String)"apk.versionCode");
            this.attachObb(n5, "patch", n6);
        }
        Integer n7 = apk2.getVersionCode();
        Intrinsics.checkExpressionValueIsNotNull((Object)n7, (String)"apk.versionCode");
        this.uploadMappingFile(n7, mappingFile);
        if (debugSymbolsFile != null) {
            Integer n8 = apk2.getVersionCode();
            Intrinsics.checkExpressionValueIsNotNull((Object)n8, (String)"apk.versionCode");
            this.publisher.uploadDeobfuscationFile(this.editId, debugSymbolsFile, n8, "nativeCode");
        }
        return (long)apk2.getVersionCode();
    }

    @Override
    public void publishArtifacts(@NotNull List<Long> versionCodes, boolean didPreviousBuildSkipCommit, @NotNull String trackName, @Nullable ReleaseStatus releaseStatus, @Nullable String releaseName, @Nullable Map<String, String> releaseNotes, @Nullable Double userFraction, @Nullable Integer updatePriority, @Nullable List<Long> retainableArtifacts) {
        Intrinsics.checkParameterIsNotNull(versionCodes, (String)"versionCodes");
        Intrinsics.checkParameterIsNotNull((Object)trackName, (String)"trackName");
        if (versionCodes.isEmpty()) {
            return;
        }
        this.tracks.update(new TrackManager.UpdateConfig(trackName, versionCodes, didPreviousBuildSkipCommit, new TrackManager.BaseConfig(releaseStatus, userFraction, updatePriority, releaseNotes, retainableArtifacts, releaseName)));
    }

    private final void uploadMappingFile(int versionCode, File mappingFile) {
        if (mappingFile != null && mappingFile.length() > 0L) {
            this.publisher.uploadDeobfuscationFile(this.editId, mappingFile, versionCode, "proguard");
        }
    }

    private final void attachObb(int $this$attachObb, String type, int versionCode) {
        String string = "Attaching " + type + " OBB (" + $this$attachObb + ") to APK " + versionCode;
        boolean bl = false;
        System.out.println((Object)string);
        this.publisher.attachObb(this.editId, type, versionCode, $this$attachObb);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Void handleUploadFailures(GoogleJsonResponseException e, ResolutionStrategy strategy, File artifact) {
        if (!(AndroidPublisherKt.has(e, "apkNotificationMessageKeyUpgradeVersionConflict") || AndroidPublisherKt.has(e, "apkUpgradeVersionConflict") || AndroidPublisherKt.has(e, "apkNoUpgradePath"))) {
            if (!AndroidPublisherKt.has(e, "forbidden")) throw (Throwable)e;
            String string = e.getMessage();
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                string2 = "";
            }
            if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)"version code", (boolean)false, (int)2, null)) throw (Throwable)e;
        }
        switch (DefaultEditManager$WhenMappings.$EnumSwitchMapping$0[strategy.ordinal()]) {
            case 1: {
                throw (Throwable)new IllegalStateException("Concurrent uploads for app " + this.publisher.getAppId() + " (version code " + "already used). Make sure to synchronously upload your APKs such " + "that they don't conflict. If this problem persists, delete your " + "drafts in the Play Console's artifact library.", e);
            }
            case 2: {
                throw (Throwable)new IllegalStateException("Version code is too low or has already been used for app " + this.publisher.getAppId() + '.', e);
            }
            case 3: {
                LoggerFactory.getLogger(EditManager.class).warn("Ignoring artifact (" + artifact + ')');
                return null;
            }
        }
        return null;
    }

    public DefaultEditManager(@NotNull InternalPlayPublisher publisher, @NotNull TrackManager tracks, @NotNull String editId) {
        Intrinsics.checkParameterIsNotNull((Object)publisher, (String)"publisher");
        Intrinsics.checkParameterIsNotNull((Object)tracks, (String)"tracks");
        Intrinsics.checkParameterIsNotNull((Object)editId, (String)"editId");
        this.publisher = publisher;
        this.tracks = tracks;
        this.editId = editId;
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/github/triplet/gradle/androidpublisher/internal/DefaultEditManager$Factory;", "Lcom/github/triplet/gradle/androidpublisher/EditManager$Factory;", "()V", "create", "Lcom/github/triplet/gradle/androidpublisher/internal/DefaultEditManager;", "publisher", "Lcom/github/triplet/gradle/androidpublisher/PlayPublisher;", "editId", "", "android-publisher"})
    public static final class Factory
    implements EditManager.Factory {
        @Override
        @NotNull
        public DefaultEditManager create(@NotNull PlayPublisher publisher, @NotNull String editId) {
            Intrinsics.checkParameterIsNotNull((Object)publisher, (String)"publisher");
            Intrinsics.checkParameterIsNotNull((Object)editId, (String)"editId");
            return new DefaultEditManager((InternalPlayPublisher)publisher, new DefaultTrackManager((InternalPlayPublisher)publisher, editId), editId);
        }
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/github/triplet/gradle/androidpublisher/internal/DefaultEditManager$Companion;", "", "()V", "HIGH_RES_IMAGE_REQUEST", "", "android-publisher"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

