/*
 * Decompiled with CFR 0.152.
 */
package com.github.triplet.gradle.androidpublisher.internal;

import com.github.triplet.gradle.androidpublisher.internal.AndroidPublisherAdapter;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.apache.v2.ApacheHttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.androidpublisher.AndroidPublisher;
import com.google.auth.http.HttpTransportFactory;
import com.google.auth.oauth2.GoogleCredentials;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.ProxyAuthenticationStrategy;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0002\u001a\b\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0015\u0010\u0007\u001a\u00020\b*\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0080\u0004\u00a8\u0006\f"}, d2={"buildTransport", "Lcom/google/api/client/http/HttpTransport;", "createHttpTransport", "createPublisher", "Lcom/google/api/services/androidpublisher/AndroidPublisher;", "credentials", "Ljava/io/InputStream;", "has", "", "Lcom/google/api/client/googleapis/json/GoogleJsonResponseException;", "error", "", "android-publisher"})
public final class AndroidPublisherKt {
    @NotNull
    public static final AndroidPublisher createPublisher(@NotNull InputStream credentials) {
        GoogleCredentials googleCredentials;
        Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
        HttpTransport transport = AndroidPublisherKt.buildTransport();
        try {
            googleCredentials = GoogleCredentials.fromStream((InputStream)credentials, (HttpTransportFactory)new HttpTransportFactory(transport){
                final /* synthetic */ HttpTransport $transport;

                public final HttpTransport create() {
                    return this.$transport;
                }
                {
                    this.$transport = httpTransport;
                }
            });
        }
        catch (Exception e) {
            throw (Throwable)new Exception("Credential parsing may have failed. Ensure credential files supplied in the DSL contain valid JSON and/or the ANDROID_PUBLISHER_CREDENTIALS envvar contains valid JSON (not a file path).", e);
        }
        GoogleCredentials credential2 = googleCredentials.createScoped((Collection)CollectionsKt.listOf((Object)"https://www.googleapis.com/auth/androidpublisher"));
        JsonFactory jsonFactory = (JsonFactory)GsonFactory.getDefaultInstance();
        GoogleCredentials googleCredentials2 = credential2;
        Intrinsics.checkNotNullExpressionValue((Object)googleCredentials2, (String)"credential");
        AndroidPublisher androidPublisher = new AndroidPublisher.Builder(transport, jsonFactory, (HttpRequestInitializer)new AndroidPublisherAdapter(googleCredentials2)).setApplicationName("gradle-play-publisher").build();
        Intrinsics.checkNotNullExpressionValue((Object)androidPublisher, (String)"AndroidPublisher.Builder\u2026Name(PLUGIN_NAME).build()");
        return androidPublisher;
    }

    public static final boolean has(@NotNull GoogleJsonResponseException $this$has, @NotNull String error) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)((Object)$this$has), (String)"$this$has");
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            GoogleJsonError googleJsonError = $this$has.getDetails();
            List list = googleJsonError != null ? googleJsonError.getErrors() : null;
            List list2 = list;
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            Iterable $this$any$iv = list2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GoogleJsonError.ErrorInfo it = (GoogleJsonError.ErrorInfo)element$iv;
                    boolean bl2 = false;
                    GoogleJsonError.ErrorInfo errorInfo = it;
                    Intrinsics.checkNotNullExpressionValue((Object)errorInfo, (String)"it");
                    if (!Intrinsics.areEqual((Object)errorInfo.getReason(), (Object)error)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final HttpTransport buildTransport() {
        HttpTransport httpTransport;
        String trustStore = System.getProperty("javax.net.ssl.trustStore", null);
        String trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword", null);
        if (trustStore == null) {
            httpTransport = AndroidPublisherKt.createHttpTransport();
        } else {
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            Closeable closeable = new FileInputStream(trustStore);
            Throwable throwable = null;
            try {
                char[] cArray;
                FileInputStream fis = (FileInputStream)closeable;
                boolean bl = false;
                InputStream inputStream = fis;
                String string = trustStorePassword;
                if (string != null) {
                    String string2 = string;
                    char[] cArray2 = string2.toCharArray();
                    cArray = cArray2;
                    Intrinsics.checkNotNullExpressionValue((Object)cArray2, (String)"this as java.lang.String).toCharArray()");
                } else {
                    cArray = null;
                }
                ks.load(inputStream, cArray);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            NetHttpTransport netHttpTransport = new NetHttpTransport.Builder().trustCertificates(ks).build();
            Intrinsics.checkNotNullExpressionValue((Object)netHttpTransport, (String)"NetHttpTransport.Builder\u2026tCertificates(ks).build()");
            httpTransport = (HttpTransport)netHttpTransport;
        }
        return httpTransport;
    }

    private static final HttpTransport createHttpTransport() {
        String[] protocols;
        for (String protocol : protocols = new String[]{"http", "https"}) {
            String proxyHost = System.getProperty(protocol + ".proxyHost");
            String proxyUser = System.getProperty(protocol + ".proxyUser");
            String proxyPassword = System.getProperty(protocol + ".proxyPassword");
            if (proxyHost == null || proxyUser == null || proxyPassword == null) continue;
            String defaultProxyPort = Intrinsics.areEqual((Object)protocol, (Object)"http") ? "80" : "443";
            int proxyPort = Integer.parseInt(System.getProperty(protocol + ".proxyPort", defaultProxyPort));
            BasicCredentialsProvider credentials = new BasicCredentialsProvider();
            credentials.setCredentials(new AuthScope(proxyHost, proxyPort), (Credentials)new UsernamePasswordCredentials(proxyUser, proxyPassword));
            CloseableHttpClient httpClient = ApacheHttpTransport.newDefaultHttpClientBuilder().setProxyAuthenticationStrategy((AuthenticationStrategy)ProxyAuthenticationStrategy.INSTANCE).setDefaultCredentialsProvider((CredentialsProvider)credentials).build();
            return (HttpTransport)new ApacheHttpTransport((HttpClient)httpClient);
        }
        NetHttpTransport netHttpTransport = GoogleNetHttpTransport.newTrustedTransport();
        Intrinsics.checkNotNullExpressionValue((Object)netHttpTransport, (String)"GoogleNetHttpTransport.newTrustedTransport()");
        return (HttpTransport)netHttpTransport;
    }
}

