/*
 * Decompiled with CFR 0.152.
 */
package com.github.triplet.gradle.androidpublisher.internal;

import com.github.triplet.gradle.androidpublisher.CommitResponse;
import com.github.triplet.gradle.androidpublisher.EditResponse;
import com.github.triplet.gradle.androidpublisher.GppProduct;
import com.github.triplet.gradle.androidpublisher.PlayPublisher;
import com.github.triplet.gradle.androidpublisher.UpdateProductResponse;
import com.github.triplet.gradle.androidpublisher.UploadInternalSharingArtifactResponse;
import com.github.triplet.gradle.androidpublisher.internal.AndroidPublisherKt;
import com.github.triplet.gradle.androidpublisher.internal.DefaultPlayPublisher;
import com.github.triplet.gradle.androidpublisher.internal.InternalPlayPublisher;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.googleapis.media.MediaHttpUploader;
import com.google.api.client.googleapis.media.MediaHttpUploaderProgressListener;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.FileContent;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.services.androidpublisher.AndroidPublisher;
import com.google.api.services.androidpublisher.model.Apk;
import com.google.api.services.androidpublisher.model.AppDetails;
import com.google.api.services.androidpublisher.model.AppEdit;
import com.google.api.services.androidpublisher.model.Bundle;
import com.google.api.services.androidpublisher.model.DeobfuscationFilesUploadResponse;
import com.google.api.services.androidpublisher.model.ExpansionFile;
import com.google.api.services.androidpublisher.model.Image;
import com.google.api.services.androidpublisher.model.ImagesListResponse;
import com.google.api.services.androidpublisher.model.InAppProduct;
import com.google.api.services.androidpublisher.model.InappproductsListResponse;
import com.google.api.services.androidpublisher.model.InternalAppSharingArtifact;
import com.google.api.services.androidpublisher.model.Listing;
import com.google.api.services.androidpublisher.model.ListingsListResponse;
import com.google.api.services.androidpublisher.model.TokenPagination;
import com.google.api.services.androidpublisher.model.Track;
import com.google.api.services.androidpublisher.model.TrackRelease;
import com.google.api.services.androidpublisher.model.TracksListResponse;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 K2\u00020\u0001:\u0002KLB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0015\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u0005H\u0016J&\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0016J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001cH\u0016J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001c2\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\u0018\u0010\"\u001a\u00020#2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0005H\u0016J\b\u0010%\u001a\u00020\u001aH\u0016J\u0010\u0010&\u001a\u00020\n2\u0006\u0010'\u001a\u00020(H\u0016J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020#0\u001c2\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\u0018\u0010*\u001a\n ,*\u0004\u0018\u00010+0+2\u0006\u0010-\u001a\u00020(H\u0002J\u0018\u0010.\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\u0018H\u0016J\u0010\u00100\u001a\u0002012\u0006\u0010'\u001a\u00020(H\u0016J \u00102\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u00103\u001a\u00020!H\u0016J\u0018\u00104\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010$\u001a\u00020#H\u0016J\u0018\u00105\u001a\u0002062\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u00107\u001a\u00020(H\u0016J\u0018\u00108\u001a\u0002092\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010:\u001a\u00020(H\u0016J(\u0010;\u001a\u00020<2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010=\u001a\u00020(2\u0006\u0010>\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0005H\u0016J(\u0010?\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010@\u001a\u00020(H\u0016J\u0010\u0010A\u001a\u00020B2\u0006\u00107\u001a\u00020(H\u0016J\u0010\u0010C\u001a\u00020B2\u0006\u0010:\u001a\u00020(H\u0016J\u0010\u0010D\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0005H\u0016J7\u0010E\u001a\u0002HF\"\u0004\b\u0000\u0010G\"\u000e\b\u0001\u0010F*\b\u0012\u0004\u0012\u0002HG0H*\u0002HF2\u0006\u0010I\u001a\u00020\u00052\u0006\u0010=\u001a\u00020(H\u0002\u00a2\u0006\u0002\u0010JR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lcom/github/triplet/gradle/androidpublisher/internal/DefaultPlayPublisher;", "Lcom/github/triplet/gradle/androidpublisher/internal/InternalPlayPublisher;", "publisher", "Lcom/google/api/services/androidpublisher/AndroidPublisher;", "appId", "", "(Lcom/google/api/services/androidpublisher/AndroidPublisher;Ljava/lang/String;)V", "getAppId", "()Ljava/lang/String;", "attachObb", "", "editId", "type", "appVersion", "", "obbVersion", "commitEdit", "Lcom/github/triplet/gradle/androidpublisher/CommitResponse;", "id", "sendChangesForReview", "", "deleteImages", "locale", "getAppDetails", "Lcom/google/api/services/androidpublisher/model/AppDetails;", "getEdit", "Lcom/github/triplet/gradle/androidpublisher/EditResponse;", "getImages", "", "Lcom/google/api/services/androidpublisher/model/Image;", "getInAppProducts", "Lcom/github/triplet/gradle/androidpublisher/GppProduct;", "getListings", "Lcom/google/api/services/androidpublisher/model/Listing;", "getTrack", "Lcom/google/api/services/androidpublisher/model/Track;", "track", "insertEdit", "insertInAppProduct", "productFile", "Ljava/io/File;", "listTracks", "readProductFile", "Lcom/google/api/services/androidpublisher/model/InAppProduct;", "kotlin.jvm.PlatformType", "product", "updateDetails", "details", "updateInAppProduct", "Lcom/github/triplet/gradle/androidpublisher/UpdateProductResponse;", "updateListing", "listing", "updateTrack", "uploadApk", "Lcom/google/api/services/androidpublisher/model/Apk;", "apkFile", "uploadBundle", "Lcom/google/api/services/androidpublisher/model/Bundle;", "bundleFile", "uploadDeobfuscationFile", "Lcom/google/api/services/androidpublisher/model/DeobfuscationFilesUploadResponse;", "file", "versionCode", "uploadImage", "image", "uploadInternalSharingApk", "Lcom/github/triplet/gradle/androidpublisher/UploadInternalSharingArtifactResponse;", "uploadInternalSharingBundle", "validateEdit", "trackUploadProgress", "R", "T", "Lcom/google/api/client/googleapis/services/AbstractGoogleClientRequest;", "thing", "(Lcom/google/api/client/googleapis/services/AbstractGoogleClientRequest;Ljava/lang/String;Ljava/io/File;)Lcom/google/api/client/googleapis/services/AbstractGoogleClientRequest;", "Companion", "Factory", "android-publisher"})
@SourceDebugExtension(value={"SMAP\nDefaultPlayPublisher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultPlayPublisher.kt\ncom/github/triplet/gradle/androidpublisher/internal/DefaultPlayPublisher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,257:1\n1549#2:258\n1620#2,3:259\n1360#2:262\n1446#2,5:263\n1549#2:269\n1620#2,3:270\n1#3:268\n*S KotlinDebug\n*F\n+ 1 DefaultPlayPublisher.kt\ncom/github/triplet/gradle/androidpublisher/internal/DefaultPlayPublisher\n*L\n110#1:258\n110#1:259,3\n111#1:262\n111#1:263,5\n187#1:269\n187#1:270,3\n*E\n"})
public final class DefaultPlayPublisher
implements InternalPlayPublisher {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final AndroidPublisher publisher;
    @NotNull
    private final String appId;
    @Deprecated
    @NotNull
    public static final String MIME_TYPE_STREAM = "application/octet-stream";
    @Deprecated
    @NotNull
    public static final String MIME_TYPE_APK = "application/vnd.android.package-archive";
    @Deprecated
    @NotNull
    public static final String MIME_TYPE_IMAGE = "image/*";

    public DefaultPlayPublisher(@NotNull AndroidPublisher publisher, @NotNull String appId) {
        Intrinsics.checkNotNullParameter((Object)publisher, (String)"publisher");
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        this.publisher = publisher;
        this.appId = appId;
    }

    @Override
    @NotNull
    public String getAppId() {
        return this.appId;
    }

    @Override
    @NotNull
    public EditResponse insertEdit() {
        EditResponse editResponse;
        try {
            String string = ((AppEdit)this.publisher.edits().insert(this.getAppId(), null).execute()).getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"publisher.edits().insert(appId, null).execute().id");
            editResponse = new EditResponse.Success(string);
        }
        catch (GoogleJsonResponseException e) {
            editResponse = new EditResponse.Failure(e);
        }
        return editResponse;
    }

    @Override
    @NotNull
    public EditResponse getEdit(@NotNull String id) {
        EditResponse editResponse;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        try {
            String string = ((AppEdit)this.publisher.edits().get(this.getAppId(), id).execute()).getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"publisher.edits().get(appId, id).execute().id");
            editResponse = new EditResponse.Success(string);
        }
        catch (GoogleJsonResponseException e) {
            editResponse = new EditResponse.Failure(e);
        }
        return editResponse;
    }

    @Override
    @NotNull
    public CommitResponse commitEdit(@NotNull String id, boolean sendChangesForReview) {
        CommitResponse commitResponse;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        try {
            this.publisher.edits().commit(this.getAppId(), id).setChangesNotSentForReview(Boolean.valueOf(!sendChangesForReview)).execute();
            commitResponse = CommitResponse.Success.INSTANCE;
        }
        catch (GoogleJsonResponseException e) {
            commitResponse = new CommitResponse.Failure(e);
        }
        return commitResponse;
    }

    @Override
    public void validateEdit(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.publisher.edits().validate(this.getAppId(), id).execute();
    }

    @Override
    @NotNull
    public AppDetails getAppDetails(@NotNull String editId) {
        Intrinsics.checkNotNullParameter((Object)editId, (String)"editId");
        Object object = this.publisher.edits().details().get(this.getAppId(), editId).execute();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"publisher.edits().detail\u2026(appId, editId).execute()");
        return (AppDetails)object;
    }

    @Override
    @NotNull
    public List<Listing> getListings(@NotNull String editId) {
        Intrinsics.checkNotNullParameter((Object)editId, (String)"editId");
        ListingsListResponse listingsListResponse = (ListingsListResponse)this.publisher.edits().listings().list(this.getAppId(), editId).execute();
        List list = listingsListResponse != null ? listingsListResponse.getListings() : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @NotNull
    public List<Image> getImages(@NotNull String editId, @NotNull String locale, @NotNull String type) {
        ImagesListResponse response;
        Intrinsics.checkNotNullParameter((Object)editId, (String)"editId");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        ImagesListResponse imagesListResponse = response = (ImagesListResponse)this.publisher.edits().images().list(this.getAppId(), editId, locale, type).execute();
        List list = imagesListResponse != null ? imagesListResponse.getImages() : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    public void updateDetails(@NotNull String editId, @NotNull AppDetails details) {
        Intrinsics.checkNotNullParameter((Object)editId, (String)"editId");
        Intrinsics.checkNotNullParameter((Object)details, (String)"details");
        this.publisher.edits().details().update(this.getAppId(), editId, details).execute();
    }

    @Override
    public void updateListing(@NotNull String editId, @NotNull String locale, @NotNull Listing listing) {
        Intrinsics.checkNotNullParameter((Object)editId, (String)"editId");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        Intrinsics.checkNotNullParameter((Object)listing, (String)"listing");
        this.publisher.edits().listings().update(this.getAppId(), editId, locale, listing).execute();
    }

    @Override
    public void deleteImages(@NotNull String editId, @NotNull String locale, @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)editId, (String)"editId");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.publisher.edits().images().deleteall(this.getAppId(), editId, locale, type).execute();
    }

    @Override
    public void uploadImage(@NotNull String editId, @NotNull String locale, @NotNull String type, @NotNull File image) {
        Intrinsics.checkNotNullParameter((Object)editId, (String)"editId");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        FileContent content = new FileContent(MIME_TYPE_IMAGE, image);
        this.publisher.edits().images().upload(this.getAppId(), editId, locale, type, (AbstractInputStreamContent)content).execute();
    }

    @Override
    @NotNull
    public Track getTrack(@NotNull String editId, @NotNull String track) {
        Track track2;
        Intrinsics.checkNotNullParameter((Object)editId, (String)"editId");
        Intrinsics.checkNotNullParameter((Object)track, (String)"track");
        try {
            Object object = this.publisher.edits().tracks().get(this.getAppId(), editId, track).execute();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n            publisher.\u2026rack).execute()\n        }");
            track2 = (Track)object;
        }
        catch (GoogleJsonResponseException e) {
            if (!AndroidPublisherKt.has(e, "notFound")) {
                throw e;
            }
            Track track3 = new Track().setTrack(track);
            Intrinsics.checkNotNullExpressionValue((Object)track3, (String)"{\n            if (e has \u2026e\n            }\n        }");
            track2 = track3;
        }
        return track2;
    }

    @Override
    @NotNull
    public List<Track> listTracks(@NotNull String editId) {
        Intrinsics.checkNotNullParameter((Object)editId, (String)"editId");
        TracksListResponse tracksListResponse = (TracksListResponse)this.publisher.edits().tracks().list(this.getAppId(), editId).execute();
        List list = tracksListResponse != null ? tracksListResponse.getTracks() : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void updateTrack(@NotNull String editId, @NotNull Track track) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        TrackRelease it;
        Collection collection;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)editId, (String)"editId");
        Intrinsics.checkNotNullParameter((Object)track, (String)"track");
        List list = track.getReleases();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"track.releases");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            TrackRelease trackRelease = (TrackRelease)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getStatus());
        }
        List list2 = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        String string = this.getAppId();
        List list3 = track.getReleases();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"track.releases");
        $this$map$iv = list3;
        String string2 = string;
        collection = list2;
        boolean $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (TrackRelease)element$iv$iv;
            boolean bl = false;
            List list4 = it.getVersionCodes();
            if (list4 == null) {
                list4 = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = list4;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list5 = (List)destination$iv$iv;
        String string3 = "Updating " + (List)collection + " release (" + string2 + ":" + list5 + ") in track '" + track.getTrack() + "'";
        System.out.println((Object)string3);
        this.publisher.edits().tracks().update(this.getAppId(), editId, track.getTrack(), track).execute();
    }

    @Override
    @NotNull
    public Bundle uploadBundle(@NotNull String editId, @NotNull File bundleFile) {
        Intrinsics.checkNotNullParameter((Object)editId, (String)"editId");
        Intrinsics.checkNotNullParameter((Object)bundleFile, (String)"bundleFile");
        FileContent content = new FileContent(MIME_TYPE_STREAM, bundleFile);
        Object object = ((AndroidPublisher.Edits.Bundles.Upload)this.trackUploadProgress((AbstractGoogleClientRequest)this.publisher.edits().bundles().upload(this.getAppId(), editId, (AbstractInputStreamContent)content), "App Bundle", bundleFile)).execute();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"publisher.edits().bundle\u2026               .execute()");
        return (Bundle)object;
    }

    @Override
    @NotNull
    public Apk uploadApk(@NotNull String editId, @NotNull File apkFile) {
        Intrinsics.checkNotNullParameter((Object)editId, (String)"editId");
        Intrinsics.checkNotNullParameter((Object)apkFile, (String)"apkFile");
        FileContent content = new FileContent(MIME_TYPE_APK, apkFile);
        Object object = ((AndroidPublisher.Edits.Apks.Upload)this.trackUploadProgress((AbstractGoogleClientRequest)this.publisher.edits().apks().upload(this.getAppId(), editId, (AbstractInputStreamContent)content), "APK", apkFile)).execute();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"publisher.edits().apks()\u2026               .execute()");
        return (Apk)object;
    }

    @Override
    public void attachObb(@NotNull String editId, @NotNull String type, int appVersion, int obbVersion) {
        ExpansionFile expansionFile;
        Intrinsics.checkNotNullParameter((Object)editId, (String)"editId");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        ExpansionFile it = expansionFile = new ExpansionFile();
        boolean bl = false;
        it.setReferencesVersion(Integer.valueOf(obbVersion));
        ExpansionFile obb = expansionFile;
        this.publisher.edits().expansionfiles().update(this.getAppId(), editId, Integer.valueOf(appVersion), type, obb).execute();
    }

    @Override
    @NotNull
    public DeobfuscationFilesUploadResponse uploadDeobfuscationFile(@NotNull String editId, @NotNull File file, int versionCode, @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)editId, (String)"editId");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        FileContent mapping = new FileContent(MIME_TYPE_STREAM, file);
        String string = type;
        String humanFileName = Intrinsics.areEqual((Object)string, (Object)"proguard") ? "mapping" : (Intrinsics.areEqual((Object)string, (Object)"nativeCode") ? "native debug symbols" : type);
        Object object = ((AndroidPublisher.Edits.Deobfuscationfiles.Upload)this.trackUploadProgress((AbstractGoogleClientRequest)this.publisher.edits().deobfuscationfiles().upload(this.getAppId(), editId, Integer.valueOf(versionCode), type, (AbstractInputStreamContent)mapping), humanFileName + " file", file)).execute();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"publisher.edits().deobfu\u2026               .execute()");
        return (DeobfuscationFilesUploadResponse)object;
    }

    @Override
    @NotNull
    public UploadInternalSharingArtifactResponse uploadInternalSharingBundle(@NotNull File bundleFile) {
        Intrinsics.checkNotNullParameter((Object)bundleFile, (String)"bundleFile");
        InternalAppSharingArtifact bundle = (InternalAppSharingArtifact)((AndroidPublisher.Internalappsharingartifacts.Uploadbundle)this.trackUploadProgress((AbstractGoogleClientRequest)this.publisher.internalappsharingartifacts().uploadbundle(this.getAppId(), (AbstractInputStreamContent)new FileContent(MIME_TYPE_STREAM, bundleFile)), "App Bundle", bundleFile)).execute();
        String string = bundle.toPrettyString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"bundle.toPrettyString()");
        String string2 = bundle.getDownloadUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"bundle.downloadUrl");
        return new UploadInternalSharingArtifactResponse(string, string2);
    }

    @Override
    @NotNull
    public UploadInternalSharingArtifactResponse uploadInternalSharingApk(@NotNull File apkFile) {
        Intrinsics.checkNotNullParameter((Object)apkFile, (String)"apkFile");
        InternalAppSharingArtifact apk = (InternalAppSharingArtifact)((AndroidPublisher.Internalappsharingartifacts.Uploadapk)this.trackUploadProgress((AbstractGoogleClientRequest)this.publisher.internalappsharingartifacts().uploadapk(this.getAppId(), (AbstractInputStreamContent)new FileContent(MIME_TYPE_APK, apkFile)), "APK", apkFile)).execute();
        String string = apk.toPrettyString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"apk.toPrettyString()");
        String string2 = apk.getDownloadUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"apk.downloadUrl");
        return new UploadInternalSharingArtifactResponse(string, string2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<GppProduct> getInAppProducts() {
        void $this$mapTo$iv$iv;
        TokenPagination tokenPagination;
        List products = new ArrayList();
        String token = null;
        do {
            AndroidPublisher.Inappproducts.List list = this.publisher.inappproducts().list(this.getAppId());
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"publisher.inappproducts().list(appId)");
            InappproductsListResponse response = (InappproductsListResponse)DefaultPlayPublisher.getInAppProducts$withToken(list, token).execute();
            Collection collection = products;
            List list2 = response.getInappproduct();
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            CollectionsKt.addAll((Collection)collection, (Iterable)list2);
            tokenPagination = response.getTokenPagination();
        } while ((token = tokenPagination != null ? tokenPagination.getNextPageToken() : null) != null);
        Iterable $this$map$iv = products;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            InAppProduct inAppProduct = (InAppProduct)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getSku();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.sku");
            String string2 = it.toPrettyString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.toPrettyString()");
            collection.add(new GppProduct(string, string2));
        }
        return (List)destination$iv$iv;
    }

    @Override
    public void insertInAppProduct(@NotNull File productFile) {
        AndroidPublisher.Inappproducts.Insert insert;
        Intrinsics.checkNotNullParameter((Object)productFile, (String)"productFile");
        AndroidPublisher.Inappproducts.Insert $this$insertInAppProduct_u24lambda_u245 = insert = this.publisher.inappproducts().insert(this.getAppId(), this.readProductFile(productFile));
        boolean bl = false;
        $this$insertInAppProduct_u24lambda_u245.setAutoConvertMissingPrices(Boolean.valueOf(true));
        insert.execute();
    }

    @Override
    @NotNull
    public UpdateProductResponse updateInAppProduct(@NotNull File productFile) {
        Intrinsics.checkNotNullParameter((Object)productFile, (String)"productFile");
        InAppProduct product = this.readProductFile(productFile);
        try {
            AndroidPublisher.Inappproducts.Update update;
            AndroidPublisher.Inappproducts.Update $this$updateInAppProduct_u24lambda_u246 = update = this.publisher.inappproducts().update(this.getAppId(), product.getSku(), product);
            boolean bl = false;
            $this$updateInAppProduct_u24lambda_u246.setAutoConvertMissingPrices(Boolean.valueOf(true));
            update.execute();
        }
        catch (GoogleJsonResponseException e) {
            if (e.getStatusCode() == 404) {
                return new UpdateProductResponse(true);
            }
            throw e;
        }
        return new UpdateProductResponse(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final InAppProduct readProductFile(File product) {
        InAppProduct inAppProduct;
        Closeable closeable = new FileInputStream(product);
        Throwable throwable = null;
        try {
            FileInputStream it = (FileInputStream)closeable;
            boolean bl = false;
            inAppProduct = (InAppProduct)GsonFactory.getDefaultInstance().createJsonParser((InputStream)it).parse(InAppProduct.class);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return inAppProduct;
    }

    private final <T, R extends AbstractGoogleClientRequest<T>> R trackUploadProgress(R $this$trackUploadProgress, String thing, File file) {
        block0: {
            MediaHttpUploader mediaHttpUploader = $this$trackUploadProgress.getMediaHttpUploader();
            if (mediaHttpUploader == null) break block0;
            mediaHttpUploader.setProgressListener(new MediaHttpUploaderProgressListener(thing, file){
                final /* synthetic */ String $thing;
                final /* synthetic */ File $file;
                {
                    this.$thing = $thing;
                    this.$file = $file;
                }

                public final void progressChanged(MediaHttpUploader it) {
                    MediaHttpUploader.UploadState uploadState = it.getUploadState();
                    switch (uploadState == null ? -1 : trackUploadProgress.WhenMappings.$EnumSwitchMapping$0[uploadState.ordinal()]) {
                        case 1: {
                            System.out.println((Object)("Starting " + this.$thing + " upload: " + this.$file));
                            break;
                        }
                        case 2: {
                            System.out.println((Object)("Uploading " + this.$thing + ": " + MathKt.roundToInt((double)(it.getProgress() * (double)100)) + "% complete"));
                            break;
                        }
                        case 3: {
                            System.out.println((Object)(StringsKt.capitalize((String)this.$thing) + " upload complete"));
                        }
                    }
                }
            });
        }
        return $this$trackUploadProgress;
    }

    private static final AndroidPublisher.Inappproducts.List getInAppProducts$withToken(AndroidPublisher.Inappproducts.List $this$getInAppProducts_u24withToken, String token) {
        AndroidPublisher.Inappproducts.List list;
        AndroidPublisher.Inappproducts.List $this$getInAppProducts_u24withToken_u24lambda_u243 = list = $this$getInAppProducts_u24withToken;
        boolean bl = false;
        $this$getInAppProducts_u24withToken_u24lambda_u243.setToken(token);
        return list;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/github/triplet/gradle/androidpublisher/internal/DefaultPlayPublisher$Companion;", "", "()V", "MIME_TYPE_APK", "", "MIME_TYPE_IMAGE", "MIME_TYPE_STREAM", "android-publisher"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/github/triplet/gradle/androidpublisher/internal/DefaultPlayPublisher$Factory;", "Lcom/github/triplet/gradle/androidpublisher/PlayPublisher$Factory;", "()V", "create", "Lcom/github/triplet/gradle/androidpublisher/PlayPublisher;", "credentials", "Ljava/io/InputStream;", "appId", "", "android-publisher"})
    public static final class Factory
    implements PlayPublisher.Factory {
        @Override
        @NotNull
        public PlayPublisher create(@NotNull InputStream credentials, @NotNull String appId) {
            Intrinsics.checkNotNullParameter((Object)credentials, (String)"credentials");
            Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
            AndroidPublisher publisher = AndroidPublisherKt.createPublisher(credentials);
            return new DefaultPlayPublisher(publisher, appId);
        }
    }
}

