/*
 * Decompiled with CFR 0.152.
 */
package com.github.triplet.gradle.androidpublisher.internal;

import com.github.triplet.gradle.androidpublisher.EditManager;
import com.github.triplet.gradle.androidpublisher.GppAppDetails;
import com.github.triplet.gradle.androidpublisher.GppImage;
import com.github.triplet.gradle.androidpublisher.GppListing;
import com.github.triplet.gradle.androidpublisher.PlayPublisher;
import com.github.triplet.gradle.androidpublisher.ReleaseNote;
import com.github.triplet.gradle.androidpublisher.ReleaseStatus;
import com.github.triplet.gradle.androidpublisher.ResolutionStrategy;
import com.github.triplet.gradle.androidpublisher.internal.AndroidPublisherKt;
import com.github.triplet.gradle.androidpublisher.internal.DefaultTrackManager;
import com.github.triplet.gradle.androidpublisher.internal.InternalPlayPublisher;
import com.github.triplet.gradle.androidpublisher.internal.TrackManager;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.services.androidpublisher.model.Apk;
import com.google.api.services.androidpublisher.model.AppDetails;
import com.google.api.services.androidpublisher.model.Bundle;
import com.google.api.services.androidpublisher.model.Image;
import com.google.api.services.androidpublisher.model.Listing;
import com.google.api.services.androidpublisher.model.LocalizedText;
import com.google.api.services.androidpublisher.model.Track;
import com.google.api.services.androidpublisher.model.TrackRelease;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0019\b\u0000\u0018\u0000 M2\u00020\u0001:\u0002MNB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\n\u0010\t\u001a\u0004\u0018\u00010\u0007H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000fH\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000fH\u0016J\"\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002Jm\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u00072\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010\u00072\u0016\u0010&\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010'2\b\u0010(\u001a\u0004\u0018\u00010)2\b\u0010*\u001a\u0004\u0018\u00010+2\u000e\u0010,\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u000fH\u0016\u00a2\u0006\u0002\u0010-J0\u0010.\u001a\u00020 2\b\u0010/\u001a\u0004\u0018\u00010\u00072\b\u00100\u001a\u0004\u0018\u00010\u00072\b\u00101\u001a\u0004\u0018\u00010\u00072\b\u00102\u001a\u0004\u0018\u00010\u0007H\u0016J{\u00103\u001a\u00020 2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u00072\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010\u00072\u0016\u0010&\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010'2\b\u0010(\u001a\u0004\u0018\u00010)2\b\u0010*\u001a\u0004\u0018\u00010+2\u000e\u0010,\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\u000fH\u0016\u00a2\u0006\u0002\u00108J&\u00109\u001a\u00020 2\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00072\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u001e0\u000fH\u0016J8\u0010;\u001a\u00020 2\u0006\u0010\u0011\u001a\u00020\u00072\b\u0010<\u001a\u0004\u0018\u00010\u00072\b\u0010=\u001a\u0004\u0018\u00010\u00072\b\u0010>\u001a\u0004\u0018\u00010\u00072\b\u0010?\u001a\u0004\u0018\u00010\u0007H\u0016JG\u0010@\u001a\u0004\u0018\u00010\u000b2\u0006\u0010A\u001a\u00020\u001e2\b\u0010B\u001a\u0004\u0018\u00010\u001e2\b\u0010C\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010D\u001a\u0004\u0018\u00010+2\b\u0010E\u001a\u0004\u0018\u00010+H\u0016\u00a2\u0006\u0002\u0010FJ\u001f\u0010G\u001a\u0004\u0018\u00010\u000b2\u0006\u0010H\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016\u00a2\u0006\u0002\u0010IJ\u001a\u0010J\u001a\u00020 2\u0006\u0010K\u001a\u00020+2\b\u0010B\u001a\u0004\u0018\u00010\u001eH\u0002J\u001c\u0010L\u001a\u00020 *\u00020+2\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010K\u001a\u00020+H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lcom/github/triplet/gradle/androidpublisher/internal/DefaultEditManager;", "Lcom/github/triplet/gradle/androidpublisher/EditManager;", "publisher", "Lcom/github/triplet/gradle/androidpublisher/internal/InternalPlayPublisher;", "tracks", "Lcom/github/triplet/gradle/androidpublisher/internal/TrackManager;", "editId", "", "(Lcom/github/triplet/gradle/androidpublisher/internal/InternalPlayPublisher;Lcom/github/triplet/gradle/androidpublisher/internal/TrackManager;Ljava/lang/String;)V", "findLeastStableTrackName", "findMaxAppVersionCode", "", "getAppDetails", "Lcom/github/triplet/gradle/androidpublisher/GppAppDetails;", "getImages", "", "Lcom/github/triplet/gradle/androidpublisher/GppImage;", "locale", "type", "getListings", "Lcom/github/triplet/gradle/androidpublisher/GppListing;", "getReleaseNotes", "Lcom/github/triplet/gradle/androidpublisher/ReleaseNote;", "handleUploadFailures", "", "e", "Lcom/google/api/client/googleapis/json/GoogleJsonResponseException;", "strategy", "Lcom/github/triplet/gradle/androidpublisher/ResolutionStrategy;", "artifact", "Ljava/io/File;", "promoteRelease", "", "promoteTrackName", "fromTrackName", "releaseStatus", "Lcom/github/triplet/gradle/androidpublisher/ReleaseStatus;", "releaseName", "releaseNotes", "", "userFraction", "", "updatePriority", "", "retainableArtifacts", "(Ljava/lang/String;Ljava/lang/String;Lcom/github/triplet/gradle/androidpublisher/ReleaseStatus;Ljava/lang/String;Ljava/util/Map;Ljava/lang/Double;Ljava/lang/Integer;Ljava/util/List;)V", "publishAppDetails", "defaultLocale", "contactEmail", "contactPhone", "contactWebsite", "publishArtifacts", "versionCodes", "didPreviousBuildSkipCommit", "", "trackName", "(Ljava/util/List;ZLjava/lang/String;Lcom/github/triplet/gradle/androidpublisher/ReleaseStatus;Ljava/lang/String;Ljava/util/Map;Ljava/lang/Double;Ljava/lang/Integer;Ljava/util/List;)V", "publishImages", "images", "publishListing", "title", "shortDescription", "fullDescription", "video", "uploadApk", "apkFile", "mappingFile", "debugSymbolsFile", "mainObbRetainable", "patchObbRetainable", "(Ljava/io/File;Ljava/io/File;Ljava/io/File;Lcom/github/triplet/gradle/androidpublisher/ResolutionStrategy;Ljava/lang/Integer;Ljava/lang/Integer;)Ljava/lang/Long;", "uploadBundle", "bundleFile", "(Ljava/io/File;Lcom/github/triplet/gradle/androidpublisher/ResolutionStrategy;)Ljava/lang/Long;", "uploadMappingFile", "versionCode", "attachObb", "Companion", "Factory", "android-publisher"})
@SourceDebugExtension(value={"SMAP\nDefaultEditManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultEditManager.kt\ncom/github/triplet/gradle/androidpublisher/internal/DefaultEditManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,255:1\n1549#2:256\n1620#2,3:257\n1549#2:260\n1620#2,3:261\n1360#2:264\n1446#2,5:265\n1549#2:273\n1620#2,3:274\n125#3:270\n152#3,2:271\n154#3:277\n*S KotlinDebug\n*F\n+ 1 DefaultEditManager.kt\ncom/github/triplet/gradle/androidpublisher/internal/DefaultEditManager\n*L\n33#1:256\n33#1:257,3\n45#1:260\n45#1:261,3\n52#1:264\n52#1:265,5\n62#1:273\n62#1:274,3\n61#1:270\n61#1:271,2\n61#1:277\n*E\n"})
public final class DefaultEditManager
implements EditManager {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final InternalPlayPublisher publisher;
    @NotNull
    private final TrackManager tracks;
    @NotNull
    private final String editId;
    @Deprecated
    @NotNull
    public static final String HIGH_RES_IMAGE_REQUEST = "=h16383";

    public DefaultEditManager(@NotNull InternalPlayPublisher publisher, @NotNull TrackManager tracks, @NotNull String editId) {
        Intrinsics.checkNotNullParameter((Object)publisher, (String)"publisher");
        Intrinsics.checkNotNullParameter((Object)tracks, (String)"tracks");
        Intrinsics.checkNotNullParameter((Object)editId, (String)"editId");
        this.publisher = publisher;
        this.tracks = tracks;
        this.editId = editId;
    }

    @Override
    @NotNull
    public GppAppDetails getAppDetails() {
        AppDetails details = this.publisher.getAppDetails(this.editId);
        return new GppAppDetails(details.getDefaultLanguage(), details.getContactEmail(), details.getContactPhone(), details.getContactWebsite());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<GppListing> getListings() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.publisher.getListings(this.editId);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Listing listing = (Listing)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.language");
            collection.add(new GppListing(string, it.getFullDescription(), it.getShortDescription(), it.getTitle(), it.getVideo()));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<GppImage> getImages(@NotNull String locale, @NotNull String type) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Iterable $this$map$iv = this.publisher.getImages(this.editId, locale, type);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Image image = (Image)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getUrl() + HIGH_RES_IMAGE_REQUEST;
            String string2 = it.getSha256();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.sha256");
            collection.add(new GppImage(string, string2));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long findMaxAppVersionCode() {
        void $this$flatMapTo$iv$iv;
        Track track = this.tracks.findHighestTrack();
        List list = track != null ? track.getReleases() : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            TrackRelease it = (TrackRelease)element$iv$iv;
            boolean bl = false;
            List list2 = it.getVersionCodes();
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = list2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Long l = (Long)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv));
        return l != null ? l : 1L;
    }

    @Override
    @Nullable
    public String findLeastStableTrackName() {
        Track track = this.tracks.findHighestTrack();
        return track != null ? track.getTrack() : null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ReleaseNote> getReleaseNotes() {
        void $this$mapTo$iv$iv;
        Map<String, List<LocalizedText>> $this$map$iv = this.tracks.getReleaseNotes();
        boolean $i$f$map = false;
        Map<String, List<LocalizedText>> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$mapTo$iv$iv2;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String track = (String)entry.getKey();
            List notes = (List)entry.getValue();
            Iterable $this$map$iv2 = notes;
            boolean $i$f$map2 = false;
            Iterable iterable = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it;
                LocalizedText localizedText = (LocalizedText)item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                String string = it.getLanguage();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.language");
                String string2 = it.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.text");
                collection2.add(new ReleaseNote(track, string, string2));
            }
            collection.add((List)destination$iv$iv2);
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void publishAppDetails(@Nullable String defaultLocale, @Nullable String contactEmail, @Nullable String contactPhone, @Nullable String contactWebsite) {
        void $this$publishAppDetails_u24lambda_u245;
        AppDetails appDetails;
        AppDetails appDetails2 = appDetails = new AppDetails();
        String string = this.editId;
        InternalPlayPublisher internalPlayPublisher = this.publisher;
        boolean bl = false;
        $this$publishAppDetails_u24lambda_u245.setDefaultLanguage(defaultLocale);
        $this$publishAppDetails_u24lambda_u245.setContactEmail(contactEmail);
        $this$publishAppDetails_u24lambda_u245.setContactPhone(contactPhone);
        $this$publishAppDetails_u24lambda_u245.setContactWebsite(contactWebsite);
        Unit unit = Unit.INSTANCE;
        internalPlayPublisher.updateDetails(string, appDetails);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void publishListing(@NotNull String locale, @Nullable String title, @Nullable String shortDescription, @Nullable String fullDescription, @Nullable String video) {
        void $this$publishListing_u24lambda_u246;
        Listing listing;
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        Listing listing2 = listing = new Listing();
        String string = locale;
        String string2 = this.editId;
        InternalPlayPublisher internalPlayPublisher = this.publisher;
        boolean bl = false;
        $this$publishListing_u24lambda_u246.setTitle(title);
        $this$publishListing_u24lambda_u246.setShortDescription(shortDescription);
        $this$publishListing_u24lambda_u246.setFullDescription(fullDescription);
        $this$publishListing_u24lambda_u246.setVideo(video);
        Unit unit = Unit.INSTANCE;
        internalPlayPublisher.updateListing(string2, string, listing);
    }

    @Override
    public void publishImages(@NotNull String locale, @NotNull String type, @NotNull List<? extends File> images) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(images, (String)"images");
        this.publisher.deleteImages(this.editId, locale, type);
        for (File file : images) {
            System.out.println((Object)("Uploading " + locale + " listing graphic for type '" + type + "': " + file.getName()));
            this.publisher.uploadImage(this.editId, locale, type, file);
        }
    }

    @Override
    public void promoteRelease(@NotNull String promoteTrackName, @NotNull String fromTrackName, @Nullable ReleaseStatus releaseStatus, @Nullable String releaseName, @Nullable Map<String, String> releaseNotes, @Nullable Double userFraction, @Nullable Integer updatePriority, @Nullable List<Long> retainableArtifacts) {
        Intrinsics.checkNotNullParameter((Object)promoteTrackName, (String)"promoteTrackName");
        Intrinsics.checkNotNullParameter((Object)fromTrackName, (String)"fromTrackName");
        this.tracks.promote(new TrackManager.PromoteConfig(promoteTrackName, fromTrackName, new TrackManager.BaseConfig(releaseStatus, userFraction, updatePriority, releaseNotes, retainableArtifacts, releaseName)));
    }

    @Override
    @Nullable
    public Long uploadBundle(@NotNull File bundleFile, @NotNull ResolutionStrategy strategy) {
        Bundle bundle;
        Intrinsics.checkNotNullParameter((Object)bundleFile, (String)"bundleFile");
        Intrinsics.checkNotNullParameter((Object)((Object)strategy), (String)"strategy");
        try {
            bundle = this.publisher.uploadBundle(this.editId, bundleFile);
        }
        catch (GoogleJsonResponseException e) {
            this.handleUploadFailures(e, strategy, bundleFile);
            return null;
        }
        Bundle bundle2 = bundle;
        return (long)bundle2.getVersionCode();
    }

    @Override
    @Nullable
    public Long uploadApk(@NotNull File apkFile, @Nullable File mappingFile, @Nullable File debugSymbolsFile, @NotNull ResolutionStrategy strategy, @Nullable Integer mainObbRetainable, @Nullable Integer patchObbRetainable) {
        Apk apk;
        Intrinsics.checkNotNullParameter((Object)apkFile, (String)"apkFile");
        Intrinsics.checkNotNullParameter((Object)((Object)strategy), (String)"strategy");
        try {
            apk = this.publisher.uploadApk(this.editId, apkFile);
        }
        catch (GoogleJsonResponseException e) {
            this.handleUploadFailures(e, strategy, apkFile);
            return null;
        }
        Apk apk2 = apk;
        Integer n = mainObbRetainable;
        if (n != null) {
            int n2 = n;
            Integer n3 = apk2.getVersionCode();
            Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"apk.versionCode");
            this.attachObb(n2, "main", ((Number)n3).intValue());
        }
        Integer n4 = patchObbRetainable;
        if (n4 != null) {
            int n5 = n4;
            Integer n6 = apk2.getVersionCode();
            Intrinsics.checkNotNullExpressionValue((Object)n6, (String)"apk.versionCode");
            this.attachObb(n5, "patch", ((Number)n6).intValue());
        }
        Integer n7 = apk2.getVersionCode();
        Intrinsics.checkNotNullExpressionValue((Object)n7, (String)"apk.versionCode");
        this.uploadMappingFile(((Number)n7).intValue(), mappingFile);
        if (debugSymbolsFile != null) {
            Integer n8 = apk2.getVersionCode();
            Intrinsics.checkNotNullExpressionValue((Object)n8, (String)"apk.versionCode");
            this.publisher.uploadDeobfuscationFile(this.editId, debugSymbolsFile, ((Number)n8).intValue(), "nativeCode");
        }
        return (long)apk2.getVersionCode();
    }

    @Override
    public void publishArtifacts(@NotNull List<Long> versionCodes, boolean didPreviousBuildSkipCommit, @NotNull String trackName, @Nullable ReleaseStatus releaseStatus, @Nullable String releaseName, @Nullable Map<String, String> releaseNotes, @Nullable Double userFraction, @Nullable Integer updatePriority, @Nullable List<Long> retainableArtifacts) {
        Intrinsics.checkNotNullParameter(versionCodes, (String)"versionCodes");
        Intrinsics.checkNotNullParameter((Object)trackName, (String)"trackName");
        if (versionCodes.isEmpty()) {
            return;
        }
        this.tracks.update(new TrackManager.UpdateConfig(trackName, versionCodes, didPreviousBuildSkipCommit, new TrackManager.BaseConfig(releaseStatus, userFraction, updatePriority, releaseNotes, retainableArtifacts, releaseName)));
    }

    private final void uploadMappingFile(int versionCode, File mappingFile) {
        if (mappingFile != null && mappingFile.length() > 0L) {
            this.publisher.uploadDeobfuscationFile(this.editId, mappingFile, versionCode, "proguard");
        }
    }

    private final void attachObb(int $this$attachObb, String type, int versionCode) {
        System.out.println((Object)("Attaching " + type + " OBB (" + $this$attachObb + ") to APK " + versionCode));
        this.publisher.attachObb(this.editId, type, versionCode, $this$attachObb);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Void handleUploadFailures(GoogleJsonResponseException e, ResolutionStrategy strategy, File artifact) {
        if (!(AndroidPublisherKt.has(e, "apkNotificationMessageKeyUpgradeVersionConflict") || AndroidPublisherKt.has(e, "apkUpgradeVersionConflict") || AndroidPublisherKt.has(e, "apkNoUpgradePath"))) {
            if (!AndroidPublisherKt.has(e, "forbidden")) throw e;
            String string = e.getDetails().getMessage();
            if (string == null) {
                string = "";
            }
            String m = string;
            boolean bl = false;
            boolean bl2 = StringsKt.contains((CharSequence)m, (CharSequence)"version code", (boolean)true) || StringsKt.contains((CharSequence)m, (CharSequence)"Cannot update", (boolean)true);
            if (!bl2) throw e;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[strategy.ordinal()]) {
            case 1: 
            case 2: {
                throw new IllegalStateException("Concurrent uploads for app " + this.publisher.getAppId() + " (version code already used). Make sure to synchronously upload your APKs such that they don't conflict. If this problem persists, delete your drafts in the Play Console's artifact library.", e);
            }
            case 3: {
                throw new IllegalStateException("Version code is too low or has already been used for app " + this.publisher.getAppId() + ".", e);
            }
            case 4: {
                LoggerFactory.getLogger(EditManager.class).warn("Ignoring artifact (" + artifact + ")");
            }
        }
        return null;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/github/triplet/gradle/androidpublisher/internal/DefaultEditManager$Companion;", "", "()V", "HIGH_RES_IMAGE_REQUEST", "", "android-publisher"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/github/triplet/gradle/androidpublisher/internal/DefaultEditManager$Factory;", "Lcom/github/triplet/gradle/androidpublisher/EditManager$Factory;", "()V", "create", "Lcom/github/triplet/gradle/androidpublisher/internal/DefaultEditManager;", "publisher", "Lcom/github/triplet/gradle/androidpublisher/PlayPublisher;", "editId", "", "android-publisher"})
    public static final class Factory
    implements EditManager.Factory {
        @Override
        @NotNull
        public DefaultEditManager create(@NotNull PlayPublisher publisher, @NotNull String editId) {
            Intrinsics.checkNotNullParameter((Object)publisher, (String)"publisher");
            Intrinsics.checkNotNullParameter((Object)editId, (String)"editId");
            return new DefaultEditManager((InternalPlayPublisher)publisher, new DefaultTrackManager((InternalPlayPublisher)publisher, editId), editId);
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ResolutionStrategy.values().length];
            try {
                nArray[ResolutionStrategy.AUTO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResolutionStrategy.AUTO_OFFSET.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResolutionStrategy.FAIL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResolutionStrategy.IGNORE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

