/*
 * Decompiled with CFR 0.152.
 */
package com.github.triplet.gradle.common.validation;

import com.android.build.api.AndroidPluginVersion;
import com.android.build.api.component.analytics.AnalyticsEnabledApplicationVariant;
import com.android.build.api.variant.ApplicationAndroidComponentsExtension;
import com.android.build.api.variant.ApplicationVariant;
import com.android.build.gradle.AppPlugin;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.github.triplet.gradle.common.validation.AgpRuntimeValidator;
import com.github.triplet.gradle.common.validation.GradleRuntimeValidator;
import com.github.triplet.gradle.common.validation.MinDepsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.reflect.TypeOf;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\b\u00a8\u0006\t"}, d2={"validateDebuggability", "", "variant", "Lcom/android/build/api/variant/ApplicationVariant;", "logger", "Lorg/gradle/api/logging/Logger;", "validateRuntime", "", "Lorg/gradle/api/Project;", "validation"})
@SourceDebugExtension(value={"SMAP\nValidation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Validation.kt\ncom/github/triplet/gradle/common/validation/ValidationKt\n+ 2 DomainObjectCollectionExtensions.kt\norg/gradle/kotlin/dsl/DomainObjectCollectionExtensionsKt\n*L\n1#1,45:1\n33#2:46\n*S KotlinDebug\n*F\n+ 1 Validation.kt\ncom/github/triplet/gradle/common/validation/ValidationKt\n*L\n21#1:46\n*E\n"})
public final class ValidationKt {
    /*
     * WARNING - void declaration
     */
    public static final void validateRuntime(@NotNull Project $this$validateRuntime) {
        void $this$withType$iv;
        Intrinsics.checkNotNullParameter((Object)$this$validateRuntime, (String)"<this>");
        GradleVersion gradleVersion = GradleVersion.current();
        Intrinsics.checkNotNullExpressionValue((Object)gradleVersion, (String)"current()");
        GradleVersion gradleVersion2 = MinDepsKt.getMIN_GRADLE_VERSION();
        Intrinsics.checkNotNullExpressionValue((Object)gradleVersion2, (String)"MIN_GRADLE_VERSION");
        new GradleRuntimeValidator(gradleVersion, gradleVersion2).validate();
        PluginContainer pluginContainer = $this$validateRuntime.getPlugins();
        Intrinsics.checkNotNullExpressionValue((Object)pluginContainer, (String)"plugins");
        DomainObjectCollection domainObjectCollection = (DomainObjectCollection)pluginContainer;
        Function1 configuration$iv = (Function1)new Function1<AppPlugin, Unit>($this$validateRuntime){
            final /* synthetic */ Project $this_validateRuntime;
            {
                this.$this_validateRuntime = $receiver;
                super(1);
            }

            public final void invoke(@NotNull AppPlugin $this$withType) {
                Intrinsics.checkNotNullParameter((Object)$this$withType, (String)"$this$withType");
                ExtensionContainer extensionContainer = this.$this_validateRuntime.getExtensions();
                Intrinsics.checkNotNullExpressionValue((Object)extensionContainer, (String)"extensions");
                ExtensionContainer $this$findByType$iv = extensionContainer;
                boolean $i$f$findByType = false;
                boolean $i$f$typeOf = false;
                ApplicationAndroidComponentsExtension applicationAndroidComponentsExtension = (ApplicationAndroidComponentsExtension)$this$findByType$iv.findByType((TypeOf)new TypeOf<ApplicationAndroidComponentsExtension>(){});
                AndroidPluginVersion agpPluginVersion = applicationAndroidComponentsExtension != null ? applicationAndroidComponentsExtension.getPluginVersion() : null;
                new AgpRuntimeValidator(agpPluginVersion, MinDepsKt.getMIN_AGP_VERSION()).validate();
            }
        };
        boolean $i$f$withType = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$withType$iv.withType(AppPlugin.class, new Action(configuration$iv){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void execute(Object p0) {
                this.function.invoke(p0);
            }
        }), (String)"withType(S::class.java, configuration)");
    }

    public static final boolean validateDebuggability(@NotNull ApplicationVariant variant, @NotNull Logger logger) {
        ComponentCreationConfig hackToGetDebuggable;
        boolean isValid;
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        AnalyticsEnabledApplicationVariant analyticsEnabledApplicationVariant = variant instanceof AnalyticsEnabledApplicationVariant ? (AnalyticsEnabledApplicationVariant)variant : null;
        if (analyticsEnabledApplicationVariant == null || (analyticsEnabledApplicationVariant = analyticsEnabledApplicationVariant.getDelegate()) == null) {
            analyticsEnabledApplicationVariant = variant;
        }
        boolean bl = isValid = !(hackToGetDebuggable = (ComponentCreationConfig)analyticsEnabledApplicationVariant).getDebuggable();
        if (!isValid) {
            String typeName = variant.getBuildType();
            if (StringsKt.equals((String)typeName, (String)"release", (boolean)true)) {
                logger.error("GPP cannot configure variant '" + variant.getName() + "' because it is debuggable");
            } else {
                logger.info("Skipping debuggable build with type '" + typeName + "'");
            }
        }
        return isValid;
    }
}

