/*
 * Decompiled with CFR 0.152.
 */
package com.github.triplet.gradle.common.validation;

import com.android.build.api.AndroidPluginVersion;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/github/triplet/gradle/common/validation/AgpRuntimeValidator;", "", "currentAgpVersion", "Lcom/android/build/api/AndroidPluginVersion;", "minAgpVersion", "(Lcom/android/build/api/AndroidPluginVersion;Lcom/android/build/api/AndroidPluginVersion;)V", "validate", "", "validation"})
public final class AgpRuntimeValidator {
    @Nullable
    private final AndroidPluginVersion currentAgpVersion;
    @NotNull
    private final AndroidPluginVersion minAgpVersion;

    public AgpRuntimeValidator(@Nullable AndroidPluginVersion currentAgpVersion, @NotNull AndroidPluginVersion minAgpVersion) {
        Intrinsics.checkNotNullParameter((Object)minAgpVersion, (String)"minAgpVersion");
        this.currentAgpVersion = currentAgpVersion;
        this.minAgpVersion = minAgpVersion;
    }

    public final void validate() {
        if (!(this.currentAgpVersion != null && this.currentAgpVersion.compareTo(this.minAgpVersion) >= 0)) {
            boolean bl = false;
            AndroidPluginVersion androidPluginVersion = this.currentAgpVersion;
            String string = StringsKt.trimMargin$default((String)("\n            |Gradle Play Publisher's minimum Android Gradle Plugin version is at least\n            |" + this.minAgpVersion + " and yours is " + (androidPluginVersion != null ? (Comparable)androidPluginVersion : (Comparable)((Object)"unknown")) + ". Make sure you've applied\n            |the AGP alongside this plugin. Find the latest AGP version and upgrade\n            |instructions at https://developer.android.com/studio/releases/gradle-plugin.\n            |For GPP installation docs, see here:\n            |https://github.com/Triple-T/gradle-play-publisher#installation\n            "), null, (int)1, null);
            throw new IllegalStateException(string.toString());
        }
    }
}

