/*
 * Decompiled with CFR 0.152.
 */
package com.github.triplet.gradle.play.tasks.internal;

import com.github.triplet.gradle.androidpublisher.CommitResponse;
import com.github.triplet.gradle.androidpublisher.EditManager;
import com.github.triplet.gradle.androidpublisher.EditResponse;
import com.github.triplet.gradle.androidpublisher.PlayPublisher;
import com.github.triplet.gradle.common.utils.IoKt;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import javax.inject.Inject;
import kotlin.KotlinNothingValueException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.file.DeleteSpec;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationCompletionListener;
import org.gradle.tooling.events.task.TaskFailureResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b \u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004:\u00016B\u000f\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010&\u001a\u00020'J\b\u0010(\u001a\u00020'H\u0016J\u0006\u0010)\u001a\u00020'J\b\u0010*\u001a\u00020+H\u0002J\b\u0010,\u001a\u00020\u000eH\u0002J\u0010\u0010-\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020/H\u0002J\u0010\u00100\u001a\u00020'2\u0006\u00101\u001a\u000202H\u0016J\u0006\u00103\u001a\u00020'J\u0006\u00104\u001a\u00020'J\u0006\u00105\u001a\u00020'R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001b\u0010\u0017\u001a\u00020\u00188FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001d\u001a\u00020\u001e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\u001c\u001a\u0004\b\u001f\u0010 R\u0011\u0010\"\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\fR\u0011\u0010$\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\f\u00a8\u00067"}, d2={"Lcom/github/triplet/gradle/play/tasks/internal/PlayApiService;", "Lorg/gradle/api/services/BuildService;", "Lcom/github/triplet/gradle/play/tasks/internal/PlayApiService$Params;", "Lorg/gradle/tooling/events/OperationCompletionListener;", "Ljava/lang/AutoCloseable;", "fileOps", "Lorg/gradle/api/file/FileSystemOperations;", "(Lorg/gradle/api/file/FileSystemOperations;)V", "<set-?>", "", "buildFailed", "getBuildFailed", "()Z", "editId", "", "getEditId", "()Ljava/lang/String;", "editIdFile", "Ljava/io/File;", "editIdFileAndFriends", "", "getEditIdFileAndFriends", "()Ljava/util/List;", "edits", "Lcom/github/triplet/gradle/androidpublisher/EditManager;", "getEdits", "()Lcom/github/triplet/gradle/androidpublisher/EditManager;", "edits$delegate", "Lkotlin/Lazy;", "publisher", "Lcom/github/triplet/gradle/androidpublisher/PlayPublisher;", "getPublisher", "()Lcom/github/triplet/gradle/androidpublisher/PlayPublisher;", "publisher$delegate", "shouldCommit", "getShouldCommit", "shouldSkip", "getShouldSkip", "cleanup", "", "close", "commit", "credentialStream", "Ljava/io/InputStream;", "getOrCreateEditId", "handleFailure", "response", "Lcom/github/triplet/gradle/androidpublisher/EditResponse$Failure;", "onFinish", "event", "Lorg/gradle/tooling/events/FinishEvent;", "scheduleCommit", "skipCommit", "validate", "Params", "play-publisher"})
public abstract class PlayApiService
implements BuildService<Params>,
OperationCompletionListener,
AutoCloseable {
    @NotNull
    private final FileSystemOperations fileOps;
    @NotNull
    private final Lazy publisher$delegate;
    @NotNull
    private final Lazy edits$delegate;
    @NotNull
    private final File editIdFile;
    private boolean buildFailed;

    @Inject
    public PlayApiService(@NotNull FileSystemOperations fileOps) {
        Intrinsics.checkNotNullParameter((Object)fileOps, (String)"fileOps");
        this.fileOps = fileOps;
        this.publisher$delegate = LazyKt.lazy((Function0)((Function0)new Function0<PlayPublisher>(this){
            final /* synthetic */ PlayApiService this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public final PlayPublisher invoke() {
                PlayPublisher playPublisher;
                boolean useExplicitCreds;
                Object object = ((Params)this.this$0.getParameters()).getUseApplicationDefaultCredentials().getOrElse((Object)false);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.useApplicatio\u2026dentials.getOrElse(false)");
                boolean useAppDefaultCreds = (Boolean)object;
                boolean bl = useExplicitCreds = ((Params)this.this$0.getParameters()).getCredentials().isPresent() || System.getenv("ANDROID_PUBLISHER_CREDENTIALS") != null;
                if (useAppDefaultCreds && useExplicitCreds) {
                    throw new IllegalStateException("Cannot use both application default credentials and explicit credentials.\nPlease read our docs for more details:\nhttps://github.com/Triple-T/gradle-play-publisher#authenticating-gradle-play-publisher".toString());
                }
                if (useExplicitCreds && ((Params)this.this$0.getParameters()).getImpersonateServiceAccount().isPresent()) {
                    throw new IllegalStateException("Service Account impersonation with explicit credentials is currently not supported.\nPlease read our docs for more details:\nhttps://github.com/Triple-T/gradle-play-publisher#authenticating-gradle-play-publisher".toString());
                }
                if (useAppDefaultCreds) {
                    Object object2 = ((Params)this.this$0.getParameters()).getAppId().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"parameters.appId.get()");
                    playPublisher = PlayPublisher.Companion.invoke((String)object2, (String)((Params)this.this$0.getParameters()).getImpersonateServiceAccount().getOrNull());
                } else {
                    Closeable closeable = PlayApiService.access$credentialStream(this.this$0);
                    PlayApiService playApiService = this.this$0;
                    Throwable throwable = null;
                    try {
                        InputStream it = (InputStream)closeable;
                        boolean bl2 = false;
                        Object object3 = ((Params)playApiService.getParameters()).getAppId().get();
                        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"parameters.appId.get()");
                        PlayPublisher playPublisher2 = PlayPublisher.Companion.invoke(it, (String)object3);
                        playPublisher = playPublisher2;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                return playPublisher;
            }
        }));
        this.edits$delegate = LazyKt.lazy((Function0)((Function0)new Function0<EditManager>(this){
            final /* synthetic */ PlayApiService this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EditManager invoke() {
                String editId = PlayApiService.access$getOrCreateEditId(this.this$0);
                FilesKt.writeText$default((File)IoKt.safeCreateNewFile((File)PlayApiService.access$getEditIdFile$p(this.this$0)), (String)editId, null, (int)2, null);
                return EditManager.Companion.invoke(this.this$0.getPublisher(), editId);
            }
        }));
        File file = ((RegularFile)((Params)this.getParameters()).getEditIdFile().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"parameters.editIdFile.get().asFile");
        this.editIdFile = file;
    }

    @NotNull
    public final PlayPublisher getPublisher() {
        Lazy lazy = this.publisher$delegate;
        return (PlayPublisher)lazy.getValue();
    }

    @NotNull
    public final EditManager getEdits() {
        Lazy lazy = this.edits$delegate;
        return (EditManager)lazy.getValue();
    }

    private final String getEditId() {
        return FilesKt.readText$default((File)this.editIdFile, null, (int)1, null);
    }

    private final List<File> getEditIdFileAndFriends() {
        Object[] objectArray = new File[]{this.editIdFile, IoKt.marked((File)this.editIdFile, (String)"commit"), IoKt.marked((File)this.editIdFile, (String)"skipped")};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public final boolean getBuildFailed() {
        return this.buildFailed;
    }

    public final void scheduleCommit() {
        IoKt.safeCreateNewFile((File)IoKt.marked((File)this.editIdFile, (String)"commit"));
    }

    public final boolean getShouldCommit() {
        return IoKt.marked((File)this.editIdFile, (String)"commit").exists();
    }

    public final void commit() {
        CommitResponse response = PlayPublisher.commitEdit$default((PlayPublisher)this.getPublisher(), (String)this.getEditId(), (boolean)false, (int)2, null);
        if (response instanceof CommitResponse.Failure) {
            if (((CommitResponse.Failure)response).failedToSendForReview()) {
                CommitResponse retryResponse = this.getPublisher().commitEdit(this.getEditId(), false);
                CommitResponse.Failure failure = retryResponse instanceof CommitResponse.Failure ? (CommitResponse.Failure)retryResponse : null;
                if (failure != null) {
                    failure.rethrow((CommitResponse.Failure)response);
                    throw new KotlinNothingValueException();
                }
            } else {
                CommitResponse.Failure.rethrow$default((CommitResponse.Failure)((CommitResponse.Failure)response), null, (int)1, null);
                throw new KotlinNothingValueException();
            }
        }
    }

    public final void skipCommit() {
        IoKt.safeCreateNewFile((File)IoKt.marked((File)this.editIdFile, (String)"skipped"));
    }

    public final boolean getShouldSkip() {
        return IoKt.marked((File)this.editIdFile, (String)"skipped").exists();
    }

    public final void validate() {
        this.getPublisher().validateEdit(this.getEditId());
    }

    public final void cleanup() {
        this.fileOps.delete(new Action(this){
            final /* synthetic */ PlayApiService this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(@NotNull DeleteSpec $this$delete) {
                Intrinsics.checkNotNullParameter((Object)$this$delete, (String)"$this$delete");
                Object[] objectArray = new Object[]{PlayApiService.access$getEditIdFileAndFriends(this.this$0)};
                $this$delete.delete(objectArray);
            }
        });
    }

    @Override
    public void close() {
        if (this.getShouldCommit()) {
            this.cleanup();
        }
    }

    public void onFinish(@NotNull FinishEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.buildFailed = this.buildFailed || event.getResult() instanceof TaskFailureResult;
    }

    private final String getOrCreateEditId() {
        String string;
        EditResponse editResponse;
        String string2;
        String string3;
        File file = IoKt.orNull((File)this.editIdFile);
        String string4 = IoKt.nullOrFull(file != null ? FilesKt.readText$default((File)file, null, (int)1, null) : null);
        if (string4 != null) {
            String it = string3 = string4;
            boolean bl = false;
            string2 = IoKt.marked((File)this.editIdFile, (String)"skipped").exists() ? string3 : null;
        } else {
            string2 = null;
        }
        String editId = string2;
        this.cleanup();
        if (editId == null) {
            editResponse = this.getPublisher().insertEdit();
        } else {
            IoKt.safeCreateNewFile((File)IoKt.marked((File)this.editIdFile, (String)"skipped"));
            editResponse = this.getPublisher().getEdit(editId);
        }
        EditResponse response = editResponse;
        string3 = response;
        if (string3 instanceof EditResponse.Success) {
            string = ((EditResponse.Success)response).getId();
        } else if (string3 instanceof EditResponse.Failure) {
            string = this.handleFailure((EditResponse.Failure)response);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    private final String handleFailure(EditResponse.Failure response) {
        Property<String> appId = ((Params)this.getParameters()).getAppId();
        if (response.isNewApp()) {
            response.rethrow(StringsKt.trimMargin$default((String)("\n                    |No application found for the package name '" + appId + "'. The first version of your\n                    |app must be uploaded via the Play Console.\n                "), null, (int)1, null));
            throw new KotlinNothingValueException();
        }
        if (response.isInvalidEdit()) {
            Logging.getLogger(PlayApiService.class).error("Failed to retrieve saved edit, regenerating.");
            return this.getOrCreateEditId();
        }
        if (response.isUnauthorized()) {
            response.rethrow("Service account not authenticated. See the README for instructions:\nhttps://github.com/Triple-T/gradle-play-publisher#service-account");
            throw new KotlinNothingValueException();
        }
        response.rethrow();
        throw new KotlinNothingValueException();
    }

    private final InputStream credentialStream() {
        File credsFile = (File)((Params)this.getParameters()).getCredentials().getAsFile().getOrNull();
        if (credsFile != null) {
            return new FileInputStream(credsFile);
        }
        String credsString = System.getenv("ANDROID_PUBLISHER_CREDENTIALS");
        if (credsString != null) {
            String string = credsString;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            return new ByteArrayInputStream(byArray);
        }
        throw new IllegalStateException("No credentials specified. Please read our docs for more details:\nhttps://github.com/Triple-T/gradle-play-publisher#authenticating-gradle-play-publisher".toString());
    }

    public static final /* synthetic */ List access$getEditIdFileAndFriends(PlayApiService $this) {
        return $this.getEditIdFileAndFriends();
    }

    public static final /* synthetic */ InputStream access$credentialStream(PlayApiService $this) {
        return $this.credentialStream();
    }

    public static final /* synthetic */ String access$getOrCreateEditId(PlayApiService $this) {
        return $this.getOrCreateEditId();
    }

    public static final /* synthetic */ File access$getEditIdFile$p(PlayApiService $this) {
        return $this.editIdFile;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001R\u001e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\f\u0012\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\bR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\bR\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\b\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0017\u00c0\u0006\u0001"}, d2={"Lcom/github/triplet/gradle/play/tasks/internal/PlayApiService$Params;", "Lorg/gradle/api/services/BuildServiceParameters;", "_extensionPriority", "Lorg/gradle/api/provider/Property;", "", "get_extensionPriority$annotations", "()V", "get_extensionPriority", "()Lorg/gradle/api/provider/Property;", "appId", "", "getAppId", "credentials", "Lorg/gradle/api/file/RegularFileProperty;", "getCredentials", "()Lorg/gradle/api/file/RegularFileProperty;", "editIdFile", "getEditIdFile", "impersonateServiceAccount", "getImpersonateServiceAccount", "useApplicationDefaultCredentials", "", "getUseApplicationDefaultCredentials", "play-publisher"})
    public static interface Params
    extends BuildServiceParameters {
        @NotNull
        public Property<String> getAppId();

        @NotNull
        public RegularFileProperty getCredentials();

        @NotNull
        public Property<Boolean> getUseApplicationDefaultCredentials();

        @NotNull
        public Property<String> getImpersonateServiceAccount();

        @NotNull
        public RegularFileProperty getEditIdFile();

        @NotNull
        public Property<Integer> get_extensionPriority();

        public static /* synthetic */ void get_extensionPriority$annotations() {
        }
    }
}

