/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi;

import gr.uom.java.xmi.decomposition.AbstractCodeFragment;
import gr.uom.java.xmi.diff.CodeRange;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;

public class LocationInfo {
    private String filePath;
    private int startOffset;
    private int endOffset;
    private int length;
    private int startLine;
    private int startColumn;
    private int endLine;
    private int endColumn;
    private CodeElementType codeElementType;

    public LocationInfo(CompilationUnit cu, String filePath, ASTNode node, CodeElementType codeElementType) {
        this.filePath = filePath;
        this.codeElementType = codeElementType;
        this.startOffset = node.getStartPosition();
        this.length = node.getLength();
        this.endOffset = this.startOffset + this.length;
        this.startLine = cu.getLineNumber(this.startOffset);
        this.endLine = cu.getLineNumber(this.endOffset);
        if (this.endLine == -1) {
            this.endLine = cu.getLineNumber(this.endOffset - 1);
        }
        this.startColumn = cu.getColumnNumber(this.startOffset);
        if (this.startColumn > 0) {
            ++this.startColumn;
        }
        this.endColumn = cu.getColumnNumber(this.endOffset);
        if (this.endColumn == -1) {
            this.endColumn = cu.getColumnNumber(this.endOffset - 1);
        }
        if (this.endColumn > 0) {
            ++this.endColumn;
        }
    }

    public String getFilePath() {
        return this.filePath;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public int getLength() {
        return this.length;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public CodeElementType getCodeElementType() {
        return this.codeElementType;
    }

    public CodeRange codeRange() {
        return new CodeRange(this.getFilePath(), this.getStartLine(), this.getEndLine(), this.getStartColumn(), this.getEndColumn(), this.getCodeElementType());
    }

    public boolean before(LocationInfo other) {
        return this.filePath.equals(other.filePath) && this.startOffset <= other.startOffset && this.endOffset <= other.startOffset;
    }

    public boolean subsumes(LocationInfo other) {
        return this.filePath.equals(other.filePath) && this.startOffset <= other.startOffset && this.endOffset >= other.endOffset;
    }

    public boolean subsumes(List<? extends AbstractCodeFragment> statements) {
        int subsumedStatements = 0;
        for (AbstractCodeFragment abstractCodeFragment : statements) {
            if (!this.subsumes(abstractCodeFragment.getLocationInfo())) continue;
            ++subsumedStatements;
        }
        return subsumedStatements == statements.size() && statements.size() > 0;
    }

    public boolean sameLine(LocationInfo other) {
        return this.filePath.equals(other.filePath) && this.startLine == other.startLine && this.endLine == other.endLine;
    }

    public boolean nextLine(LocationInfo other) {
        return this.filePath.equals(other.filePath) && this.startLine == other.endLine + 1;
    }

    public String toString() {
        return "line range:" + this.startLine + "-" + this.endLine;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.endColumn;
        result = 31 * result + this.endLine;
        result = 31 * result + this.endOffset;
        result = 31 * result + (this.filePath == null ? 0 : this.filePath.hashCode());
        result = 31 * result + this.length;
        result = 31 * result + this.startColumn;
        result = 31 * result + this.startLine;
        result = 31 * result + this.startOffset;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocationInfo other = (LocationInfo)obj;
        if (this.endColumn != other.endColumn) {
            return false;
        }
        if (this.endLine != other.endLine) {
            return false;
        }
        if (this.endOffset != other.endOffset) {
            return false;
        }
        if (this.filePath == null ? other.filePath != null : !this.filePath.equals(other.filePath)) {
            return false;
        }
        if (this.length != other.length) {
            return false;
        }
        if (this.startColumn != other.startColumn) {
            return false;
        }
        if (this.startLine != other.startLine) {
            return false;
        }
        return this.startOffset == other.startOffset;
    }

    public static enum CodeElementType {
        TYPE_DECLARATION,
        METHOD_DECLARATION,
        FIELD_DECLARATION,
        SINGLE_VARIABLE_DECLARATION,
        VARIABLE_DECLARATION_STATEMENT,
        VARIABLE_DECLARATION_EXPRESSION,
        VARIABLE_DECLARATION_INITIALIZER,
        ANONYMOUS_CLASS_DECLARATION,
        LAMBDA_EXPRESSION,
        LAMBDA_EXPRESSION_BODY,
        CLASS_INSTANCE_CREATION,
        ARRAY_CREATION,
        METHOD_INVOCATION,
        SUPER_METHOD_INVOCATION,
        TERNARY_OPERATOR_CONDITION,
        TERNARY_OPERATOR_THEN_EXPRESSION,
        TERNARY_OPERATOR_ELSE_EXPRESSION,
        LABELED_STATEMENT,
        FOR_STATEMENT("for"),
        FOR_STATEMENT_CONDITION,
        FOR_STATEMENT_INITIALIZER,
        FOR_STATEMENT_UPDATER,
        ENHANCED_FOR_STATEMENT("for"),
        ENHANCED_FOR_STATEMENT_PARAMETER_NAME,
        ENHANCED_FOR_STATEMENT_EXPRESSION,
        WHILE_STATEMENT("while"),
        WHILE_STATEMENT_CONDITION,
        IF_STATEMENT("if"),
        IF_STATEMENT_CONDITION,
        DO_STATEMENT("do"),
        DO_STATEMENT_CONDITION,
        SWITCH_STATEMENT("switch"),
        SWITCH_STATEMENT_CONDITION,
        SYNCHRONIZED_STATEMENT("synchronized"),
        SYNCHRONIZED_STATEMENT_EXPRESSION,
        TRY_STATEMENT("try"),
        TRY_STATEMENT_RESOURCE,
        CATCH_CLAUSE("catch"),
        CATCH_CLAUSE_EXCEPTION_NAME,
        EXPRESSION_STATEMENT,
        SWITCH_CASE,
        ASSERT_STATEMENT,
        RETURN_STATEMENT,
        THROW_STATEMENT,
        CONSTRUCTOR_INVOCATION,
        SUPER_CONSTRUCTOR_INVOCATION,
        BREAK_STATEMENT,
        CONTINUE_STATEMENT,
        EMPTY_STATEMENT,
        BLOCK("{"),
        FINALLY_BLOCK("finally"),
        TYPE,
        LIST_OF_STATEMENTS,
        ANNOTATION,
        SINGLE_MEMBER_ANNOTATION_VALUE,
        NORMAL_ANNOTATION_MEMBER_VALUE_PAIR,
        ENUM_CONSTANT_DECLARATION,
        JAVADOC,
        LINE_COMMENT,
        BLOCK_COMMENT,
        LAMBDA_EXPRESSION_PARAMETER,
        METHOD_REFERENCE,
        CREATION_REFERENCE,
        INITIALIZER,
        TYPE_PARAMETER;

        private String name;

        private CodeElementType() {
        }

        private CodeElementType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public CodeElementType setName(String name) {
            this.name = name;
            return this;
        }
    }
}

