/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi;

import gr.uom.java.xmi.LocationInfo;
import gr.uom.java.xmi.UMLAnnotation;
import gr.uom.java.xmi.UMLAnonymousClass;
import gr.uom.java.xmi.UMLAttribute;
import gr.uom.java.xmi.UMLClass;
import gr.uom.java.xmi.UMLClassMatcher;
import gr.uom.java.xmi.UMLComment;
import gr.uom.java.xmi.UMLEnumConstant;
import gr.uom.java.xmi.UMLInitializer;
import gr.uom.java.xmi.UMLOperation;
import gr.uom.java.xmi.UMLType;
import gr.uom.java.xmi.decomposition.AbstractCall;
import gr.uom.java.xmi.decomposition.AbstractCodeFragment;
import gr.uom.java.xmi.decomposition.VariableDeclaration;
import gr.uom.java.xmi.diff.CodeRange;
import gr.uom.java.xmi.diff.RenamePattern;
import gr.uom.java.xmi.diff.StringDistance;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.refactoringminer.util.PrefixSuffixUtils;

public abstract class UMLAbstractClass {
    protected LocationInfo locationInfo;
    protected String packageName;
    protected String name;
    protected List<UMLOperation> operations;
    protected List<UMLAttribute> attributes;
    protected List<UMLComment> comments;
    private List<UMLAnonymousClass> anonymousClassList;
    private Map<List<String>, Integer> operationIdentifierSignatureMap;
    private Map<String, VariableDeclaration> fieldDeclarationMap;
    private List<UMLInitializer> initializers;
    private UMLType superclass;
    private List<UMLType> implementedInterfaces;
    private List<String> importedTypes;
    private List<UMLAnnotation> annotations;
    private List<UMLEnumConstant> enumConstants;

    public UMLAbstractClass(String packageName, String name, LocationInfo locationInfo, List<String> importedTypes) {
        this.packageName = packageName;
        this.name = name;
        this.locationInfo = locationInfo;
        this.importedTypes = importedTypes;
        this.operations = new ArrayList<UMLOperation>();
        this.attributes = new ArrayList<UMLAttribute>();
        this.comments = new ArrayList<UMLComment>();
        this.anonymousClassList = new ArrayList<UMLAnonymousClass>();
        this.initializers = new ArrayList<UMLInitializer>();
        this.operationIdentifierSignatureMap = new LinkedHashMap<List<String>, Integer>();
        this.superclass = null;
        this.implementedInterfaces = new ArrayList<UMLType>();
        this.annotations = new ArrayList<UMLAnnotation>();
        this.enumConstants = new ArrayList<UMLEnumConstant>();
    }

    public List<UMLOperation> getOperationsWithOverrideAnnotation() {
        ArrayList<UMLOperation> operations = new ArrayList<UMLOperation>();
        for (UMLOperation operation : this.operations) {
            if (!operation.hasOverrideAnnotation() || operation.isConstructor() || operation.overridesObject()) continue;
            operations.add(operation);
        }
        return operations;
    }

    public List<UMLOperation> getOperationsWithoutOverrideAnnotation() {
        ArrayList<UMLOperation> operations = new ArrayList<UMLOperation>();
        for (UMLOperation operation : this.operations) {
            if (operation.hasOverrideAnnotation() || operation.isConstructor() || operation.overridesObject()) continue;
            operations.add(operation);
        }
        return operations;
    }

    public LocationInfo getLocationInfo() {
        return this.locationInfo;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void addOperation(UMLOperation operation) {
        this.operations.add(operation);
        List<String> signature = operation.getSignatureIdentifiers();
        if (this.operationIdentifierSignatureMap.containsKey(signature)) {
            this.operationIdentifierSignatureMap.put(signature, this.operationIdentifierSignatureMap.get(signature) + 1);
        } else {
            this.operationIdentifierSignatureMap.put(signature, 1);
        }
    }

    public void addAttribute(UMLAttribute attribute) {
        this.attributes.add(attribute);
    }

    public List<UMLOperation> getOperations() {
        return this.operations;
    }

    public List<UMLAttribute> getAttributes() {
        return this.attributes;
    }

    public List<UMLComment> getComments() {
        return this.comments;
    }

    public void addInitializer(UMLInitializer initializer) {
        this.initializers.add(initializer);
    }

    public List<UMLInitializer> getInitializers() {
        return this.initializers;
    }

    public UMLType getSuperclass() {
        return this.superclass;
    }

    public void setSuperclass(UMLType superclass) {
        this.superclass = superclass;
    }

    public void addImplementedInterface(UMLType implementedInterface) {
        this.implementedInterfaces.add(implementedInterface);
    }

    public List<UMLType> getImplementedInterfaces() {
        return this.implementedInterfaces;
    }

    public List<String> getImportedTypes() {
        return this.importedTypes;
    }

    public List<UMLAnnotation> getAnnotations() {
        return this.annotations;
    }

    public void addAnnotation(UMLAnnotation annotation) {
        this.annotations.add(annotation);
    }

    public boolean hasDeprecatedAnnotation() {
        for (UMLAnnotation annotation : this.annotations) {
            if (!annotation.getTypeName().equals("Deprecated")) continue;
            return true;
        }
        return false;
    }

    public void addEnumConstant(UMLEnumConstant enumConstant) {
        this.enumConstants.add(enumConstant);
    }

    public List<UMLEnumConstant> getEnumConstants() {
        return this.enumConstants;
    }

    public UMLEnumConstant containsEnumConstant(UMLEnumConstant otherEnumConstant) {
        ListIterator<UMLEnumConstant> enumConstantIt = this.enumConstants.listIterator();
        while (enumConstantIt.hasNext()) {
            UMLEnumConstant enumConstant = enumConstantIt.next();
            if (!enumConstant.equals(otherEnumConstant)) continue;
            return enumConstant;
        }
        return null;
    }

    public boolean implementsInterface(Set<UMLType> interfaces) {
        for (UMLType type : interfaces) {
            if (!this.implementedInterfaces.contains(type)) continue;
            return true;
        }
        return false;
    }

    public boolean extendsSuperclass(Set<UMLType> types) {
        for (UMLType type : types) {
            if (this.superclass == null || !this.superclass.equals(type)) continue;
            return true;
        }
        return false;
    }

    public boolean isSubTypeOf(UMLClass umlClass) {
        if (this.superclass != null && umlClass.getName().endsWith("." + this.superclass.getClassType())) {
            return true;
        }
        for (UMLType implementedInterface : this.implementedInterfaces) {
            if (!umlClass.getName().endsWith("." + implementedInterface.getClassType())) continue;
            return true;
        }
        return false;
    }

    public boolean importsType(String targetClass) {
        if (targetClass.startsWith(this.getPackageName())) {
            return true;
        }
        for (String importedType : this.getImportedTypes()) {
            String targetClassPackage;
            if (importedType.equals(targetClass) || importedType.startsWith(targetClass)) {
                return true;
            }
            if (!targetClass.contains(".") || !importedType.equals(targetClassPackage = targetClass.substring(0, targetClass.lastIndexOf(".")))) continue;
            return true;
        }
        return false;
    }

    public Map<String, VariableDeclaration> getFieldDeclarationMap() {
        if (this.fieldDeclarationMap == null) {
            this.fieldDeclarationMap = new LinkedHashMap<String, VariableDeclaration>();
            for (UMLAttribute attribute : this.attributes) {
                this.fieldDeclarationMap.put(attribute.getName(), attribute.getVariableDeclaration());
            }
        }
        return this.fieldDeclarationMap;
    }

    public boolean isInnerClass(UMLAbstractClass innerClass) {
        return this.getName().equals(innerClass.packageName);
    }

    public UMLOperation operationWithTheSameSignature(UMLOperation operation) {
        for (UMLOperation originalOperation : this.operations) {
            if (!originalOperation.equalSignature(operation)) continue;
            return originalOperation;
        }
        return null;
    }

    public boolean containsOperationWithTheSameSignature(UMLOperation operation) {
        for (UMLOperation originalOperation : this.operations) {
            if (!originalOperation.equalSignature(operation)) continue;
            return true;
        }
        return false;
    }

    public UMLOperation operationWithTheSameSignatureIgnoringChangedTypes(UMLOperation operation) {
        ArrayList<UMLOperation> matchingOperations = new ArrayList<UMLOperation>();
        for (UMLOperation originalOperation : this.operations) {
            boolean operationEmptyBody;
            boolean originalOperationEmptyBody;
            boolean matchesOperation = this.isInterface() || originalOperation.isNative() ? originalOperation.equalSignatureIgnoringChangedTypes(operation) : originalOperation.equalSignatureWithIdenticalNameIgnoringChangedTypes(operation);
            if (!matchesOperation || (originalOperationEmptyBody = originalOperation.getBody() == null || originalOperation.hasEmptyBody()) != (operationEmptyBody = operation.getBody() == null || operation.hasEmptyBody())) continue;
            matchingOperations.add(originalOperation);
        }
        if (matchingOperations.size() == 1) {
            return (UMLOperation)matchingOperations.get(0);
        }
        if (matchingOperations.size() > 1) {
            int minDistance = StringDistance.editDistance(((UMLOperation)matchingOperations.get(0)).toString(), operation.toString());
            UMLOperation matchingOperation = (UMLOperation)matchingOperations.get(0);
            for (int i = 1; i < matchingOperations.size(); ++i) {
                int distance = StringDistance.editDistance(((UMLOperation)matchingOperations.get(i)).toString(), operation.toString());
                if (distance >= minDistance) continue;
                minDistance = distance;
                matchingOperation = (UMLOperation)matchingOperations.get(i);
            }
            return matchingOperation;
        }
        return null;
    }

    public boolean containsOperationWithTheSameSignatureIgnoringChangedTypes(UMLOperation operation) {
        for (UMLOperation originalOperation : this.operations) {
            boolean operationEmptyBody;
            List<String> signature;
            Integer instances;
            if (!originalOperation.equalSignatureIgnoringChangedTypes(operation)) continue;
            if (!originalOperation.isConstructor() && !originalOperation.equalSignature(operation) && (instances = this.operationIdentifierSignatureMap.get(signature = originalOperation.getSignatureIdentifiers())) != null && instances > 1) {
                return false;
            }
            boolean originalOperationEmptyBody = originalOperation.getBody() == null || originalOperation.hasEmptyBody();
            if (originalOperationEmptyBody != (operationEmptyBody = operation.getBody() == null || operation.hasEmptyBody())) continue;
            return true;
        }
        return false;
    }

    public boolean containsOperationWithTheSameName(UMLOperation operation) {
        for (UMLOperation originalOperation : this.operations) {
            if (!originalOperation.getName().equals(operation.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean containsOperationWithName(String name) {
        for (UMLOperation originalOperation : this.operations) {
            if (!originalOperation.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean containsOperationWithTheSameRenamePattern(UMLOperation operation, RenamePattern pattern) {
        if (pattern == null) {
            return false;
        }
        for (UMLOperation originalOperation : this.operations) {
            String originalOperationNameAfterReplacement;
            String originalOperationName = originalOperation.getName();
            if (!originalOperationName.contains(pattern.getBefore()) || !(originalOperationNameAfterReplacement = originalOperationName.replace(pattern.getBefore(), pattern.getAfter())).equals(operation.getName())) continue;
            return true;
        }
        return false;
    }

    public UMLOperation operationWithTheSameRenamePattern(UMLOperation operation, RenamePattern pattern) {
        if (pattern == null) {
            return null;
        }
        for (UMLOperation originalOperation : this.operations) {
            String originalOperationNameAfterReplacement;
            String originalOperationName = originalOperation.getName();
            if (!originalOperationName.contains(pattern.getBefore()) || !(originalOperationNameAfterReplacement = originalOperationName.replace(pattern.getBefore(), pattern.getAfter())).equals(operation.getName())) continue;
            return originalOperation;
        }
        return null;
    }

    public boolean containsOperationWithIdenticalBody(UMLOperation operation) {
        if (operation.getBody() != null) {
            for (UMLOperation originalOperation : this.operations) {
                if (originalOperation.getBody() == null || originalOperation.getBodyHashCode() != operation.getBodyHashCode()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean containsSingleStatementWithRenamedCall(UMLAbstractClass umlClass, UMLOperation operation2) {
        if (operation2.stringRepresentation().size() == 3) {
            for (UMLOperation operation1 : this.operations) {
                if (operation1.stringRepresentation().size() != 3) continue;
                List<AbstractCodeFragment> leaves2 = operation2.getBody().getCompositeStatement().getLeaves();
                List<AbstractCodeFragment> leaves1 = operation1.getBody().getCompositeStatement().getLeaves();
                if (leaves2.size() != 1 || leaves1.size() != 1) continue;
                AbstractCodeFragment leaf2 = leaves2.get(0);
                AbstractCodeFragment leaf1 = leaves1.get(0);
                AbstractCall invocation1 = leaf1.invocationCoveringEntireFragment();
                AbstractCall invocation2 = leaf2.invocationCoveringEntireFragment();
                if (invocation1 == null || invocation2 == null || !invocation1.equalArguments(invocation2) || !invocation1.identicalExpression(invocation2) || !this.containsOperationWithName(invocation1.getName()) || !umlClass.containsOperationWithName(invocation2.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public UMLAttribute attributeWithTheSameNameIgnoringChangedType(UMLAttribute attribute) {
        for (UMLAttribute originalAttribute : this.attributes) {
            if (!originalAttribute.equalsIgnoringChangedType(attribute)) continue;
            return originalAttribute;
        }
        return null;
    }

    public UMLAttribute attributeWithTheSameSignature(UMLAttribute attribute) {
        for (UMLAttribute originalAttribute : this.attributes) {
            if (!originalAttribute.equalsIgnoringChangedVisibility(attribute)) continue;
            return originalAttribute;
        }
        return null;
    }

    public boolean containsIdenticalAttributeIncludingAnnotation(UMLAttribute attribute) {
        for (UMLAttribute originalAttribute : this.attributes) {
            if (!originalAttribute.identicalIncludingAnnotation(attribute)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAttributeWithTheSameNameIgnoringChangedType(UMLAttribute attribute) {
        for (UMLAttribute originalAttribute : this.attributes) {
            if (!originalAttribute.equalsIgnoringChangedType(attribute)) continue;
            return true;
        }
        return false;
    }

    public boolean containsRenamedAttributeWithIdenticalTypeAndInitializer(UMLAttribute attribute) {
        for (UMLAttribute originalAttribute : this.attributes) {
            if (!originalAttribute.renamedWithIdenticalTypeAndInitializer(attribute)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAttributeWithTheSameName(UMLAttribute attribute) {
        for (UMLAttribute originalAttribute : this.attributes) {
            if (!originalAttribute.getName().equals(attribute.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean containsAttributeWithTheSameRenamePattern(UMLAttribute attribute, RenamePattern pattern) {
        if (pattern == null) {
            return false;
        }
        for (UMLAttribute originalAttribute : this.attributes) {
            String originalAttributeNameAfterReplacement;
            String originalAttributeName = originalAttribute.getName();
            if (!originalAttributeName.contains(pattern.getBefore()) || !(originalAttributeNameAfterReplacement = originalAttributeName.replace(pattern.getBefore(), pattern.getAfter())).equals(attribute.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean containsAttributeWithName(String attributeName) {
        for (UMLAttribute originalAttribute : this.attributes) {
            if (!originalAttribute.getName().equals(attributeName)) continue;
            return true;
        }
        return false;
    }

    public UMLClassMatcher.MatchResult hasAttributesAndOperationsWithCommonNames(UMLAbstractClass umlClass) {
        ArrayList<UMLOperation> commonOperations = new ArrayList<UMLOperation>();
        int totalOperations = 0;
        for (UMLOperation operation : this.operations) {
            if (operation.isConstructor() || operation.overridesObject()) continue;
            ++totalOperations;
            if (!umlClass.containsOperationWithTheSameName(operation)) continue;
            commonOperations.add(operation);
        }
        for (UMLOperation operation : umlClass.operations) {
            if (operation.isConstructor() || operation.overridesObject()) continue;
            ++totalOperations;
            if (!this.containsOperationWithTheSameName(operation)) continue;
            commonOperations.add(operation);
        }
        ArrayList<UMLAttribute> commonAttributes = new ArrayList<UMLAttribute>();
        int totalAttributes = 0;
        for (UMLAttribute attribute : this.attributes) {
            ++totalAttributes;
            if (!umlClass.containsAttributeWithTheSameName(attribute)) continue;
            commonAttributes.add(attribute);
        }
        for (UMLAttribute attribute : umlClass.attributes) {
            ++totalAttributes;
            if (!this.containsAttributeWithTheSameName(attribute)) continue;
            commonAttributes.add(attribute);
        }
        if (this.isTestClass() && umlClass.isTestClass()) {
            if ((double)commonOperations.size() > Math.floor((double)totalOperations / 2.0) || commonOperations.containsAll(this.operations)) {
                return new UMLClassMatcher.MatchResult(commonOperations.size(), commonAttributes.size(), totalOperations, totalAttributes, true);
            }
            return new UMLClassMatcher.MatchResult(commonOperations.size(), commonAttributes.size(), totalOperations, totalAttributes, false);
        }
        if (this.isSingleAbstractMethodInterface() && umlClass.isSingleAbstractMethodInterface()) {
            if (commonOperations.size() == totalOperations) {
                return new UMLClassMatcher.MatchResult(commonOperations.size(), commonAttributes.size(), totalOperations, totalAttributes, true);
            }
            return new UMLClassMatcher.MatchResult(commonOperations.size(), commonAttributes.size(), totalOperations, totalAttributes, false);
        }
        if ((double)commonOperations.size() >= Math.floor((double)totalOperations / 2.0) && (commonAttributes.size() > 2 || totalAttributes == 0) || (double)commonAttributes.size() >= Math.floor((double)totalAttributes / 2.0) && (commonOperations.size() > 2 || totalOperations == 0) || commonOperations.size() == totalOperations && commonOperations.size() > 2 && this.attributes.size() == umlClass.attributes.size() || commonOperations.size() == totalOperations && commonOperations.size() > 2 && totalAttributes == 1) {
            return new UMLClassMatcher.MatchResult(commonOperations.size(), commonAttributes.size(), totalOperations, totalAttributes, true);
        }
        return new UMLClassMatcher.MatchResult(commonOperations.size(), commonAttributes.size(), totalOperations, totalAttributes, false);
    }

    public UMLClassMatcher.MatchResult hasCommonAttributesAndOperations(UMLAbstractClass umlClass) {
        int abstractOperationsToBeDeducted;
        String commonPrefix = PrefixSuffixUtils.longestCommonPrefix(this.name, umlClass.name);
        String commonSuffix = PrefixSuffixUtils.longestCommonSuffix(this.name, umlClass.name);
        RenamePattern pattern = null;
        if (!commonPrefix.isEmpty() && !commonSuffix.isEmpty()) {
            int endIndexS1;
            int beginIndexS1 = this.name.indexOf(commonPrefix) + commonPrefix.length();
            String diff1 = beginIndexS1 > (endIndexS1 = this.name.lastIndexOf(commonSuffix)) ? "" : this.name.substring(beginIndexS1, endIndexS1);
            int beginIndexS2 = umlClass.name.indexOf(commonPrefix) + commonPrefix.length();
            int endIndexS2 = umlClass.name.lastIndexOf(commonSuffix);
            String diff2 = beginIndexS2 > endIndexS2 ? "" : umlClass.name.substring(beginIndexS2, endIndexS2);
            pattern = new RenamePattern(diff1, diff2);
        }
        ArrayList<UMLOperation> commonOperations = new ArrayList<UMLOperation>();
        ArrayList<UMLOperation> identicalOperations = new ArrayList<UMLOperation>();
        int totalOperations = 0;
        int totalAbstractOperations = 0;
        for (UMLOperation operation : this.operations) {
            if (!operation.isConstructor() && !operation.overridesObject()) {
                ++totalOperations;
                if (operation.isAbstract()) {
                    ++totalAbstractOperations;
                }
                if (umlClass.containsOperationWithTheSameSignatureIgnoringChangedTypes(operation) || pattern != null && umlClass.containsOperationWithTheSameRenamePattern(operation, pattern.reverse())) {
                    commonOperations.add(operation);
                }
                if (!umlClass.containsOperationWithIdenticalBody(operation) && !umlClass.containsSingleStatementWithRenamedCall(this, operation)) continue;
                identicalOperations.add(operation);
                continue;
            }
            if (operation.isConstructor() && commonPrefix.equals(commonSuffix) && commonPrefix.length() > 0) {
                if (!umlClass.containsOperationWithTheSameSignatureIgnoringChangedTypes(operation) && (pattern == null || !umlClass.containsOperationWithTheSameRenamePattern(operation, pattern.reverse()))) continue;
                commonOperations.add(operation);
                continue;
            }
            if (!operation.isConstructor() || !commonPrefix.isEmpty() || !commonSuffix.equals(this.name) || !umlClass.containsOperationWithTheSameSignatureIgnoringChangedTypes(operation) && (pattern == null || !umlClass.containsOperationWithTheSameRenamePattern(operation, pattern.reverse()))) continue;
            commonOperations.add(operation);
        }
        for (UMLOperation operation : umlClass.operations) {
            if (!operation.isConstructor() && !operation.overridesObject()) {
                ++totalOperations;
                if (operation.isAbstract()) {
                    ++totalAbstractOperations;
                }
                if (this.containsOperationWithTheSameSignatureIgnoringChangedTypes(operation) || pattern != null && this.containsOperationWithTheSameRenamePattern(operation, pattern)) {
                    commonOperations.add(operation);
                }
                if (!this.containsOperationWithIdenticalBody(operation) && !this.containsSingleStatementWithRenamedCall(umlClass, operation)) continue;
                identicalOperations.add(operation);
                continue;
            }
            if (operation.isConstructor() && commonPrefix.equals(commonSuffix) && commonPrefix.length() > 0) {
                if (!this.containsOperationWithTheSameSignatureIgnoringChangedTypes(operation) && (pattern == null || !this.containsOperationWithTheSameRenamePattern(operation, pattern))) continue;
                commonOperations.add(operation);
                continue;
            }
            if (!operation.isConstructor() || !commonPrefix.isEmpty() || !commonSuffix.equals(this.name) || !this.containsOperationWithTheSameSignatureIgnoringChangedTypes(operation) && (pattern == null || !this.containsOperationWithTheSameRenamePattern(operation, pattern))) continue;
            commonOperations.add(operation);
        }
        ArrayList<UMLAttribute> commonAttributes = new ArrayList<UMLAttribute>();
        ArrayList<UMLAttribute> identicalAttributes = new ArrayList<UMLAttribute>();
        int totalAttributes = 0;
        for (UMLAttribute attribute : this.attributes) {
            ++totalAttributes;
            if (!umlClass.containsAttributeWithTheSameNameIgnoringChangedType(attribute) && !umlClass.containsRenamedAttributeWithIdenticalTypeAndInitializer(attribute) && (pattern == null || !umlClass.containsAttributeWithTheSameRenamePattern(attribute, pattern.reverse()))) continue;
            commonAttributes.add(attribute);
            if (!umlClass.containsIdenticalAttributeIncludingAnnotation(attribute)) continue;
            identicalAttributes.add(attribute);
        }
        for (UMLAttribute attribute : umlClass.attributes) {
            ++totalAttributes;
            if (!this.containsAttributeWithTheSameNameIgnoringChangedType(attribute) && !this.containsRenamedAttributeWithIdenticalTypeAndInitializer(attribute) && (pattern == null || !this.containsAttributeWithTheSameRenamePattern(attribute, pattern))) continue;
            commonAttributes.add(attribute);
            if (!this.containsIdenticalAttributeIncludingAnnotation(attribute)) continue;
            identicalAttributes.add(attribute);
        }
        if (this.isTestClass() && umlClass.isTestClass()) {
            if ((double)commonOperations.size() > Math.floor((double)totalOperations / 2.0) || commonOperations.containsAll(this.operations)) {
                return new UMLClassMatcher.MatchResult(commonOperations.size(), commonAttributes.size(), totalOperations, totalAttributes, true);
            }
            return new UMLClassMatcher.MatchResult(commonOperations.size(), commonAttributes.size(), totalOperations, totalAttributes, false);
        }
        if (this.isSingleAbstractMethodInterface() && umlClass.isSingleAbstractMethodInterface()) {
            if (commonOperations.size() == totalOperations) {
                return new UMLClassMatcher.MatchResult(commonOperations.size(), commonAttributes.size(), totalOperations, totalAttributes, true);
            }
            return new UMLClassMatcher.MatchResult(commonOperations.size(), commonAttributes.size(), totalOperations, totalAttributes, false);
        }
        if (this.isSingleMethodClass() && umlClass.isSingleMethodClass() && this.getNonQualifiedName().equals(umlClass.getNonQualifiedName()) && commonOperations.size() >= totalOperations) {
            return new UMLClassMatcher.MatchResult(commonOperations.size(), commonAttributes.size(), totalOperations, totalAttributes, true);
        }
        if (this.isSingleAbstractMethodInterface() || umlClass.isSingleAbstractMethodInterface()) {
            if (commonOperations.size() == 2) {
                return new UMLClassMatcher.MatchResult(commonOperations.size(), commonAttributes.size(), totalOperations, totalAttributes, true);
            }
            return new UMLClassMatcher.MatchResult(commonOperations.size(), commonAttributes.size(), totalOperations, totalAttributes, false);
        }
        if (this.isInterface() && umlClass.isInterface() && (double)commonOperations.size() > Math.floor((double)totalOperations / 2.0)) {
            return new UMLClassMatcher.MatchResult(commonOperations.size(), commonAttributes.size(), totalOperations, totalAttributes, true);
        }
        int n = abstractOperationsToBeDeducted = this.isAbstract() != umlClass.isAbstract() ? totalAbstractOperations : 0;
        if ((double)commonOperations.size() > Math.floor((double)totalOperations / 2.0) && (commonAttributes.size() > 2 || totalAttributes == 0) || (double)commonOperations.size() > Math.floor((double)totalOperations / 3.0 * 2.0) && (commonAttributes.size() >= 2 || totalAttributes == 0) || identicalOperations.size() >= commonOperations.size() && commonOperations.size() > 2 && (double)identicalOperations.size() >= Math.floor((double)(totalOperations - abstractOperationsToBeDeducted) / 3.0 * 2.0) || (double)commonAttributes.size() > Math.floor((double)totalAttributes / 2.0) && (commonOperations.size() > 2 || totalOperations == 0) || commonOperations.size() == totalOperations && commonOperations.size() > 2 && this.attributes.size() == umlClass.attributes.size() || commonOperations.size() == totalOperations && commonOperations.size() > 2 && totalAttributes == 1 || identicalAttributes.size() == totalAttributes && totalAttributes > 0) {
            return new UMLClassMatcher.MatchResult(commonOperations.size(), commonAttributes.size(), totalOperations, totalAttributes, true);
        }
        LinkedHashSet<UMLOperation> unmatchedOperations = new LinkedHashSet<UMLOperation>(umlClass.operations);
        unmatchedOperations.removeAll(commonOperations);
        LinkedHashSet<UMLOperation> unmatchedCalledOperations = new LinkedHashSet<UMLOperation>();
        for (UMLOperation operation : umlClass.operations) {
            if (!commonOperations.contains(operation)) continue;
            block5: for (AbstractCall invocation : operation.getAllOperationInvocations()) {
                for (UMLOperation unmatchedOperation : unmatchedOperations) {
                    if (!invocation.matchesOperation(unmatchedOperation, operation, null)) continue;
                    unmatchedCalledOperations.add(unmatchedOperation);
                    continue block5;
                }
            }
        }
        if ((double)(commonOperations.size() + unmatchedCalledOperations.size()) > Math.floor((double)totalOperations / 2.0) && (commonAttributes.size() > 2 || totalAttributes == 0)) {
            return new UMLClassMatcher.MatchResult(commonOperations.size() + unmatchedCalledOperations.size(), commonAttributes.size(), totalOperations, totalAttributes, true);
        }
        if (unmatchedOperations.size() == 0 && (double)commonOperations.size() > Math.floor((double)totalOperations / 3.0 * 2.0)) {
            return new UMLClassMatcher.MatchResult(commonOperations.size(), commonAttributes.size(), totalOperations, totalAttributes, true);
        }
        return new UMLClassMatcher.MatchResult(commonOperations.size(), commonAttributes.size(), totalOperations, totalAttributes, false);
    }

    public UMLClassMatcher.MatchResult hasSameAttributesAndOperations(UMLAbstractClass umlClass) {
        ArrayList<UMLOperation> commonOperations = new ArrayList<UMLOperation>();
        int totalOperations = 0;
        for (UMLOperation operation : this.operations) {
            ++totalOperations;
            if (!umlClass.containsOperationWithTheSameSignatureIgnoringChangedTypes(operation)) continue;
            commonOperations.add(operation);
        }
        for (UMLOperation operation : umlClass.operations) {
            ++totalOperations;
            if (!this.containsOperationWithTheSameSignatureIgnoringChangedTypes(operation)) continue;
            commonOperations.add(operation);
        }
        ArrayList<UMLAttribute> commonAttributes = new ArrayList<UMLAttribute>();
        int totalAttributes = 0;
        for (UMLAttribute attribute : this.attributes) {
            ++totalAttributes;
            if (!umlClass.containsAttributeWithTheSameNameIgnoringChangedType(attribute)) continue;
            commonAttributes.add(attribute);
        }
        for (UMLAttribute attribute : umlClass.attributes) {
            ++totalAttributes;
            if (!this.containsAttributeWithTheSameNameIgnoringChangedType(attribute)) continue;
            commonAttributes.add(attribute);
        }
        if (commonOperations.size() == totalOperations && commonAttributes.size() == totalAttributes) {
            return new UMLClassMatcher.MatchResult(commonOperations.size(), commonAttributes.size(), totalOperations, totalAttributes, true);
        }
        return new UMLClassMatcher.MatchResult(commonOperations.size(), commonAttributes.size(), totalOperations, totalAttributes, false);
    }

    public UMLClassMatcher.MatchResult hasCommonOperationWithTheSameSignature(UMLAbstractClass umlClass) {
        ArrayList<UMLOperation> commonOperations = new ArrayList<UMLOperation>();
        int totalOperations = 0;
        for (UMLOperation operation : this.operations) {
            if (operation.isConstructor() || operation.overridesObject()) continue;
            ++totalOperations;
            if (!umlClass.containsOperationWithTheSameSignature(operation)) continue;
            commonOperations.add(operation);
        }
        for (UMLOperation operation : umlClass.operations) {
            if (operation.isConstructor() || operation.overridesObject()) continue;
            ++totalOperations;
            if (!this.containsOperationWithTheSameSignature(operation)) continue;
            commonOperations.add(operation);
        }
        if (commonOperations.size() > 2) {
            return new UMLClassMatcher.MatchResult(commonOperations.size(), 0, totalOperations, 0, true);
        }
        return new UMLClassMatcher.MatchResult(commonOperations.size(), 0, totalOperations, 0, false);
    }

    public boolean isTestClass() {
        for (UMLOperation operation : this.operations) {
            if (!operation.hasTestAnnotation()) continue;
            return true;
        }
        return false;
    }

    public List<UMLAttribute> attributesOfType(String targetClass) {
        ArrayList<UMLAttribute> attributesOfType = new ArrayList<UMLAttribute>();
        for (UMLAttribute attribute : this.attributes) {
            if (!targetClass.endsWith("." + attribute.getType().getClassType()) && !targetClass.equals(attribute.getType().getClassType())) continue;
            attributesOfType.add(attribute);
        }
        return attributesOfType;
    }

    public UMLAttribute containsAttribute(UMLAttribute otherAttribute) {
        ListIterator<UMLAttribute> attributeIt = this.attributes.listIterator();
        while (attributeIt.hasNext()) {
            UMLAttribute attribute = attributeIt.next();
            if (!attribute.equals(otherAttribute)) continue;
            return attribute;
        }
        return null;
    }

    public UMLAttribute matchAttribute(UMLAttribute otherAttribute) {
        ListIterator<UMLAttribute> attributeIt = this.attributes.listIterator();
        while (attributeIt.hasNext()) {
            UMLAttribute attribute = attributeIt.next();
            if (!attribute.getName().equals(otherAttribute.getName())) continue;
            String thisAttributeType = attribute.getType().getClassType();
            String otherAttributeType = otherAttribute.getType().getClassType();
            int thisArrayDimension = attribute.getType().getArrayDimension();
            int otherArrayDimension = otherAttribute.getType().getArrayDimension();
            String thisAttributeTypeComparedString = null;
            thisAttributeTypeComparedString = thisAttributeType.contains(".") ? thisAttributeType.substring(thisAttributeType.lastIndexOf(".") + 1) : thisAttributeType;
            String otherAttributeTypeComparedString = null;
            otherAttributeTypeComparedString = otherAttributeType.contains(".") ? otherAttributeType.substring(otherAttributeType.lastIndexOf(".") + 1) : otherAttributeType;
            if (!thisAttributeTypeComparedString.equals(otherAttributeTypeComparedString) || thisArrayDimension != otherArrayDimension) continue;
            return attribute;
        }
        return null;
    }

    public abstract boolean isSingleAbstractMethodInterface();

    public abstract boolean isSingleMethodClass();

    public abstract boolean isInterface();

    public abstract String getName();

    public abstract boolean isAbstract();

    public abstract String getTypeDeclarationKind();

    public abstract boolean isFinal();

    public abstract boolean isStatic();

    public abstract boolean isTopLevel();

    public abstract String getVisibility();

    public String getNonQualifiedName() {
        return this.name;
    }

    public String getSourceFile() {
        return this.locationInfo.getFilePath();
    }

    public CodeRange codeRange() {
        return this.locationInfo.codeRange();
    }

    public Map<String, Set<String>> aliasedAttributes() {
        for (UMLOperation operation : this.getOperations()) {
            Map<String, Set<String>> aliased;
            if (!operation.isConstructor() || (aliased = operation.aliasedAttributes()).isEmpty()) continue;
            return aliased;
        }
        return new LinkedHashMap<String, Set<String>>();
    }

    public void addAnonymousClass(UMLAnonymousClass anonymousClass) {
        this.anonymousClassList.add(anonymousClass);
    }

    public List<UMLAnonymousClass> getAnonymousClassList() {
        return this.anonymousClassList;
    }

    public boolean containsAnonymousWithSameAttributesAndOperations(UMLAnonymousClass anonymous) {
        for (UMLAnonymousClass thisAnonymous : this.anonymousClassList) {
            UMLClassMatcher.MatchResult matchResult = thisAnonymous.hasSameAttributesAndOperations(anonymous);
            if (!matchResult.isMatch()) continue;
            return true;
        }
        return false;
    }
}

