/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi;

import gr.uom.java.xmi.LocationInfo;
import gr.uom.java.xmi.LocationInfoProvider;
import gr.uom.java.xmi.decomposition.AbstractExpression;
import gr.uom.java.xmi.diff.CodeRange;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;

public class UMLAnnotation
implements Serializable,
LocationInfoProvider {
    private LocationInfo locationInfo;
    private String typeName;
    private AbstractExpression value;
    private Map<String, AbstractExpression> memberValuePairs = new LinkedHashMap<String, AbstractExpression>();

    public UMLAnnotation(CompilationUnit cu, String filePath, Annotation annotation) {
        this.typeName = annotation.getTypeName().getFullyQualifiedName();
        this.locationInfo = new LocationInfo(cu, filePath, (ASTNode)annotation, LocationInfo.CodeElementType.ANNOTATION);
        if (annotation instanceof SingleMemberAnnotation) {
            SingleMemberAnnotation singleMemberAnnotation = (SingleMemberAnnotation)annotation;
            this.value = new AbstractExpression(cu, filePath, singleMemberAnnotation.getValue(), LocationInfo.CodeElementType.SINGLE_MEMBER_ANNOTATION_VALUE, null);
        } else if (annotation instanceof NormalAnnotation) {
            NormalAnnotation normalAnnotation = (NormalAnnotation)annotation;
            List pairs = normalAnnotation.values();
            for (MemberValuePair pair : pairs) {
                AbstractExpression value = new AbstractExpression(cu, filePath, pair.getValue(), LocationInfo.CodeElementType.NORMAL_ANNOTATION_MEMBER_VALUE_PAIR, null);
                this.memberValuePairs.put(pair.getName().getIdentifier(), value);
            }
        }
    }

    public String getTypeName() {
        return this.typeName;
    }

    public AbstractExpression getValue() {
        return this.value;
    }

    public Map<String, AbstractExpression> getMemberValuePairs() {
        return this.memberValuePairs;
    }

    public boolean isMarkerAnnotation() {
        return this.value == null && this.memberValuePairs.isEmpty();
    }

    public boolean isSingleMemberAnnotation() {
        return this.value != null;
    }

    public boolean isNormalAnnotation() {
        return this.memberValuePairs.size() > 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("@").append(this.typeName);
        if (this.value != null) {
            sb.append("(");
            sb.append(this.value.getExpression());
            sb.append(")");
        }
        if (!this.memberValuePairs.isEmpty()) {
            sb.append("(");
            int i = 0;
            for (String key : this.memberValuePairs.keySet()) {
                sb.append(key).append(" = ").append(this.memberValuePairs.get(key).getExpression());
                if (i < this.memberValuePairs.size() - 1) {
                    sb.append(", ");
                }
                ++i;
            }
            sb.append(")");
        }
        return sb.toString();
    }

    @Override
    public LocationInfo getLocationInfo() {
        return this.locationInfo;
    }

    @Override
    public CodeRange codeRange() {
        return this.locationInfo.codeRange();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.memberValuePairs == null ? 0 : this.memberValuePairsHashCode());
        result = 31 * result + (this.typeName == null ? 0 : this.typeName.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.getExpression().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UMLAnnotation other = (UMLAnnotation)obj;
        if (this.memberValuePairs == null ? other.memberValuePairs != null : !this.memberValuePairsEquals(other)) {
            return false;
        }
        if (this.typeName == null ? other.typeName != null : !this.typeName.equals(other.typeName)) {
            return false;
        }
        if (this.value == null) {
            if (other.value != null) {
                return false;
            }
        } else {
            if (other.value == null) {
                return false;
            }
            if (!this.value.getExpression().equals(other.value.getExpression())) {
                return false;
            }
        }
        return true;
    }

    private boolean memberValuePairsEquals(UMLAnnotation other) {
        int otherSize;
        Map<String, AbstractExpression> m = other.memberValuePairs;
        int thisSize = this.memberValuePairs.size();
        if (thisSize != (otherSize = other.memberValuePairs.size())) {
            return false;
        }
        for (Map.Entry<String, AbstractExpression> entry : this.memberValuePairs.entrySet()) {
            String thisKey = entry.getKey();
            AbstractExpression thisValue = entry.getValue();
            if (thisValue == null) {
                if (m.get(thisKey) == null && m.containsKey(thisKey)) continue;
                return false;
            }
            if (m.get(thisKey) == null) {
                return false;
            }
            if (thisValue.getExpression().equals(m.get(thisKey).getExpression())) continue;
            return false;
        }
        return true;
    }

    private int memberValuePairsHashCode() {
        int h = 0;
        for (Map.Entry<String, AbstractExpression> entry : this.memberValuePairs.entrySet()) {
            h += (entry.getKey() == null ? 0 : entry.getKey().hashCode()) ^ (entry.getValue() == null ? 0 : entry.getValue().getExpression().hashCode());
        }
        return h;
    }
}

