/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi;

import gr.uom.java.xmi.UMLClass;
import gr.uom.java.xmi.UMLClassMatcher;
import gr.uom.java.xmi.UMLGeneralization;
import gr.uom.java.xmi.UMLRealization;
import gr.uom.java.xmi.diff.UMLClassDiff;
import gr.uom.java.xmi.diff.UMLModelDiff;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.refactoringminer.api.RefactoringMinerTimedOutException;

public class UMLModel {
    private Set<String> repositoryDirectories;
    private List<UMLClass> classList;
    private List<UMLGeneralization> generalizationList;
    private List<UMLRealization> realizationList;
    private boolean partial;

    public UMLModel(Set<String> repositoryDirectories) {
        this.repositoryDirectories = repositoryDirectories;
        this.classList = new ArrayList<UMLClass>();
        this.generalizationList = new ArrayList<UMLGeneralization>();
        this.realizationList = new ArrayList<UMLRealization>();
    }

    public boolean isPartial() {
        return this.partial;
    }

    public void setPartial(boolean partial) {
        this.partial = partial;
    }

    public void addClass(UMLClass umlClass) {
        this.classList.add(umlClass);
    }

    public void addGeneralization(UMLGeneralization umlGeneralization) {
        this.generalizationList.add(umlGeneralization);
    }

    public void addRealization(UMLRealization umlRealization) {
        this.realizationList.add(umlRealization);
    }

    public UMLClass getClass(UMLClass umlClassFromOtherModel) {
        ListIterator<UMLClass> it = this.classList.listIterator();
        while (it.hasNext()) {
            UMLClass umlClass = it.next();
            if (!umlClass.equals(umlClassFromOtherModel)) continue;
            return umlClass;
        }
        return null;
    }

    public List<UMLClass> getClassList() {
        return this.classList;
    }

    public List<UMLGeneralization> getGeneralizationList() {
        return this.generalizationList;
    }

    public List<UMLRealization> getRealizationList() {
        return this.realizationList;
    }

    public UMLGeneralization matchGeneralization(UMLGeneralization otherGeneralization) {
        ListIterator<UMLGeneralization> generalizationIt = this.generalizationList.listIterator();
        while (generalizationIt.hasNext()) {
            UMLGeneralization generalization = generalizationIt.next();
            if (!generalization.getChild().equals(otherGeneralization.getChild())) continue;
            String thisParent = generalization.getParent();
            String otherParent = otherGeneralization.getParent();
            String thisParentComparedString = null;
            thisParentComparedString = thisParent.contains(".") ? thisParent.substring(thisParent.lastIndexOf(".") + 1) : thisParent;
            String otherParentComparedString = null;
            otherParentComparedString = otherParent.contains(".") ? otherParent.substring(otherParent.lastIndexOf(".") + 1) : otherParent;
            if (!thisParentComparedString.equals(otherParentComparedString)) continue;
            return generalization;
        }
        return null;
    }

    public UMLRealization matchRealization(UMLRealization otherRealization) {
        ListIterator<UMLRealization> realizationIt = this.realizationList.listIterator();
        while (realizationIt.hasNext()) {
            UMLRealization realization = realizationIt.next();
            if (!realization.getClient().equals(otherRealization.getClient())) continue;
            String thisSupplier = realization.getSupplier();
            String otherSupplier = otherRealization.getSupplier();
            String thisSupplierComparedString = null;
            thisSupplierComparedString = thisSupplier.contains(".") ? thisSupplier.substring(thisSupplier.lastIndexOf(".") + 1) : thisSupplier;
            String otherSupplierComparedString = null;
            otherSupplierComparedString = otherSupplier.contains(".") ? otherSupplier.substring(otherSupplier.lastIndexOf(".") + 1) : otherSupplier;
            if (!thisSupplierComparedString.equals(otherSupplierComparedString)) continue;
            return realization;
        }
        return null;
    }

    public UMLModelDiff diff(UMLModel umlModel) throws RefactoringMinerTimedOutException {
        UMLModelDiff modelDiff = new UMLModelDiff(this, umlModel);
        for (UMLClass umlClass : this.classList) {
            if (umlModel.classList.contains(umlClass)) continue;
            modelDiff.reportRemovedClass(umlClass);
        }
        for (UMLClass umlClass : umlModel.classList) {
            if (this.classList.contains(umlClass)) continue;
            modelDiff.reportAddedClass(umlClass);
        }
        modelDiff.checkForMovedClasses(umlModel.repositoryDirectories, new UMLClassMatcher.Move());
        modelDiff.checkForRenamedClasses(new UMLClassMatcher.Rename());
        for (UMLGeneralization umlGeneralization : this.generalizationList) {
            if (umlModel.generalizationList.contains(umlGeneralization)) continue;
            modelDiff.reportRemovedGeneralization(umlGeneralization);
        }
        for (UMLGeneralization umlGeneralization : umlModel.generalizationList) {
            if (this.generalizationList.contains(umlGeneralization)) continue;
            modelDiff.reportAddedGeneralization(umlGeneralization);
        }
        modelDiff.checkForGeneralizationChanges();
        for (UMLRealization umlRealization : this.realizationList) {
            if (umlModel.realizationList.contains(umlRealization)) continue;
            modelDiff.reportRemovedRealization(umlRealization);
        }
        for (UMLRealization umlRealization : umlModel.realizationList) {
            if (this.realizationList.contains(umlRealization)) continue;
            modelDiff.reportAddedRealization(umlRealization);
        }
        modelDiff.checkForRealizationChanges();
        for (UMLClass umlClass : this.classList) {
            if (!umlModel.classList.contains(umlClass)) continue;
            UMLClassDiff classDiff = new UMLClassDiff(umlClass, umlModel.getClass(umlClass), modelDiff);
            classDiff.process();
            modelDiff.addUMLClassDiff(classDiff);
        }
        modelDiff.checkForMovedClasses(umlModel.repositoryDirectories, new UMLClassMatcher.RelaxedMove());
        modelDiff.checkForRenamedClasses(new UMLClassMatcher.RelaxedRename());
        return modelDiff;
    }
}

