/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi;

import gr.uom.java.xmi.AnonymousClassDeclarationVisitor;
import gr.uom.java.xmi.LocationInfo;
import gr.uom.java.xmi.UMLAnnotation;
import gr.uom.java.xmi.UMLAnonymousClass;
import gr.uom.java.xmi.UMLAttribute;
import gr.uom.java.xmi.UMLClass;
import gr.uom.java.xmi.UMLComment;
import gr.uom.java.xmi.UMLEnumConstant;
import gr.uom.java.xmi.UMLGeneralization;
import gr.uom.java.xmi.UMLInitializer;
import gr.uom.java.xmi.UMLJavadoc;
import gr.uom.java.xmi.UMLModel;
import gr.uom.java.xmi.UMLOperation;
import gr.uom.java.xmi.UMLParameter;
import gr.uom.java.xmi.UMLRealization;
import gr.uom.java.xmi.UMLTagElement;
import gr.uom.java.xmi.UMLType;
import gr.uom.java.xmi.UMLTypeParameter;
import gr.uom.java.xmi.VariableDeclarationContainer;
import gr.uom.java.xmi.decomposition.OperationBody;
import gr.uom.java.xmi.decomposition.VariableDeclaration;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.commons.io.FileUtils;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Comment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;

public class UMLModelASTReader {
    private static final String FREE_MARKER_GENERATED = "generated using freemarker";
    private static final String FREE_MARKER_GENERATED_2 = "generated using FreeMarker";
    private static final String systemFileSeparator = Matcher.quoteReplacement(File.separator);
    private UMLModel umlModel;

    public UMLModelASTReader(Map<String, String> javaFileContents, Set<String> repositoryDirectories) {
        this.umlModel = new UMLModel(repositoryDirectories);
        this.processJavaFileContents(javaFileContents);
    }

    private void processJavaFileContents(Map<String, String> javaFileContents) {
        ASTParser parser = ASTParser.newParser((int)17);
        for (String filePath : javaFileContents.keySet()) {
            Hashtable options = JavaCore.getOptions();
            options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.8");
            options.put("org.eclipse.jdt.core.compiler.source", "1.8");
            options.put("org.eclipse.jdt.core.compiler.compliance", "1.8");
            parser.setCompilerOptions((Map)options);
            parser.setResolveBindings(false);
            parser.setKind(8);
            parser.setStatementsRecovery(true);
            String javaFileContent = javaFileContents.get(filePath);
            parser.setSource(javaFileContent.toCharArray());
            if ((javaFileContent.contains(FREE_MARKER_GENERATED) || javaFileContent.contains(FREE_MARKER_GENERATED_2)) && !javaFileContent.contains("private static final String FREE_MARKER_GENERATED = \"generated using freemarker\";")) continue;
            try {
                CompilationUnit compilationUnit = (CompilationUnit)parser.createAST(null);
                this.processCompilationUnit(filePath, compilationUnit, javaFileContent);
            }
            catch (Exception exception) {}
        }
    }

    public UMLModelASTReader(File rootFolder) throws IOException {
        List<String> javaFilePaths = UMLModelASTReader.getJavaFilePaths(rootFolder);
        LinkedHashMap<String, String> javaFileContents = new LinkedHashMap<String, String>();
        LinkedHashSet<String> repositoryDirectories = new LinkedHashSet<String>();
        for (String path : javaFilePaths) {
            String fullPath = rootFolder + File.separator + path.replaceAll("/", systemFileSeparator);
            String contents = FileUtils.readFileToString((File)new File(fullPath));
            javaFileContents.put(path, contents);
            String directory = new String(path);
            while (directory.contains("/")) {
                directory = directory.substring(0, directory.lastIndexOf("/"));
                repositoryDirectories.add(directory);
            }
        }
        this.umlModel = new UMLModel(repositoryDirectories);
        this.processJavaFileContents(javaFileContents);
    }

    private static List<String> getJavaFilePaths(File folder) throws IOException {
        Stream<Path> walk = Files.walk(Paths.get(folder.toURI()), new FileVisitOption[0]);
        List<String> paths = walk.map(x -> x.toString()).filter(f -> f.endsWith(".java")).map(x -> x.substring(folder.getPath().length() + 1).replaceAll(systemFileSeparator, "/")).collect(Collectors.toList());
        walk.close();
        return paths;
    }

    public UMLModel getUmlModel() {
        return this.umlModel;
    }

    protected void processCompilationUnit(String sourceFilePath, CompilationUnit compilationUnit, String javaFileContent) {
        List<UMLComment> comments = this.extractInternalComments(compilationUnit, sourceFilePath, javaFileContent);
        PackageDeclaration packageDeclaration = compilationUnit.getPackage();
        String packageName = null;
        UMLJavadoc packageDoc = null;
        if (packageDeclaration != null) {
            packageName = packageDeclaration.getName().getFullyQualifiedName();
            packageDoc = this.generateJavadoc(compilationUnit, sourceFilePath, packageDeclaration.getJavadoc());
        } else {
            packageName = "";
        }
        List imports = compilationUnit.imports();
        ArrayList<String> importedTypes = new ArrayList<String>();
        for (ImportDeclaration importDeclaration : imports) {
            importedTypes.add(importDeclaration.getName().getFullyQualifiedName());
        }
        List topLevelTypeDeclarations = compilationUnit.types();
        for (AbstractTypeDeclaration abstractTypeDeclaration : topLevelTypeDeclarations) {
            if (abstractTypeDeclaration instanceof TypeDeclaration) {
                TypeDeclaration topLevelTypeDeclaration = (TypeDeclaration)abstractTypeDeclaration;
                this.processTypeDeclaration(compilationUnit, topLevelTypeDeclaration, packageName, sourceFilePath, importedTypes, packageDoc, comments);
                continue;
            }
            if (!(abstractTypeDeclaration instanceof EnumDeclaration)) continue;
            EnumDeclaration enumDeclaration = (EnumDeclaration)abstractTypeDeclaration;
            this.processEnumDeclaration(compilationUnit, enumDeclaration, packageName, sourceFilePath, importedTypes, packageDoc, comments);
        }
    }

    private List<UMLComment> extractInternalComments(CompilationUnit cu, String sourceFile, String javaFileContent) {
        List astComments = cu.getCommentList();
        ArrayList<UMLComment> comments = new ArrayList<UMLComment>();
        for (Comment comment : astComments) {
            LocationInfo locationInfo = null;
            if (comment.isLineComment()) {
                locationInfo = this.generateLocationInfo(cu, sourceFile, (ASTNode)comment, LocationInfo.CodeElementType.LINE_COMMENT);
            } else if (comment.isBlockComment()) {
                locationInfo = this.generateLocationInfo(cu, sourceFile, (ASTNode)comment, LocationInfo.CodeElementType.BLOCK_COMMENT);
            }
            if (locationInfo == null) continue;
            int start = comment.getStartPosition();
            int end = start + comment.getLength();
            String text = javaFileContent.substring(start, end);
            UMLComment umlComment = new UMLComment(text, locationInfo);
            comments.add(umlComment);
        }
        return comments;
    }

    private void distributeComments(List<UMLComment> compilationUnitComments, LocationInfo codeElementLocationInfo, List<UMLComment> codeElementComments) {
        ListIterator<UMLComment> listIterator = compilationUnitComments.listIterator(compilationUnitComments.size());
        while (listIterator.hasPrevious()) {
            UMLComment comment = listIterator.previous();
            LocationInfo commentLocationInfo = comment.getLocationInfo();
            if (!codeElementLocationInfo.subsumes(commentLocationInfo) && !codeElementLocationInfo.sameLine(commentLocationInfo) && (!codeElementLocationInfo.nextLine(commentLocationInfo) || codeElementLocationInfo.getCodeElementType().equals((Object)LocationInfo.CodeElementType.ANONYMOUS_CLASS_DECLARATION)) && (codeElementComments.size() <= 0 || !codeElementComments.get(0).getLocationInfo().nextLine(commentLocationInfo))) continue;
            codeElementComments.add(0, comment);
        }
        compilationUnitComments.removeAll(codeElementComments);
    }

    private UMLJavadoc generateJavadoc(CompilationUnit cu, BodyDeclaration bodyDeclaration, String sourceFile) {
        Javadoc javaDoc = bodyDeclaration.getJavadoc();
        return this.generateJavadoc(cu, sourceFile, javaDoc);
    }

    private UMLJavadoc generateJavadoc(CompilationUnit cu, String sourceFile, Javadoc javaDoc) {
        UMLJavadoc doc = null;
        if (javaDoc != null) {
            LocationInfo locationInfo = this.generateLocationInfo(cu, sourceFile, (ASTNode)javaDoc, LocationInfo.CodeElementType.JAVADOC);
            doc = new UMLJavadoc(locationInfo);
            List tags = javaDoc.tags();
            for (TagElement tag : tags) {
                UMLTagElement tagElement = new UMLTagElement(tag.getTagName());
                List fragments = tag.fragments();
                for (Object docElement : fragments) {
                    tagElement.addFragment(docElement.toString());
                }
                doc.addTag(tagElement);
            }
        }
        return doc;
    }

    private void processEnumDeclaration(CompilationUnit cu, EnumDeclaration enumDeclaration, String packageName, String sourceFile, List<String> importedTypes, UMLJavadoc packageDoc, List<UMLComment> comments) {
        UMLJavadoc javadoc = this.generateJavadoc(cu, (BodyDeclaration)enumDeclaration, sourceFile);
        if (javadoc != null && javadoc.containsIgnoreCase(FREE_MARKER_GENERATED)) {
            return;
        }
        String className = enumDeclaration.getName().getFullyQualifiedName();
        LocationInfo locationInfo = this.generateLocationInfo(cu, sourceFile, (ASTNode)enumDeclaration, LocationInfo.CodeElementType.TYPE_DECLARATION);
        UMLClass umlClass = new UMLClass(packageName, className, locationInfo, enumDeclaration.isPackageMemberTypeDeclaration(), importedTypes);
        umlClass.setJavadoc(javadoc);
        if (enumDeclaration.isPackageMemberTypeDeclaration()) {
            umlClass.setPackageDeclarationJavadoc(packageDoc);
            for (UMLComment uMLComment : comments) {
                if (uMLComment.getLocationInfo().getStartLine() != 1) continue;
                umlClass.getPackageDeclarationComments().add(uMLComment);
            }
        }
        umlClass.setEnum(true);
        List superInterfaceTypes = enumDeclaration.superInterfaceTypes();
        for (Object interfaceType : superInterfaceTypes) {
            UMLType umlType = UMLType.extractTypeObject(cu, sourceFile, (Type)interfaceType, 0);
            UMLRealization umlRealization = new UMLRealization(umlClass, umlType.getClassType());
            umlClass.addImplementedInterface(umlType);
            this.getUmlModel().addRealization(umlRealization);
        }
        List list = enumDeclaration.enumConstants();
        for (EnumConstantDeclaration enumConstantDeclaration : list) {
            this.processEnumConstantDeclaration(cu, enumConstantDeclaration, sourceFile, umlClass, comments);
        }
        this.processModifiers(cu, sourceFile, (AbstractTypeDeclaration)enumDeclaration, umlClass);
        Map<BodyDeclaration, VariableDeclarationContainer> map = this.processBodyDeclarations(cu, (AbstractTypeDeclaration)enumDeclaration, packageName, sourceFile, importedTypes, umlClass, packageDoc, comments);
        this.processAnonymousClassDeclarations(cu, (AbstractTypeDeclaration)enumDeclaration, packageName, sourceFile, className, umlClass);
        for (BodyDeclaration declaration : map.keySet()) {
            if (declaration instanceof MethodDeclaration) {
                UMLOperation operation = (UMLOperation)map.get(declaration);
                this.processMethodBody(cu, sourceFile, (MethodDeclaration)declaration, operation);
                continue;
            }
            if (!(declaration instanceof Initializer)) continue;
            UMLInitializer initializer = (UMLInitializer)map.get(declaration);
            this.processInitializerBody(cu, sourceFile, (Initializer)declaration, initializer);
        }
        this.getUmlModel().addClass(umlClass);
        this.distributeComments(comments, locationInfo, umlClass.getComments());
    }

    private Map<BodyDeclaration, VariableDeclarationContainer> processBodyDeclarations(CompilationUnit cu, AbstractTypeDeclaration abstractTypeDeclaration, String packageName, String sourceFile, List<String> importedTypes, UMLClass umlClass, UMLJavadoc packageDoc, List<UMLComment> comments) {
        LinkedHashMap<BodyDeclaration, VariableDeclarationContainer> map = new LinkedHashMap<BodyDeclaration, VariableDeclarationContainer>();
        List bodyDeclarations = abstractTypeDeclaration.bodyDeclarations();
        for (BodyDeclaration bodyDeclaration : bodyDeclarations) {
            if (bodyDeclaration instanceof FieldDeclaration) {
                FieldDeclaration fieldDeclaration = (FieldDeclaration)bodyDeclaration;
                List<UMLAttribute> attributes = this.processFieldDeclaration(cu, fieldDeclaration, umlClass.isInterface(), sourceFile, comments);
                for (UMLAttribute attribute : attributes) {
                    attribute.setClassName(umlClass.getName());
                    umlClass.addAttribute(attribute);
                }
                continue;
            }
            if (bodyDeclaration instanceof MethodDeclaration) {
                MethodDeclaration methodDeclaration = (MethodDeclaration)bodyDeclaration;
                UMLOperation operation = this.processMethodDeclaration(cu, methodDeclaration, packageName, umlClass.isInterface(), sourceFile, comments);
                operation.setClassName(umlClass.getName());
                umlClass.addOperation(operation);
                map.put((BodyDeclaration)methodDeclaration, operation);
                continue;
            }
            if (bodyDeclaration instanceof Initializer) {
                Initializer initializer = (Initializer)bodyDeclaration;
                UMLInitializer umlInitializer = this.processInitializer(cu, initializer, packageName, false, sourceFile, comments);
                umlInitializer.setClassName(umlClass.getName());
                umlClass.addInitializer(umlInitializer);
                map.put((BodyDeclaration)initializer, umlInitializer);
                continue;
            }
            if (bodyDeclaration instanceof TypeDeclaration) {
                TypeDeclaration typeDeclaration = (TypeDeclaration)bodyDeclaration;
                this.processTypeDeclaration(cu, typeDeclaration, umlClass.getName(), sourceFile, importedTypes, packageDoc, comments);
                continue;
            }
            if (!(bodyDeclaration instanceof EnumDeclaration)) continue;
            EnumDeclaration enumDeclaration = (EnumDeclaration)bodyDeclaration;
            this.processEnumDeclaration(cu, enumDeclaration, umlClass.getName(), sourceFile, importedTypes, packageDoc, comments);
        }
        return map;
    }

    private void processTypeDeclaration(CompilationUnit cu, TypeDeclaration typeDeclaration, String packageName, String sourceFile, List<String> importedTypes, UMLJavadoc packageDoc, List<UMLComment> comments) {
        UMLJavadoc javadoc = this.generateJavadoc(cu, (BodyDeclaration)typeDeclaration, sourceFile);
        if (javadoc != null && javadoc.containsIgnoreCase(FREE_MARKER_GENERATED)) {
            return;
        }
        String className = typeDeclaration.getName().getFullyQualifiedName();
        LocationInfo locationInfo = this.generateLocationInfo(cu, sourceFile, (ASTNode)typeDeclaration, LocationInfo.CodeElementType.TYPE_DECLARATION);
        UMLClass umlClass = new UMLClass(packageName, className, locationInfo, typeDeclaration.isPackageMemberTypeDeclaration(), importedTypes);
        umlClass.setJavadoc(javadoc);
        if (typeDeclaration.isPackageMemberTypeDeclaration()) {
            umlClass.setPackageDeclarationJavadoc(packageDoc);
            for (UMLComment uMLComment : comments) {
                if (uMLComment.getLocationInfo().getStartLine() != 1) continue;
                umlClass.getPackageDeclarationComments().add(uMLComment);
            }
        }
        if (typeDeclaration.isInterface()) {
            umlClass.setInterface(true);
        }
        this.processModifiers(cu, sourceFile, (AbstractTypeDeclaration)typeDeclaration, umlClass);
        List typeParameters = typeDeclaration.typeParameters();
        for (TypeParameter typeParameter : typeParameters) {
            Object type22;
            UMLTypeParameter umlTypeParameter = new UMLTypeParameter(typeParameter.getName().getFullyQualifiedName(), this.generateLocationInfo(cu, sourceFile, (ASTNode)typeParameter, LocationInfo.CodeElementType.TYPE_PARAMETER));
            List typeBounds = typeParameter.typeBounds();
            for (Object type22 : typeBounds) {
                umlTypeParameter.addTypeBound(UMLType.extractTypeObject(cu, sourceFile, (Type)type22, 0));
            }
            List typeParameterExtendedModifiers = typeParameter.modifiers();
            type22 = typeParameterExtendedModifiers.iterator();
            while (type22.hasNext()) {
                IExtendedModifier extendedModifier = (IExtendedModifier)type22.next();
                if (!extendedModifier.isAnnotation()) continue;
                Annotation annotation = (Annotation)extendedModifier;
                umlTypeParameter.addAnnotation(new UMLAnnotation(cu, sourceFile, annotation));
            }
            umlClass.addTypeParameter(umlTypeParameter);
        }
        Type type = typeDeclaration.getSuperclassType();
        if (type != null) {
            UMLType umlType = UMLType.extractTypeObject(cu, sourceFile, type, 0);
            UMLGeneralization umlGeneralization = new UMLGeneralization(umlClass, umlType.getClassType());
            umlClass.setSuperclass(umlType);
            this.getUmlModel().addGeneralization(umlGeneralization);
        }
        List superInterfaceTypes = typeDeclaration.superInterfaceTypes();
        for (Type interfaceType : superInterfaceTypes) {
            UMLType umlType = UMLType.extractTypeObject(cu, sourceFile, interfaceType, 0);
            UMLRealization umlRealization = new UMLRealization(umlClass, umlType.getClassType());
            umlClass.addImplementedInterface(umlType);
            this.getUmlModel().addRealization(umlRealization);
        }
        Map<BodyDeclaration, VariableDeclarationContainer> map = this.processBodyDeclarations(cu, (AbstractTypeDeclaration)typeDeclaration, packageName, sourceFile, importedTypes, umlClass, packageDoc, comments);
        this.processAnonymousClassDeclarations(cu, (AbstractTypeDeclaration)typeDeclaration, packageName, sourceFile, className, umlClass);
        for (BodyDeclaration declaration : map.keySet()) {
            if (declaration instanceof MethodDeclaration) {
                UMLOperation operation = (UMLOperation)map.get(declaration);
                this.processMethodBody(cu, sourceFile, (MethodDeclaration)declaration, operation);
                continue;
            }
            if (!(declaration instanceof Initializer)) continue;
            UMLInitializer initializer = (UMLInitializer)map.get(declaration);
            this.processInitializerBody(cu, sourceFile, (Initializer)declaration, initializer);
        }
        this.getUmlModel().addClass(umlClass);
        this.distributeComments(comments, locationInfo, umlClass.getComments());
    }

    private void processAnonymousClassDeclarations(CompilationUnit cu, AbstractTypeDeclaration typeDeclaration, String packageName, String sourceFile, String className, UMLClass umlClass) {
        AnonymousClassDeclarationVisitor visitor = new AnonymousClassDeclarationVisitor();
        typeDeclaration.accept((ASTVisitor)visitor);
        Set<AnonymousClassDeclaration> anonymousClassDeclarations = visitor.getAnonymousClassDeclarations();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        for (AnonymousClassDeclaration anonymous : anonymousClassDeclarations) {
            this.insertNode(anonymous, root);
        }
        ArrayList<UMLAnonymousClass> createdAnonymousClasses = new ArrayList<UMLAnonymousClass>();
        Enumeration<TreeNode> enumeration = root.postorderEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)enumeration.nextElement();
            if (node.getUserObject() == null) continue;
            AnonymousClassDeclaration anonymous = (AnonymousClassDeclaration)node.getUserObject();
            boolean operationFound = false;
            boolean attributeFound = false;
            boolean initializerFound = false;
            UMLOperation matchingOperation = null;
            UMLAttribute matchingAttribute = null;
            UMLInitializer matchingInitializer = null;
            UMLEnumConstant matchingEnumConstant = null;
            List<UMLComment> comments = null;
            for (UMLOperation operation : umlClass.getOperations()) {
                if (operation.getLocationInfo().getStartOffset() > anonymous.getStartPosition() || operation.getLocationInfo().getEndOffset() < anonymous.getStartPosition() + anonymous.getLength()) continue;
                comments = operation.getComments();
                operationFound = true;
                matchingOperation = operation;
                break;
            }
            if (!operationFound) {
                for (UMLAttribute attribute : umlClass.getAttributes()) {
                    if (attribute.getLocationInfo().getStartOffset() > anonymous.getStartPosition() || attribute.getLocationInfo().getEndOffset() < anonymous.getStartPosition() + anonymous.getLength()) continue;
                    comments = attribute.getComments();
                    attributeFound = true;
                    matchingAttribute = attribute;
                    break;
                }
            }
            if (!operationFound && !attributeFound) {
                for (UMLInitializer initializer : umlClass.getInitializers()) {
                    if (initializer.getLocationInfo().getStartOffset() > anonymous.getStartPosition() || initializer.getLocationInfo().getEndOffset() < anonymous.getStartPosition() + anonymous.getLength()) continue;
                    comments = initializer.getComments();
                    initializerFound = true;
                    matchingInitializer = initializer;
                    break;
                }
            }
            if (!(operationFound || attributeFound || initializerFound)) {
                for (UMLEnumConstant enumConstant : umlClass.getEnumConstants()) {
                    if (enumConstant.getLocationInfo().getStartOffset() > anonymous.getStartPosition() || enumConstant.getLocationInfo().getEndOffset() < anonymous.getStartPosition() + anonymous.getLength()) continue;
                    comments = enumConstant.getComments();
                    matchingEnumConstant = enumConstant;
                    break;
                }
            }
            if (matchingOperation == null && matchingAttribute == null && matchingInitializer == null && matchingEnumConstant == null) continue;
            String anonymousBinaryName = this.getAnonymousBinaryName(node);
            String anonymousCodePath = this.getAnonymousCodePath(node);
            UMLAnonymousClass anonymousClass = this.processAnonymousClassDeclaration(cu, anonymous, packageName + "." + className, anonymousBinaryName, anonymousCodePath, sourceFile, comments, umlClass.getImportedTypes());
            umlClass.addAnonymousClass(anonymousClass);
            if (matchingOperation != null) {
                matchingOperation.addAnonymousClass(anonymousClass);
            }
            if (matchingAttribute != null) {
                matchingAttribute.addAnonymousClass(anonymousClass);
            }
            if (matchingInitializer != null) {
                matchingInitializer.addAnonymousClass(anonymousClass);
            }
            if (matchingEnumConstant != null) {
                matchingEnumConstant.addAnonymousClass(anonymousClass);
            }
            for (UMLOperation operation : anonymousClass.getOperations()) {
                for (UMLAnonymousClass createdAnonymousClass : createdAnonymousClasses) {
                    if (!operation.getLocationInfo().subsumes(createdAnonymousClass.getLocationInfo())) continue;
                    operation.addAnonymousClass(createdAnonymousClass);
                }
            }
            for (UMLAttribute attribute : anonymousClass.getAttributes()) {
                for (UMLAnonymousClass createdAnonymousClass : createdAnonymousClasses) {
                    if (!attribute.getLocationInfo().subsumes(createdAnonymousClass.getLocationInfo())) continue;
                    attribute.addAnonymousClass(createdAnonymousClass);
                }
            }
            for (UMLInitializer initializer : anonymousClass.getInitializers()) {
                for (UMLAnonymousClass createdAnonymousClass : createdAnonymousClasses) {
                    if (!initializer.getLocationInfo().subsumes(createdAnonymousClass.getLocationInfo())) continue;
                    initializer.addAnonymousClass(createdAnonymousClass);
                }
            }
            for (UMLEnumConstant enumConstant : anonymousClass.getEnumConstants()) {
                for (UMLAnonymousClass createdAnonymousClass : createdAnonymousClasses) {
                    if (!enumConstant.getLocationInfo().subsumes(createdAnonymousClass.getLocationInfo())) continue;
                    enumConstant.addAnonymousClass(createdAnonymousClass);
                }
            }
            createdAnonymousClasses.add(anonymousClass);
            List bodyDeclarations = anonymous.bodyDeclarations();
            int i = 0;
            int j = 0;
            for (BodyDeclaration bodyDeclaration : bodyDeclarations) {
                if (bodyDeclaration instanceof MethodDeclaration) {
                    MethodDeclaration methodDeclaration = (MethodDeclaration)bodyDeclaration;
                    UMLOperation operation = anonymousClass.getOperations().get(i);
                    this.processMethodBody(cu, sourceFile, methodDeclaration, operation);
                    ++i;
                    continue;
                }
                if (!(bodyDeclaration instanceof Initializer)) continue;
                Initializer initializer = (Initializer)bodyDeclaration;
                UMLInitializer umlInitializer = anonymousClass.getInitializers().get(j);
                this.processInitializerBody(cu, sourceFile, initializer, umlInitializer);
                ++j;
            }
        }
    }

    private void processMethodBody(CompilationUnit cu, String sourceFile, MethodDeclaration methodDeclaration, UMLOperation operation) {
        Block block = methodDeclaration.getBody();
        if (block != null) {
            OperationBody body = new OperationBody(cu, sourceFile, block, operation);
            operation.setBody(body);
            if (block.statements().size() == 0) {
                operation.setEmptyBody(true);
            }
        } else {
            operation.setBody(null);
        }
    }

    private void processInitializerBody(CompilationUnit cu, String sourceFile, Initializer initializer, UMLInitializer umlInitializer) {
        Block block = initializer.getBody();
        if (block != null) {
            OperationBody body = new OperationBody(cu, sourceFile, block, umlInitializer);
            umlInitializer.setBody(body);
        } else {
            umlInitializer.setBody(null);
        }
    }

    private void processModifiers(CompilationUnit cu, String sourceFile, AbstractTypeDeclaration typeDeclaration, UMLClass umlClass) {
        int modifiers = typeDeclaration.getModifiers();
        if ((modifiers & 0x400) != 0) {
            umlClass.setAbstract(true);
        }
        if ((modifiers & 8) != 0) {
            umlClass.setStatic(true);
        }
        if ((modifiers & 0x10) != 0) {
            umlClass.setFinal(true);
        }
        if ((modifiers & 1) != 0) {
            umlClass.setVisibility("public");
        } else if ((modifiers & 4) != 0) {
            umlClass.setVisibility("protected");
        } else if ((modifiers & 2) != 0) {
            umlClass.setVisibility("private");
        } else {
            umlClass.setVisibility("package");
        }
        List extendedModifiers = typeDeclaration.modifiers();
        for (IExtendedModifier extendedModifier : extendedModifiers) {
            if (!extendedModifier.isAnnotation()) continue;
            Annotation annotation = (Annotation)extendedModifier;
            umlClass.addAnnotation(new UMLAnnotation(cu, sourceFile, annotation));
        }
    }

    private UMLInitializer processInitializer(CompilationUnit cu, Initializer initializer, String packageName, boolean isInterfaceMethod, String sourceFile, List<UMLComment> comments) {
        UMLJavadoc javadoc = this.generateJavadoc(cu, (BodyDeclaration)initializer, sourceFile);
        String name = "";
        if (initializer.getParent() instanceof AnonymousClassDeclaration && initializer.getParent().getParent() instanceof ClassInstanceCreation) {
            ClassInstanceCreation creation = (ClassInstanceCreation)initializer.getParent().getParent();
            name = creation.getType().toString();
        } else if (initializer.getParent() instanceof AbstractTypeDeclaration) {
            AbstractTypeDeclaration typeDeclaration = (AbstractTypeDeclaration)initializer.getParent();
            name = typeDeclaration.getName().getIdentifier();
        }
        LocationInfo locationInfo = this.generateLocationInfo(cu, sourceFile, (ASTNode)initializer, LocationInfo.CodeElementType.INITIALIZER);
        UMLInitializer umlInitializer = new UMLInitializer(name, locationInfo);
        umlInitializer.setJavadoc(javadoc);
        this.distributeComments(comments, locationInfo, umlInitializer.getComments());
        int methodModifiers = initializer.getModifiers();
        if ((methodModifiers & 8) != 0) {
            umlInitializer.setStatic(true);
        }
        return umlInitializer;
    }

    private UMLOperation processMethodDeclaration(CompilationUnit cu, MethodDeclaration methodDeclaration, String packageName, boolean isInterfaceMethod, String sourceFile, List<UMLComment> comments) {
        Object type2;
        int methodModifiers;
        UMLJavadoc javadoc = this.generateJavadoc(cu, (BodyDeclaration)methodDeclaration, sourceFile);
        String methodName = methodDeclaration.getName().getFullyQualifiedName();
        LocationInfo locationInfo = this.generateLocationInfo(cu, sourceFile, (ASTNode)methodDeclaration, LocationInfo.CodeElementType.METHOD_DECLARATION);
        UMLOperation umlOperation = new UMLOperation(methodName, locationInfo);
        umlOperation.setJavadoc(javadoc);
        this.distributeComments(comments, locationInfo, umlOperation.getComments());
        if (methodDeclaration.isConstructor()) {
            umlOperation.setConstructor(true);
        }
        if (((methodModifiers = methodDeclaration.getModifiers()) & 1) != 0) {
            umlOperation.setVisibility("public");
        } else if ((methodModifiers & 4) != 0) {
            umlOperation.setVisibility("protected");
        } else if ((methodModifiers & 2) != 0) {
            umlOperation.setVisibility("private");
        } else if (isInterfaceMethod) {
            umlOperation.setVisibility("public");
        } else {
            umlOperation.setVisibility("package");
        }
        if ((methodModifiers & 0x400) != 0) {
            umlOperation.setAbstract(true);
        }
        if ((methodModifiers & 0x10) != 0) {
            umlOperation.setFinal(true);
        }
        if ((methodModifiers & 8) != 0) {
            umlOperation.setStatic(true);
        }
        if ((methodModifiers & 0x20) != 0) {
            umlOperation.setSynchronized(true);
        }
        if ((methodModifiers & 0x100) != 0) {
            umlOperation.setNative(true);
        }
        List extendedModifiers = methodDeclaration.modifiers();
        for (Object extendedModifier : extendedModifiers) {
            if (!extendedModifier.isAnnotation()) continue;
            Annotation annotation = (Annotation)extendedModifier;
            umlOperation.addAnnotation(new UMLAnnotation(cu, sourceFile, annotation));
        }
        List typeParameters = methodDeclaration.typeParameters();
        for (TypeParameter typeParameter : typeParameters) {
            UMLTypeParameter umlTypeParameter = new UMLTypeParameter(typeParameter.getName().getFullyQualifiedName(), this.generateLocationInfo(cu, sourceFile, (ASTNode)typeParameter, LocationInfo.CodeElementType.TYPE_PARAMETER));
            List typeBounds = typeParameter.typeBounds();
            for (Object type2 : typeBounds) {
                umlTypeParameter.addTypeBound(UMLType.extractTypeObject(cu, sourceFile, (Type)type2, 0));
            }
            List typeParameterExtendedModifiers = typeParameter.modifiers();
            type2 = typeParameterExtendedModifiers.iterator();
            while (type2.hasNext()) {
                IExtendedModifier extendedModifier = (IExtendedModifier)type2.next();
                if (!extendedModifier.isAnnotation()) continue;
                Annotation annotation = (Annotation)extendedModifier;
                umlTypeParameter.addAnnotation(new UMLAnnotation(cu, sourceFile, annotation));
            }
            umlOperation.addTypeParameter(umlTypeParameter);
        }
        Type returnType = methodDeclaration.getReturnType2();
        if (returnType != null) {
            UMLType type3 = UMLType.extractTypeObject(cu, sourceFile, returnType, methodDeclaration.getExtraDimensions());
            UMLParameter returnParameter = new UMLParameter("return", type3, "return", false);
            umlOperation.addParameter(returnParameter);
        }
        List parameters = methodDeclaration.parameters();
        for (SingleVariableDeclaration parameter : parameters) {
            Type parameterType = parameter.getType();
            String parameterName = parameter.getName().getFullyQualifiedName();
            UMLType type4 = UMLType.extractTypeObject(cu, sourceFile, parameterType, parameter.getExtraDimensions());
            if (parameter.isVarargs()) {
                type4.setVarargs();
            }
            UMLParameter umlParameter = new UMLParameter(parameterName, type4, "in", parameter.isVarargs());
            VariableDeclaration variableDeclaration = new VariableDeclaration(cu, sourceFile, parameter, umlOperation, parameter.isVarargs());
            variableDeclaration.setParameter(true);
            umlParameter.setVariableDeclaration(variableDeclaration);
            umlOperation.addParameter(umlParameter);
        }
        List thrownExceptionTypes = methodDeclaration.thrownExceptionTypes();
        for (Type thrownExceptionType : thrownExceptionTypes) {
            type2 = UMLType.extractTypeObject(cu, sourceFile, thrownExceptionType, 0);
            umlOperation.addThrownExceptionType((UMLType)type2);
        }
        return umlOperation;
    }

    private void processEnumConstantDeclaration(CompilationUnit cu, EnumConstantDeclaration enumConstantDeclaration, String sourceFile, UMLClass umlClass, List<UMLComment> comments) {
        UMLJavadoc javadoc = this.generateJavadoc(cu, (BodyDeclaration)enumConstantDeclaration, sourceFile);
        LocationInfo locationInfo = this.generateLocationInfo(cu, sourceFile, (ASTNode)enumConstantDeclaration, LocationInfo.CodeElementType.ENUM_CONSTANT_DECLARATION);
        UMLEnumConstant enumConstant = new UMLEnumConstant(enumConstantDeclaration.getName().getIdentifier(), UMLType.extractTypeObject(umlClass.getName()), locationInfo);
        VariableDeclaration variableDeclaration = new VariableDeclaration(cu, sourceFile, enumConstantDeclaration);
        enumConstant.setVariableDeclaration(variableDeclaration);
        enumConstant.setJavadoc(javadoc);
        this.distributeComments(comments, locationInfo, enumConstant.getComments());
        enumConstant.setFinal(true);
        enumConstant.setStatic(true);
        enumConstant.setVisibility("public");
        List arguments = enumConstantDeclaration.arguments();
        for (Expression argument : arguments) {
            enumConstant.addArgument(argument.toString());
        }
        enumConstant.setClassName(umlClass.getName());
        umlClass.addEnumConstant(enumConstant);
    }

    private List<UMLAttribute> processFieldDeclaration(CompilationUnit cu, FieldDeclaration fieldDeclaration, boolean isInterfaceField, String sourceFile, List<UMLComment> comments) {
        UMLJavadoc javadoc = this.generateJavadoc(cu, (BodyDeclaration)fieldDeclaration, sourceFile);
        ArrayList<UMLAttribute> attributes = new ArrayList<UMLAttribute>();
        Type fieldType = fieldDeclaration.getType();
        List fragments = fieldDeclaration.fragments();
        for (VariableDeclarationFragment fragment : fragments) {
            UMLType type = UMLType.extractTypeObject(cu, sourceFile, fieldType, fragment.getExtraDimensions());
            String fieldName = fragment.getName().getFullyQualifiedName();
            LocationInfo locationInfo = this.generateLocationInfo(cu, sourceFile, (ASTNode)fragment, LocationInfo.CodeElementType.FIELD_DECLARATION);
            UMLAttribute umlAttribute = new UMLAttribute(fieldName, type, locationInfo);
            VariableDeclaration variableDeclaration = new VariableDeclaration(cu, sourceFile, fragment, (VariableDeclarationContainer)umlAttribute);
            variableDeclaration.setAttribute(true);
            umlAttribute.setVariableDeclaration(variableDeclaration);
            umlAttribute.setJavadoc(javadoc);
            this.distributeComments(comments, locationInfo, umlAttribute.getComments());
            int fieldModifiers = fieldDeclaration.getModifiers();
            if ((fieldModifiers & 1) != 0) {
                umlAttribute.setVisibility("public");
            } else if ((fieldModifiers & 4) != 0) {
                umlAttribute.setVisibility("protected");
            } else if ((fieldModifiers & 2) != 0) {
                umlAttribute.setVisibility("private");
            } else if (isInterfaceField) {
                umlAttribute.setVisibility("public");
            } else {
                umlAttribute.setVisibility("package");
            }
            if ((fieldModifiers & 0x10) != 0) {
                umlAttribute.setFinal(true);
            }
            if ((fieldModifiers & 8) != 0) {
                umlAttribute.setStatic(true);
            }
            if ((fieldModifiers & 0x40) != 0) {
                umlAttribute.setVolatile(true);
            }
            if ((fieldModifiers & 0x80) != 0) {
                umlAttribute.setTransient(true);
            }
            attributes.add(umlAttribute);
        }
        return attributes;
    }

    private UMLAnonymousClass processAnonymousClassDeclaration(CompilationUnit cu, AnonymousClassDeclaration anonymous, String packageName, String binaryName, String codePath, String sourceFile, List<UMLComment> comments, List<String> importedTypes) {
        List bodyDeclarations = anonymous.bodyDeclarations();
        LocationInfo locationInfo = this.generateLocationInfo(cu, sourceFile, (ASTNode)anonymous, LocationInfo.CodeElementType.ANONYMOUS_CLASS_DECLARATION);
        UMLAnonymousClass anonymousClass = new UMLAnonymousClass(packageName, binaryName, codePath, locationInfo, importedTypes);
        for (BodyDeclaration bodyDeclaration : bodyDeclarations) {
            if (bodyDeclaration instanceof FieldDeclaration) {
                FieldDeclaration fieldDeclaration = (FieldDeclaration)bodyDeclaration;
                List<UMLAttribute> attributes = this.processFieldDeclaration(cu, fieldDeclaration, false, sourceFile, comments);
                for (UMLAttribute attribute : attributes) {
                    attribute.setClassName(anonymousClass.getCodePath());
                    attribute.setDeclaredInAnonymousClass(true);
                    anonymousClass.addAttribute(attribute);
                }
                continue;
            }
            if (bodyDeclaration instanceof MethodDeclaration) {
                MethodDeclaration methodDeclaration = (MethodDeclaration)bodyDeclaration;
                UMLOperation operation = this.processMethodDeclaration(cu, methodDeclaration, packageName, false, sourceFile, comments);
                operation.setClassName(anonymousClass.getCodePath());
                operation.setDeclaredInAnonymousClass(true);
                anonymousClass.addOperation(operation);
                continue;
            }
            if (!(bodyDeclaration instanceof Initializer)) continue;
            Initializer initializer = (Initializer)bodyDeclaration;
            UMLInitializer umlInitializer = this.processInitializer(cu, initializer, packageName, false, sourceFile, comments);
            umlInitializer.setClassName(anonymousClass.getCodePath());
            umlInitializer.setDeclaredInAnonymousClass(true);
            anonymousClass.addInitializer(umlInitializer);
        }
        this.distributeComments(comments, locationInfo, anonymousClass.getComments());
        return anonymousClass;
    }

    private void insertNode(AnonymousClassDeclaration childAnonymous, DefaultMutableTreeNode root) {
        Enumeration<TreeNode> enumeration = root.postorderEnumeration();
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(childAnonymous);
        DefaultMutableTreeNode parentNode = root;
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)enumeration.nextElement();
            AnonymousClassDeclaration currentAnonymous = (AnonymousClassDeclaration)currentNode.getUserObject();
            if (currentAnonymous == null || !this.isParent((ASTNode)childAnonymous, (ASTNode)currentAnonymous)) continue;
            parentNode = currentNode;
            break;
        }
        parentNode.add(childNode);
    }

    private String getAnonymousCodePath(DefaultMutableTreeNode node) {
        AnonymousClassDeclaration anonymous = (AnonymousClassDeclaration)node.getUserObject();
        Object name = "";
        for (ASTNode parent = anonymous.getParent(); parent != null; parent = parent.getParent()) {
            String invocationName;
            if (parent instanceof MethodDeclaration) {
                String methodName = ((MethodDeclaration)parent).getName().getIdentifier();
                if (((String)name).isEmpty()) {
                    name = methodName;
                    continue;
                }
                name = methodName + "." + (String)name;
                continue;
            }
            if (parent instanceof VariableDeclarationFragment && (parent.getParent() instanceof FieldDeclaration || parent.getParent() instanceof VariableDeclarationStatement)) {
                String fieldName = ((VariableDeclarationFragment)parent).getName().getIdentifier();
                if (((String)name).isEmpty()) {
                    name = fieldName;
                    continue;
                }
                name = fieldName + "." + (String)name;
                continue;
            }
            if (parent instanceof MethodInvocation) {
                invocationName = ((MethodInvocation)parent).getName().getIdentifier();
                if (((String)name).isEmpty()) {
                    name = invocationName;
                    continue;
                }
                name = invocationName + "." + (String)name;
                continue;
            }
            if (parent instanceof SuperMethodInvocation) {
                invocationName = ((SuperMethodInvocation)parent).getName().getIdentifier();
                if (((String)name).isEmpty()) {
                    name = invocationName;
                    continue;
                }
                name = invocationName + "." + (String)name;
                continue;
            }
            if (!(parent instanceof ClassInstanceCreation)) continue;
            invocationName = ((ClassInstanceCreation)parent).getType().toString();
            name = ((String)name).isEmpty() ? "new " + invocationName : "new " + invocationName + "." + (String)name;
        }
        return ((String)name).toString();
    }

    private String getAnonymousBinaryName(DefaultMutableTreeNode node) {
        StringBuilder name = new StringBuilder();
        TreeNode[] path = node.getPath();
        for (int i = 0; i < path.length; ++i) {
            DefaultMutableTreeNode tmp = (DefaultMutableTreeNode)path[i];
            if (tmp.getUserObject() == null) continue;
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)tmp.getParent();
            int index = parent.getIndex(tmp);
            name.append(index + 1);
            if (i >= path.length - 1) continue;
            name.append(".");
        }
        return name.toString();
    }

    private boolean isParent(ASTNode child, ASTNode parent) {
        ASTNode current = child;
        while (current.getParent() != null) {
            if (current.getParent().equals((Object)parent)) {
                return true;
            }
            current = current.getParent();
        }
        return false;
    }

    private LocationInfo generateLocationInfo(CompilationUnit cu, String sourceFile, ASTNode node, LocationInfo.CodeElementType codeElementType) {
        return new LocationInfo(cu, sourceFile, node, codeElementType);
    }
}

