/*
 * Decompiled with CFR 0.152.
 */
package gr.uom.java.xmi;

import gr.uom.java.xmi.CompositeType;
import gr.uom.java.xmi.LeafType;
import gr.uom.java.xmi.ListCompositeType;
import gr.uom.java.xmi.LocationInfo;
import gr.uom.java.xmi.LocationInfoProvider;
import gr.uom.java.xmi.UMLAnnotation;
import gr.uom.java.xmi.WildcardType;
import gr.uom.java.xmi.diff.CodeRange;
import gr.uom.java.xmi.diff.StringDistance;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnnotatableType;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IntersectionType;
import org.eclipse.jdt.core.dom.NameQualifiedType;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.UnionType;

public abstract class UMLType
implements Serializable,
LocationInfoProvider {
    private LocationInfo locationInfo;
    private int arrayDimension;
    private List<UMLType> typeArguments = new ArrayList<UMLType>();
    protected List<UMLAnnotation> annotations = new ArrayList<UMLAnnotation>();

    @Override
    public LocationInfo getLocationInfo() {
        return this.locationInfo;
    }

    public int getArrayDimension() {
        return this.arrayDimension;
    }

    public List<UMLType> getTypeArguments() {
        return this.typeArguments;
    }

    public List<UMLAnnotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public CodeRange codeRange() {
        return this.locationInfo.codeRange();
    }

    public void setVarargs() {
        ++this.arrayDimension;
    }

    protected String typeArgumentsToString() {
        StringBuilder sb = new StringBuilder();
        if (this.typeArguments.isEmpty()) {
            sb.append("");
        } else {
            sb.append("<");
            for (int i = 0; i < this.typeArguments.size(); ++i) {
                sb.append(this.typeArguments.get(i).toQualifiedString());
                if (i >= this.typeArguments.size() - 1) continue;
                sb.append(",");
            }
            sb.append(">");
        }
        return sb.toString();
    }

    protected String typeArgumentsAndArrayDimensionToString() {
        StringBuilder sb = new StringBuilder();
        if (this.isParameterized()) {
            sb.append(this.typeArgumentsToString());
        }
        for (int i = 0; i < this.getArrayDimension(); ++i) {
            sb.append("[]");
        }
        return sb.toString();
    }

    private boolean equalTypeArguments(UMLType type) {
        String thisTypeArguments = this.typeArgumentsToString();
        String otherTypeArguments = type.typeArgumentsToString();
        if (thisTypeArguments.equals("<?>") && otherTypeArguments.startsWith("<? ") || thisTypeArguments.startsWith("<? ") && otherTypeArguments.equals("<?>")) {
            return true;
        }
        if (thisTypeArguments.equals("<Object>") && otherTypeArguments.contains("<Object>") || otherTypeArguments.equals("<Object>") && thisTypeArguments.contains("<Object>")) {
            return true;
        }
        if (this.typeArguments.size() != type.typeArguments.size()) {
            return false;
        }
        for (int i = 0; i < this.typeArguments.size(); ++i) {
            UMLType otherComponent;
            UMLType thisComponent = this.typeArguments.get(i);
            if (thisComponent.equals(otherComponent = type.typeArguments.get(i))) continue;
            return false;
        }
        return true;
    }

    protected boolean equalTypeArgumentsAndArrayDimension(UMLType typeObject) {
        if (!this.isParameterized() && !typeObject.isParameterized()) {
            return this.arrayDimension == typeObject.arrayDimension;
        }
        if (this.isParameterized() && typeObject.isParameterized()) {
            return this.equalTypeArguments(typeObject) && this.arrayDimension == typeObject.arrayDimension;
        }
        return false;
    }

    protected boolean equalTypeArgumentsAndArrayDimensionForSubType(UMLType typeObject) {
        if (!this.isParameterized() && !typeObject.isParameterized()) {
            return this.arrayDimension == typeObject.arrayDimension;
        }
        if (this.isParameterized() && typeObject.isParameterized()) {
            return this.equalTypeArguments(typeObject) && this.arrayDimension == typeObject.arrayDimension;
        }
        if (this.isParameterized() && this.typeArgumentsToString().equals("<?>") && !typeObject.isParameterized()) {
            return this.arrayDimension == typeObject.arrayDimension;
        }
        if (!this.isParameterized() && typeObject.isParameterized() && typeObject.typeArgumentsToString().equals("<?>")) {
            return this.arrayDimension == typeObject.arrayDimension;
        }
        return false;
    }

    public boolean containsTypeArgument(String type) {
        for (UMLType typeArgument : this.typeArguments) {
            if (!typeArgument.toString().equals(type)) continue;
            return true;
        }
        return false;
    }

    public boolean isParameterized() {
        return this.typeArguments.size() > 0;
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String toString();

    public abstract String toQualifiedString();

    public abstract String getClassType();

    public boolean equalsQualified(UMLType type) {
        if (this.getClass() == type.getClass()) {
            return this.equals(type);
        }
        return false;
    }

    public boolean equalsWithSubType(UMLType type) {
        if (this.getClass() == type.getClass()) {
            return this.equals(type);
        }
        return false;
    }

    public boolean equalClassType(UMLType type) {
        if (this.getClass() == type.getClass()) {
            return this.equals(type);
        }
        return false;
    }

    public boolean compatibleTypes(UMLType type) {
        if (this.getClass() == type.getClass()) {
            return this.equals(type);
        }
        return false;
    }

    public double normalizedNameDistance(UMLType type) {
        String s1 = this.toString();
        String s2 = type.toString();
        int distance = StringDistance.editDistance(s1, s2);
        double normalized = (double)distance / (double)Math.max(s1.length(), s2.length());
        return normalized;
    }

    public static LeafType extractTypeObject(String qualifiedName) {
        int arrayDimension = 0;
        ArrayList<UMLType> typeArgumentDecomposition = new ArrayList<UMLType>();
        if (qualifiedName.endsWith("[]")) {
            while (qualifiedName.endsWith("[]")) {
                qualifiedName = qualifiedName.substring(0, qualifiedName.lastIndexOf("[]"));
                ++arrayDimension;
            }
        }
        if (qualifiedName.contains("<") && qualifiedName.contains(">") && !UMLType.closingTagBeforeOpeningTag(qualifiedName.substring(qualifiedName.indexOf("<") + 1, qualifiedName.lastIndexOf(">")))) {
            String typeArguments = qualifiedName.substring(qualifiedName.indexOf("<") + 1, qualifiedName.lastIndexOf(">"));
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < typeArguments.length(); ++i) {
                char charAt = typeArguments.charAt(i);
                if (charAt != ',') {
                    sb.append(charAt);
                    continue;
                }
                if (sb.length() > 0 && UMLType.equalOpeningClosingTags(sb.toString())) {
                    typeArgumentDecomposition.add(UMLType.extractTypeObject(sb.toString()));
                    sb = new StringBuilder();
                    continue;
                }
                sb.append(charAt);
            }
            if (sb.length() > 0) {
                typeArgumentDecomposition.add(UMLType.extractTypeObject(sb.toString()));
            }
            qualifiedName = qualifiedName.substring(0, qualifiedName.indexOf("<"));
        }
        LeafType typeObject = new LeafType(qualifiedName);
        typeObject.arrayDimension = arrayDimension;
        typeObject.typeArguments = typeArgumentDecomposition;
        return typeObject;
    }

    private static boolean closingTagBeforeOpeningTag(String typeArguments) {
        int indexOfOpeningTag = typeArguments.indexOf("<");
        int indexOfClosingTag = typeArguments.lastIndexOf(">");
        return indexOfClosingTag < indexOfOpeningTag;
    }

    private static boolean equalOpeningClosingTags(String typeArguments) {
        int openingTags = 0;
        int closingTags = 0;
        for (int i = 0; i < typeArguments.length(); ++i) {
            if (typeArguments.charAt(i) == '>') {
                ++openingTags;
                continue;
            }
            if (typeArguments.charAt(i) != '<') continue;
            ++closingTags;
        }
        return openingTags == closingTags;
    }

    public static UMLType extractTypeObject(CompilationUnit cu, String filePath, Type type, int extraDimensions) {
        UMLType umlType = UMLType.extractTypeObject(cu, filePath, type);
        umlType.locationInfo = new LocationInfo(cu, filePath, (ASTNode)type, LocationInfo.CodeElementType.TYPE);
        umlType.arrayDimension += extraDimensions;
        return umlType;
    }

    private static UMLType extractTypeObject(CompilationUnit cu, String filePath, Type type) {
        if (type.isPrimitiveType() || type.isSimpleType()) {
            LeafType leafType = UMLType.extractTypeObject(type.toString());
            AnnotatableType annotatableType = (AnnotatableType)type;
            List annotations = annotatableType.annotations();
            for (Annotation annotation : annotations) {
                leafType.annotations.add(new UMLAnnotation(cu, filePath, annotation));
            }
            return leafType;
        }
        if (type instanceof QualifiedType) {
            QualifiedType qualified = (QualifiedType)type;
            UMLType leftType = UMLType.extractTypeObject(cu, filePath, qualified.getQualifier());
            LeafType rightType = UMLType.extractTypeObject(qualified.getName().getFullyQualifiedName());
            QualifiedType annotatableType = qualified;
            List annotations = annotatableType.annotations();
            for (Annotation annotation : annotations) {
                rightType.annotations.add(new UMLAnnotation(cu, filePath, annotation));
            }
            return new CompositeType(leftType, rightType);
        }
        if (type instanceof NameQualifiedType) {
            NameQualifiedType nameQualified = (NameQualifiedType)type;
            LeafType leftType = UMLType.extractTypeObject(nameQualified.getQualifier().getFullyQualifiedName());
            LeafType rightType = UMLType.extractTypeObject(nameQualified.getName().getFullyQualifiedName());
            NameQualifiedType annotatableType = nameQualified;
            List annotations = annotatableType.annotations();
            for (Annotation annotation : annotations) {
                rightType.annotations.add(new UMLAnnotation(cu, filePath, annotation));
            }
            return new CompositeType(leftType, rightType);
        }
        if (type instanceof org.eclipse.jdt.core.dom.WildcardType) {
            org.eclipse.jdt.core.dom.WildcardType wildcard = (org.eclipse.jdt.core.dom.WildcardType)type;
            WildcardType myWildcardType = null;
            if (wildcard.getBound() != null) {
                UMLType bound = UMLType.extractTypeObject(cu, filePath, wildcard.getBound());
                myWildcardType = new WildcardType(bound, wildcard.isUpperBound());
            } else {
                myWildcardType = new WildcardType(null, false);
            }
            org.eclipse.jdt.core.dom.WildcardType annotatableType = wildcard;
            List annotations = annotatableType.annotations();
            for (Annotation annotation : annotations) {
                myWildcardType.annotations.add(new UMLAnnotation(cu, filePath, annotation));
            }
            return myWildcardType;
        }
        if (type instanceof ArrayType) {
            ArrayType array = (ArrayType)type;
            UMLType arrayType = UMLType.extractTypeObject(cu, filePath, array.getElementType());
            arrayType.arrayDimension = array.getDimensions();
            return arrayType;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterized = (ParameterizedType)type;
            UMLType container = UMLType.extractTypeObject(cu, filePath, parameterized.getType());
            List typeArguments = parameterized.typeArguments();
            for (Type argument : typeArguments) {
                container.typeArguments.add(UMLType.extractTypeObject(cu, filePath, argument));
            }
            return container;
        }
        if (type instanceof UnionType) {
            UnionType union = (UnionType)type;
            List types = union.types();
            ArrayList<UMLType> umlTypes = new ArrayList<UMLType>();
            for (Type unionType : types) {
                umlTypes.add(UMLType.extractTypeObject(cu, filePath, unionType));
            }
            return new ListCompositeType(umlTypes, ListCompositeType.Kind.UNION);
        }
        if (type instanceof IntersectionType) {
            IntersectionType intersection = (IntersectionType)type;
            List types = intersection.types();
            ArrayList<UMLType> umlTypes = new ArrayList<UMLType>();
            for (Type unionType : types) {
                umlTypes.add(UMLType.extractTypeObject(cu, filePath, unionType));
            }
            return new ListCompositeType(umlTypes, ListCompositeType.Kind.INTERSECTION);
        }
        return null;
    }
}

